/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.core.util;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class HttpTookit {
    public static final int connTimeout = 10000;
    public static final int readTimeout = 10000;
    public static final String charset = "UTF-8";
    private static CloseableHttpClient client = null;

    public static String postParam(String url, Map<String, String> headers, JSONObject jsonObject) throws ConnectTimeoutException, SocketTimeoutException, Exception {
        return HttpTookit.post(url, headers, jsonObject, "application/json", charset, 10000, 10000);
    }

    public static String get(String url) throws Exception {
        return HttpTookit.get(url, charset, null, null);
    }

    public static String get(String url, String charset) throws Exception {
        return HttpTookit.get(url, charset, 10000, 10000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, Map<String, String> headers, JSONObject jsonObject, String mimeType, String charset, Integer connTimeout, Integer readTimeout) throws ConnectTimeoutException, SocketTimeoutException, Exception {
        CloseableHttpClient client = null;
        HttpPost post = new HttpPost(url);
        String result = "";
        try {
            CloseableHttpResponse res;
            StringEntity entity = new StringEntity(jsonObject.toString(), ContentType.create((String)mimeType, (String)charset));
            post.setEntity((HttpEntity)entity);
            if (headers != null && !headers.isEmpty()) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    post.addHeader(entry.getKey(), entry.getValue());
                }
            }
            RequestConfig.Builder customReqConf = RequestConfig.custom();
            if (connTimeout != null) {
                customReqConf.setConnectTimeout(connTimeout.intValue());
            }
            if (readTimeout != null) {
                customReqConf.setSocketTimeout(readTimeout.intValue());
            }
            post.setConfig(customReqConf.build());
            if (url.startsWith("https")) {
                client = HttpTookit.createSSLInsecureClient();
                res = client.execute((HttpUriRequest)post);
            } else {
                client = HttpTookit.client;
                res = client.execute((HttpUriRequest)post);
            }
            result = IOUtils.toString((InputStream)res.getEntity().getContent(), (String)charset);
        }
        finally {
            post.releaseConnection();
            if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
                client.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url, String charset, Integer connTimeout, Integer readTimeout) throws ConnectTimeoutException, SocketTimeoutException, Exception {
        CloseableHttpClient client = null;
        HttpGet get = new HttpGet(url);
        String result = "";
        try {
            RequestConfig.Builder customReqConf = RequestConfig.custom();
            if (connTimeout != null) {
                customReqConf.setConnectTimeout(connTimeout.intValue());
            }
            if (readTimeout != null) {
                customReqConf.setSocketTimeout(readTimeout.intValue());
            }
            get.setConfig(customReqConf.build());
            CloseableHttpResponse res = null;
            if (url.startsWith("https")) {
                client = HttpTookit.createSSLInsecureClient();
                res = client.execute((HttpUriRequest)get);
            } else {
                client = HttpTookit.client;
                res = client.execute((HttpUriRequest)get);
            }
            result = IOUtils.toString((InputStream)res.getEntity().getContent(), (String)charset);
        }
        finally {
            get.releaseConnection();
            if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
                client.close();
            }
        }
        return result;
    }

    private static String getCharsetFromResponse(HttpResponse ressponse) {
        String contentType;
        if (ressponse.getEntity() != null && ressponse.getEntity().getContentType() != null && ressponse.getEntity().getContentType().getValue() != null && (contentType = ressponse.getEntity().getContentType().getValue()).contains("charset=")) {
            return contentType.substring(contentType.indexOf("charset=") + 8);
        }
        return null;
    }

    private static CloseableHttpClient createSSLInsecureClient() throws GeneralSecurityException {
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        }).build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, new X509HostnameVerifier(){

            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }

            public void verify(String host, SSLSocket ssl) throws IOException {
            }

            public void verify(String host, X509Certificate cert) throws SSLException {
            }

            public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
            }
        });
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
    }

    static {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(128);
        cm.setDefaultMaxPerRoute(128);
        client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
    }
}

