package com.ejianc.framework.core.response;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryParam implements Serializable {
	private static final long serialVersionUID = 1L;

	protected int pageIndex = 1;
	protected int pageSize = 30;
	/** 查询关键字 */
	protected String searchText;
	/** 需要根据关键字模糊查询的字段 */
	protected List<String> fuzzyFields = new ArrayList<>();
	protected Map<String, Parameter> params = new HashMap<>();
	protected Map<String, String> orderMap = new HashMap<String, String>();

	public final static String ASC = "asc";
	public final static String DESC = "desc";

	public final static String EQ = "eq";
	public final static String NE = "ne";
	public final static String IN = "in";
	public final static String NOT_IN = "not_in";
	public final static String LIKE = "like";
	public final static String NOT_LIKE = "not_like";
	public final static String LIKE_LEFT = "like_left";
	public final static String LIKE_RIGHT = "like_right";

	public int getPageIndex() {
		return pageIndex;
	}

	public void setPageIndex(int pageIndex) {
		this.pageIndex = pageIndex;
	}

	public int getPageSize() {
		return pageSize;
	}

	public void setPageSize(int pageSize) {
		this.pageSize = pageSize;
	}

	public String getSearchText() {
		return searchText;
	}

	public void setSearchText(String searchText) {
		this.searchText = searchText;
	}

	public List<String> getFuzzyFields() {
		return fuzzyFields;
	}

	public void setFuzzyFields(List<String> fuzzyFields) {
		this.fuzzyFields = fuzzyFields;
	}

	public Map<String, Parameter> getParams() {
		if(params == null) {
			params = new HashMap<>();
		}
		return params;
	}

	public void setParams(Map<String, Parameter> params) {
		this.params = params;
	}

	public Map<String, String> getOrderMap() {
		return orderMap;
	}

	public void setOrderMap(Map<String, String> orderMap) {
		this.orderMap = orderMap;
	}
}
