/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.core.kit.io;

import com.ejianc.framework.core.kit.text.Charsets;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtil {
    private static Logger logger = LoggerFactory.getLogger(IOUtil.class);

    public static void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            logger.warn("IOException thrown while closing Closeable.", (Throwable)e);
        }
    }

    public static String toString(InputStream input) throws IOException {
        InputStreamReader reader = new InputStreamReader(input, Charsets.UTF_8);
        return IOUtil.toString(reader);
    }

    public static String toString(Reader input) throws IOException {
        return CharStreams.toString((Readable)input);
    }

    public static List<String> toLines(InputStream input) throws IOException {
        return CharStreams.readLines((Readable)new BufferedReader(new InputStreamReader(input, Charsets.UTF_8)));
    }

    public static List<String> toLines(Reader input) throws IOException {
        return CharStreams.readLines((Readable)IOUtil.toBufferedReader(input));
    }

    public static String readLine(InputStream input) throws IOException {
        return new BufferedReader(new InputStreamReader(input, Charsets.UTF_8)).readLine();
    }

    public static String readLine(Reader reader) throws IOException {
        return IOUtil.toBufferedReader(reader).readLine();
    }

    public static void write(String data, OutputStream output) throws IOException {
        if (data != null) {
            output.write(data.getBytes(Charsets.UTF_8));
        }
    }

    public static void write(String data, Writer output) throws IOException {
        if (data != null) {
            output.write(data);
        }
    }

    public static InputStream toInputStream(String input) {
        return new ByteArrayInputStream(input.getBytes(Charsets.UTF_8));
    }

    public static Reader toInputStreamReader(String input) {
        return new InputStreamReader(IOUtil.toInputStream(input), Charsets.UTF_8);
    }

    public static long copy(Reader input, Writer output) throws IOException {
        return CharStreams.copy((Readable)input, (Appendable)output);
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        return ByteStreams.copy((InputStream)input, (OutputStream)output);
    }

    public static BufferedReader toBufferedReader(Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }
}

