/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.core.tree;

import com.ejianc.framework.core.tree.TraversalAction;
import com.ejianc.framework.core.tree.TreeNodeException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicLong;

public abstract class TreeNode<T>
implements Iterable<TreeNode<T>>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final AtomicLong ID_GENERATOR = new AtomicLong(0L);
    private final long id = ID_GENERATOR.getAndIncrement();
    protected TreeNode<T> parent;
    protected T data;

    public TreeNode(T data) {
        this.data = data;
    }

    public TreeNode() {
    }

    public abstract Collection<? extends TreeNode<T>> subtrees();

    public abstract boolean add(TreeNode<T> var1);

    public abstract boolean dropSubtree(TreeNode<T> var1);

    public abstract void clear();

    public abstract TreeNodeIterator iterator();

    public T data() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public TreeNode<T> root() {
        if (this.isRoot()) {
            return this;
        }
        TreeNode<T> node = this;
        while (!(node = node.parent()).isRoot()) {
        }
        return node;
    }

    public TreeNode<T> parent() {
        return this.parent;
    }

    public boolean isLeaf() {
        return this.subtrees().isEmpty();
    }

    public TreeNode<T> find(final T data) {
        if (this.isLeaf()) {
            return (this.data() == null ? data == null : this.data().equals(data)) ? this : null;
        }
        final TreeNode[] searchedNode = (TreeNode[])Array.newInstance(this.getClass(), 1);
        this.traversePreOrder(new TraversalAction<TreeNode<T>>(){

            @Override
            public void perform(TreeNode<T> node) {
                if (node.data() == null ? data == null : node.data().equals(data)) {
                    searchedNode[0] = node;
                }
            }

            @Override
            public boolean isCompleted() {
                return searchedNode[0] != null;
            }
        });
        return searchedNode[0];
    }

    public Collection<? extends TreeNode<T>> findAll(final T data) {
        if (this.isLeaf()) {
            return (this.data() == null ? data == null : this.data().equals(data)) ? Collections.singleton(this) : Collections.emptySet();
        }
        final HashSet searchedNodes = new HashSet();
        this.traversePreOrder(new TraversalAction<TreeNode<T>>(){

            @Override
            public void perform(TreeNode<T> node) {
                if (node.data() == null ? data == null : node.data().equals(data)) {
                    searchedNodes.add(node);
                }
            }

            @Override
            public boolean isCompleted() {
                return false;
            }
        });
        return searchedNodes;
    }

    public boolean hasSubtree(TreeNode<T> subtree) {
        if (subtree == null || this.isLeaf() || subtree.isRoot()) {
            return false;
        }
        for (TreeNode<T> mSubtree : this.subtrees()) {
            if (!mSubtree.equals(subtree)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(TreeNode<T> node) {
        if (node == null || this.isLeaf() || node.isRoot()) {
            return false;
        }
        for (TreeNode<T> subtree : this.subtrees()) {
            if (!subtree.equals(node) && !subtree.contains(node)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection<TreeNode<T>> nodes) {
        if (this.isLeaf() || TreeNode.areAllNulls(nodes)) {
            return false;
        }
        for (TreeNode<T> node : nodes) {
            if (this.contains(node)) continue;
            return false;
        }
        return true;
    }

    public boolean remove(TreeNode<T> node) {
        if (node == null || this.isLeaf() || node.isRoot()) {
            return false;
        }
        if (this.dropSubtree(node)) {
            return true;
        }
        for (TreeNode<T> subtree : this.subtrees()) {
            if (!subtree.remove(node)) continue;
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection<TreeNode<T>> nodes) {
        if (this.isLeaf() || TreeNode.areAllNulls(nodes)) {
            return false;
        }
        boolean result = false;
        for (TreeNode<T> node : nodes) {
            boolean currentResult = this.remove(node);
            if (result || !currentResult) continue;
            result = true;
        }
        return result;
    }

    public void traversePreOrder(TraversalAction<TreeNode<T>> action) {
        if (!action.isCompleted()) {
            action.perform(this);
            if (!this.isLeaf()) {
                for (TreeNode<TreeNode<TreeNode>> treeNode : this.subtrees()) {
                    treeNode.traversePreOrder(action);
                }
            }
        }
    }

    public void traversePostOrder(TraversalAction<TreeNode<T>> action) {
        if (!action.isCompleted()) {
            if (!this.isLeaf()) {
                for (TreeNode<T> subtree : this.subtrees()) {
                    subtree.traversePostOrder(action);
                }
            }
            action.perform(this);
        }
    }

    public Collection<TreeNode<T>> preOrdered() {
        if (this.isLeaf()) {
            return Collections.singleton(this);
        }
        ArrayList<TreeNode<T>> mPreOrdered = new ArrayList<TreeNode<T>>();
        TraversalAction<TreeNode<T>> action = TreeNode.populateAction(mPreOrdered);
        this.traversePreOrder(action);
        return mPreOrdered;
    }

    public Collection<TreeNode<T>> postOrdered() {
        if (this.isLeaf()) {
            return Collections.singleton(this);
        }
        ArrayList<TreeNode<T>> mPostOrdered = new ArrayList<TreeNode<T>>();
        TraversalAction<TreeNode<T>> action = TreeNode.populateAction(mPostOrdered);
        this.traversePostOrder(action);
        return mPostOrdered;
    }

    public Collection<? extends TreeNode<T>> path(TreeNode<T> descendant) {
        if (descendant == null || this.isLeaf() || this.equals(descendant)) {
            return Collections.singletonList(this);
        }
        String errorMessage = "Unable to build the path between tree nodes. ";
        if (descendant.isRoot()) {
            String message = String.format(errorMessage + "Current node %1$s is root", descendant);
            throw new TreeNodeException(message);
        }
        LinkedList<TreeNode<T>> path = new LinkedList<TreeNode<T>>();
        TreeNode<T> node = descendant;
        path.add(node);
        do {
            node = node.parent();
            path.add(0, node);
            if (!this.equals(node)) continue;
            return path;
        } while (!node.isRoot());
        String message = String.format(errorMessage + "The specified tree node %1$s is not the descendant of tree node %2$s", descendant, this);
        throw new TreeNodeException(message);
    }

    public TreeNode<T> commonAncestor(TreeNode<T> node) {
        int thatNodeLevel;
        String errorMessage = "Unable to find the common ancestor between tree nodes. ";
        if (node == null) {
            String message = errorMessage + "The specified tree node is null";
            throw new TreeNodeException(message);
        }
        if (!this.root().contains(node)) {
            String message = String.format(errorMessage + "The specified tree node %1$s was not found in the current tree node %2$s", node, this);
            throw new TreeNodeException(message);
        }
        if (this.isRoot() || node.isRoot()) {
            String message = String.format(errorMessage + "The tree node %1$s is root", this.isRoot() ? this : node);
            throw new TreeNodeException(message);
        }
        if (this.equals(node) || node.isSiblingOf(this)) {
            return this.parent();
        }
        int thisNodeLevel = this.level();
        return thisNodeLevel > (thatNodeLevel = node.level()) ? node.parent() : this.parent();
    }

    public boolean isSiblingOf(TreeNode<T> node) {
        return node != null && !this.isRoot() && !node.isRoot() && this.parent().equals(node.parent());
    }

    public boolean isAncestorOf(TreeNode<T> node) {
        if (node == null || this.isLeaf() || node.isRoot() || this.equals(node)) {
            return false;
        }
        TreeNode<T> mNode = node;
        do {
            if (!this.equals(mNode = mNode.parent())) continue;
            return true;
        } while (!mNode.isRoot());
        return false;
    }

    public boolean isDescendantOf(TreeNode<T> node) {
        if (node == null || this.isRoot() || node.isLeaf() || this.equals(node)) {
            return false;
        }
        TreeNode<T> mNode = this;
        do {
            if (!node.equals(mNode = mNode.parent())) continue;
            return true;
        } while (!mNode.isRoot());
        return false;
    }

    public long size() {
        if (this.isLeaf()) {
            return 1L;
        }
        final long[] count = new long[]{0L};
        TraversalAction action = new TraversalAction<TreeNode<T>>(){

            @Override
            public void perform(TreeNode<T> node) {
                count[0] = count[0] + 1L;
            }

            @Override
            public boolean isCompleted() {
                return false;
            }
        };
        this.traversePreOrder(action);
        return count[0];
    }

    public int height() {
        if (this.isLeaf()) {
            return 0;
        }
        int height = 0;
        for (TreeNode<T> subtree : this.subtrees()) {
            height = Math.max(height, subtree.height());
        }
        return height + 1;
    }

    public int level() {
        if (this.isRoot()) {
            return 0;
        }
        int level = 0;
        TreeNode<T> node = this;
        do {
            node = node.parent();
            ++level;
        } while (!node.isRoot());
        return level;
    }

    public TreeNode<T> clone() {
        try {
            return (TreeNode)super.clone();
        }
        catch (CloneNotSupportedException e) {
            String message = "Unable to clone the current tree node";
            throw new TreeNodeException(message, e);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TreeNode that = (TreeNode)obj;
        return this.id == that.id;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public String toString() {
        final StringBuilder builder = new StringBuilder();
        builder.append("\n");
        final int topNodeLevel = this.level();
        TraversalAction action = new TraversalAction<TreeNode<T>>(){

            @Override
            public void perform(TreeNode<T> node) {
                int nodeLevel = node.level() - topNodeLevel;
                for (int i = 0; i < nodeLevel; ++i) {
                    builder.append("|  ");
                }
                builder.append("+- ").append(node.data()).append("\n");
            }

            @Override
            public boolean isCompleted() {
                return false;
            }
        };
        this.traversePreOrder(action);
        return builder.toString();
    }

    protected static <T> TraversalAction<TreeNode<T>> populateAction(final Collection<TreeNode<T>> collection) {
        return new TraversalAction<TreeNode<T>>(){

            @Override
            public void perform(TreeNode<T> node) {
                collection.add(node);
            }

            @Override
            public boolean isCompleted() {
                return false;
            }
        };
    }

    protected static <T> void linkParent(TreeNode<T> node, TreeNode<T> parent) {
        if (node != null) {
            node.parent = parent;
        }
    }

    protected static <T> void unlinkParent(TreeNode<T> node) {
        node.parent = null;
    }

    protected static <T> boolean isAnyNotNull(Collection<T> collection) {
        if (collection == null || collection.isEmpty()) {
            return false;
        }
        for (T item : collection) {
            if (item == null) continue;
            return true;
        }
        return false;
    }

    protected static <T> boolean areAllNulls(Collection<T> collection) {
        return !TreeNode.isAnyNotNull(collection);
    }

    protected abstract class TreeNodeIterator
    implements Iterator<TreeNode<T>> {
        private long expectedSize;
        private TreeNode<T> currentNode;
        private TreeNode<T> nextNode;
        private boolean nextNodeAvailable;

        protected TreeNodeIterator() {
            this.expectedSize = TreeNode.this.size();
            this.nextNode = TreeNode.this;
            this.nextNodeAvailable = true;
        }

        protected abstract TreeNode<T> leftMostNode();

        protected abstract TreeNode<T> rightSiblingNode();

        private TreeNode<T> checkAndGetLeftMostNode() {
            if (TreeNode.this.isLeaf()) {
                throw new TreeNodeException("Leftmost node can't be obtained. Current tree node is a leaf");
            }
            return this.leftMostNode();
        }

        private TreeNode<T> checkAndGetRightSiblingNode() {
            if (TreeNode.this.isRoot()) {
                throw new TreeNodeException("Right sibling node can't be obtained. Current tree node is root");
            }
            return this.rightSiblingNode();
        }

        @Override
        public boolean hasNext() {
            return this.nextNodeAvailable;
        }

        @Override
        public TreeNode<T> next() {
            block6: {
                this.checkForConcurrentModification();
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.currentNode = this.nextNode;
                if (this.nextNode.isLeaf()) {
                    if (this.nextNode.isRoot()) {
                        this.nextNodeAvailable = false;
                    } else {
                        TreeNode currentNode;
                        TreeNode nextSibling;
                        do {
                            currentNode = this.nextNode;
                            this.nextNode = this.nextNode.parent();
                            if (!currentNode.equals(TreeNode.this)) continue;
                            this.nextNodeAvailable = false;
                            break block6;
                        } while ((nextSibling = currentNode.iterator().checkAndGetRightSiblingNode()) == null);
                        this.nextNode = nextSibling;
                    }
                } else {
                    this.nextNode = this.nextNode.iterator().checkAndGetLeftMostNode();
                }
            }
            return this.currentNode;
        }

        private void checkForConcurrentModification() {
            if (this.expectedSize != TreeNode.this.size()) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void remove() {
            String errorMessage = "Failed to remove the tree node. ";
            if (!this.isIterationStarted()) {
                throw new IllegalStateException(errorMessage + "The iteration has not been performed yet");
            }
            if (this.currentNode.isRoot()) {
                String message = String.format(errorMessage + "The tree node %1$s is root", this.currentNode);
                throw new TreeNodeException(message);
            }
            if (this.currentNode.equals(TreeNode.this)) {
                throw new TreeNodeException(errorMessage + "The starting node can't be removed");
            }
            this.checkForConcurrentModification();
            TreeNode currentNode = this.currentNode;
            while (true) {
                if (currentNode.isRoot()) {
                    this.nextNodeAvailable = false;
                    break;
                }
                TreeNode rightSiblingNode = currentNode.iterator().checkAndGetRightSiblingNode();
                if (rightSiblingNode != null) {
                    this.nextNode = rightSiblingNode;
                    break;
                }
                currentNode = currentNode.parent;
            }
            TreeNode parent = this.currentNode.parent();
            parent.dropSubtree(this.currentNode);
            this.currentNode = parent;
            this.expectedSize = TreeNode.this.size();
        }

        private boolean isIterationStarted() {
            return this.currentNode != null;
        }
    }
}

