/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.core.exception;

import com.ejianc.framework.core.exception.IErrorEnum;

public enum ErrorEnum implements IErrorEnum
{
    STATUS_COMMON_EXCEPTION(1, "\u901a\u7528\u5f02\u5e38\u9519\u8bef"),
    STATUS_PARAM_ERROR(-9998, "\u53c2\u6570\u9a8c\u8bc1\u5931\u8d25"),
    STATUS_UNLOGIN_ERROR(-9997, "\u7528\u6237\u672a\u767b\u5f55"),
    STATUS_PERMISSION_DENIED_ERROR(-9996, "\u6ca1\u6709\u6743\u9650"),
    STATUS_VALIDATE_CODE_ERROR(-9995, "\u9a8c\u8bc1\u7801\u9519\u8bef"),
    STATUS_INVITATION_CODE_ERROR(-9994, "\u9080\u8bf7\u7801\u4e0d\u5b58\u5728"),
    STATUS_CONCURENT_CODE_ERROR(-9993, "\u5e76\u53d1\u64cd\u4f5c\u5931\u8d25"),
    STATUS_FREQUENT_CODE_ERROR(-9992, "\u64cd\u4f5c\u592a\u9891\u7e41"),
    STATUS_RETRY_CODE_ERROR(-9991, "\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c"),
    STATUS_DATA_DUPLICATION_CODE_ERROR(-9990, "\u6570\u636e\u91cd\u590d"),
    STATUS_INSERT_ERROR(-9989, "\u65b0\u589e\u5931\u8d25"),
    STATUS_UPDATE_ERROR(-9988, "\u66f4\u65b0\u5931\u8d25"),
    STATUS_DELETE_ERROR(-9987, "\u5220\u9664\u5931\u8d25");

    private final Integer errorCode;
    private final String errorMsg;

    @Override
    public Integer getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    private ErrorEnum(Integer errorCode, String errorMsg) {
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
    }

    public static ErrorEnum getErrorByCode(Integer errorCode) {
        if (null == errorCode) {
            return null;
        }
        for (ErrorEnum errorEnum : ErrorEnum.values()) {
            if (errorEnum.getErrorCode() != errorCode) continue;
            return errorEnum;
        }
        return null;
    }

    public static String getErrorMsgByCode(Integer errorCode) {
        if (errorCode == null) {
            return "";
        }
        ErrorEnum errorEnum = ErrorEnum.getErrorByCode(errorCode);
        if (null != errorEnum) {
            return errorEnum.getErrorMsg();
        }
        return "";
    }

    public String toString() {
        return "ReturnEnum{code='" + this.errorCode + '\'' + ", message='" + this.errorMsg + '\'' + '}';
    }
}

