/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.core.util;

import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.FileUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.web.multipart.MultipartFile;

public class ExcelReader {
    public static List<List<String>> readExcel(MultipartFile file) {
        String originalFileName = file.getOriginalFilename();
        String extName = null;
        originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
        originalFileName.replaceAll("00.", "");
        extName = FileUtils.getFileExt(originalFileName, false);
        if ("xls".equals(extName)) {
            return ExcelReader.read2003Excel(file);
        }
        if ("xlsx".equals(extName)) {
            return ExcelReader.read2007Excel(file);
        }
        throw new BusinessException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b");
    }

    private static List<List<String>> read2003Excel(MultipartFile file) {
        HSSFWorkbook hwb;
        LinkedList<List<String>> list = new LinkedList<List<String>>();
        try {
            hwb = new HSSFWorkbook((InputStream)new BufferedInputStream(file.getInputStream()));
        }
        catch (IOException e) {
            throw new BusinessException(e.getMessage());
        }
        HSSFSheet sheet = hwb.getSheetAt(0);
        String value = null;
        HSSFRow row = null;
        HSSFCell cell = null;
        boolean isEmpty = true;
        int rowFirstCellNum = 0;
        int rowLastCellNum = 0;
        for (int i = sheet.getFirstRowNum(); i < sheet.getPhysicalNumberOfRows(); ++i) {
            isEmpty = true;
            row = sheet.getRow(i);
            if (row == null) continue;
            if (i == 0) {
                rowLastCellNum = row.getLastCellNum();
            }
            LinkedList<String> linked = new LinkedList<String>();
            for (int j = rowFirstCellNum; j < rowLastCellNum; ++j) {
                cell = row.getCell(j);
                if (cell == null) {
                    linked.add("");
                    continue;
                }
                switch (cell.getCellType()) {
                    case 0: {
                        String[] item;
                        Double d = cell.getNumericCellValue();
                        value = d.toString();
                        if (null == value || "".equals(value.trim()) || 1 >= (item = value.split("[.]")).length || !"0".equals(item[1]) && !"00".equals(item[1]) && !"000".equals(item[1]) && !"0000".equals(item[1])) break;
                        value = item[0];
                        break;
                    }
                    case 1: {
                        value = cell.getStringCellValue().toString();
                        break;
                    }
                    case 2: {
                        value = String.valueOf(cell.getNumericCellValue());
                        if (!value.equals("NaN")) break;
                        value = cell.getStringCellValue().toString();
                        break;
                    }
                    case 4: {
                        value = " " + cell.getBooleanCellValue();
                        break;
                    }
                    default: {
                        value = cell.getStringCellValue() + "";
                    }
                }
                linked.add(value);
            }
            if (list.size() > 0) {
                int headLength = ((List)list.get(0)).size();
                int n = linked.size();
                if (n < headLength) {
                    for (int k = n; k < headLength; ++k) {
                        linked.add(null);
                    }
                }
            }
            if (isEmpty) {
                for (Object e : linked) {
                    if (e == null || !StringUtils.isNotBlank((CharSequence)String.valueOf(e))) continue;
                    isEmpty = false;
                    break;
                }
            }
            if (isEmpty) break;
            list.add(linked);
        }
        return list;
    }

    private static List<List<String>> read2007Excel(MultipartFile file) {
        XSSFWorkbook xwb;
        LinkedList<List<String>> list = new LinkedList<List<String>>();
        try {
            xwb = new XSSFWorkbook((InputStream)new BufferedInputStream(file.getInputStream()));
        }
        catch (IOException e) {
            throw new BusinessException(e.getMessage());
        }
        XSSFSheet sheet = xwb.getSheetAt(0);
        String value = null;
        XSSFRow row = null;
        XSSFCell cell = null;
        boolean isEmpty = true;
        int rowFirstCellNum = 0;
        int rowLastCellNum = 0;
        for (int i = sheet.getFirstRowNum(); i < sheet.getPhysicalNumberOfRows(); ++i) {
            isEmpty = true;
            row = sheet.getRow(i);
            if (i == 0) {
                rowLastCellNum = row.getLastCellNum();
            }
            if (row == null) continue;
            LinkedList<String> linked = new LinkedList<String>();
            for (int j = rowFirstCellNum; j < rowLastCellNum; ++j) {
                cell = row.getCell(j);
                if (cell == null) {
                    linked.add("");
                    continue;
                }
                switch (cell.getCellType()) {
                    case 0: {
                        String[] item;
                        Double d = cell.getNumericCellValue();
                        value = d.toString();
                        if (null == value || "".equals(value.trim()) || 1 >= (item = value.split("[.]")).length || !"0".equals(item[1]) && !"00".equals(item[1]) && !"000".equals(item[1]) && !"0000".equals(item[1])) break;
                        value = item[0];
                        break;
                    }
                    case 1: {
                        value = cell.getStringCellValue().toString();
                        break;
                    }
                    case 2: {
                        value = String.valueOf(cell.getNumericCellValue());
                        if (!value.equals("NaN")) break;
                        value = cell.getStringCellValue().toString();
                        break;
                    }
                    case 4: {
                        value = " " + cell.getBooleanCellValue();
                        break;
                    }
                    default: {
                        value = cell.getStringCellValue() + "";
                    }
                }
                linked.add(value);
            }
            if (list.size() > 0) {
                int headLength = ((List)list.get(0)).size();
                int n = linked.size();
                if (n < headLength) {
                    for (int k = n; k < headLength; ++k) {
                        linked.add(null);
                    }
                }
            }
            if (isEmpty) {
                for (Object e : linked) {
                    if (e == null || !StringUtils.isNotBlank((CharSequence)String.valueOf(e))) continue;
                    isEmpty = false;
                    break;
                }
            }
            if (isEmpty) break;
            list.add(linked);
        }
        return list;
    }
}

