/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.core.kit.base;

import com.ejianc.framework.core.kit.base.annotation.Nullable;
import com.google.common.base.Objects;
import java.util.Arrays;

public class ObjectUtil {
    private static final String NULL = "null";

    public static boolean equals(@Nullable Object a, @Nullable Object b) {
        return Objects.equal((Object)a, (Object)b);
    }

    public static int hashCode(Object ... objects) {
        return Arrays.hashCode(objects);
    }

    public static String toPrettyString(Object value) {
        if (value == null) {
            return NULL;
        }
        Class<?> type = value.getClass();
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            if (componentType.isPrimitive()) {
                return ObjectUtil.primitiveArrayToString(value, componentType);
            }
            return ObjectUtil.objectArrayToString(value);
        }
        if (value instanceof Iterable) {
            return ObjectUtil.collectionToString(value);
        }
        return value.toString();
    }

    private static String primitiveArrayToString(Object value, Class componentType) {
        StringBuilder sb = new StringBuilder();
        if (componentType == Integer.TYPE) {
            sb.append(Arrays.toString((int[])value));
        } else if (componentType == Long.TYPE) {
            sb.append(Arrays.toString((long[])value));
        } else if (componentType == Double.TYPE) {
            sb.append(Arrays.toString((double[])value));
        } else if (componentType == Float.TYPE) {
            sb.append(Arrays.toString((float[])value));
        } else if (componentType == Boolean.TYPE) {
            sb.append(Arrays.toString((boolean[])value));
        } else if (componentType == Short.TYPE) {
            sb.append(Arrays.toString((short[])value));
        } else if (componentType == Byte.TYPE) {
            sb.append(Arrays.toString((byte[])value));
        } else if (componentType == Character.TYPE) {
            sb.append(Arrays.toString((char[])value));
        } else {
            throw new IllegalArgumentException("unsupport array type");
        }
        return sb.toString();
    }

    private static String objectArrayToString(Object value) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        Object[] array = (Object[])value;
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(ObjectUtil.toPrettyString(array[i]));
        }
        sb.append(']');
        return sb.toString();
    }

    private static String collectionToString(Object value) {
        Iterable iterable = (Iterable)value;
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        int i = 0;
        for (Object o : iterable) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(ObjectUtil.toPrettyString(o));
            ++i;
        }
        sb.append('}');
        return sb.toString();
    }
}

