package com.ejianc.framework.core.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class FileUtils {

	/**
	 * 将字节数组转为base64字符串
	 * 
	 * @param bytes
	 * @return
	 */
	public static String base64Encode(byte[] bytes) {
		Base64 base64 = new Base64();
		return new String(base64.encode(bytes));
	}

	/**
	 * 将base64字符串转为字节数组
	 * 
	 * @param base64Str
	 * @return
	 */
	public static byte[] base64Decode(String base64Str) {
		Base64 base64 = new Base64();
		return base64.decode(base64Str);
	}

	/**
	 * 获得指定文件的byte数组
	 * 
	 * @param filePath
	 * @return
	 */
	public static byte[] getBytes(String filePath) {
		byte[] buffer = null;
		try {
			File file = new File(filePath);
			FileInputStream fis = new FileInputStream(file);
			ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
			byte[] b = new byte[1000];
			int n;
			while ((n = fis.read(b)) != -1) {
				bos.write(b, 0, n);
			}
			fis.close();
			bos.close();
			buffer = bos.toByteArray();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return buffer;
	}

	/**
	 * 根据byte数组，生成文件
	 * 
	 * @param bytes
	 * @param filePath
	 * @param fileName
	 */
	public static void createFile(byte[] bytes, String filePath, String fileName) throws Exception {
		BufferedOutputStream bos = null;
		FileOutputStream fos = null;
		File file;
		try {
			File dir = new File(filePath);
			if (!dir.exists() && dir.isDirectory()) {// 判断文件目录是否存在
				dir.mkdirs();
			}
			file = new File(filePath + File.separator + fileName);
			fos = new FileOutputStream(file);
			bos = new BufferedOutputStream(fos);
			bos.write(bytes);
		} catch (Exception e) {
			e.printStackTrace();
			throw new Exception("文件生成失败："+e.getMessage());
		} finally {
			if (bos != null) {
				try {
					bos.close();
				} catch (IOException e1) {
					e1.printStackTrace();
				}
			}
			if (fos != null) {
				try {
					fos.close();
				} catch (IOException e1) {
					e1.printStackTrace();
				}
			}
		}
	}

	/**
	 * 获取文件后缀格式
	 * @param filename
	 * @return 文件后缀格式 eg:  (.jpg)
	 */
	public static String getFileExt(String filename,Boolean withPoint) {
		if(StringUtils.isEmpty(filename) || filename.lastIndexOf('.') == -1) {
			return "";
		}
		if(withPoint==null){
			withPoint = true;
		}
		int index = -1;
		if(withPoint){
			index = filename.lastIndexOf('.');
		}else{
			index = filename.lastIndexOf('.')+1;
		}
		String extName = filename.substring(index).toLowerCase();
		return extName;
	}

	private FileUtils(){}

	public static void main(String[] args) {
		try {
			byte[] bytes = getBytes("D:/doc/设备原型问题列表.docx");
			String base64Code = base64Encode(bytes);
			byte[] newBytes = base64Decode(base64Code);
			createFile(newBytes, "D:/", "1.docx");
		} catch (Exception e) {
			e.printStackTrace();

		}

	}
}
