/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.core.http;

import com.ejianc.framework.core.http.Header;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.Response;

public abstract class HttpResponseHandler
implements Callback {
    public void onFailure(Call call, IOException e) {
        this.onFailure(-1, e.getMessage().getBytes());
    }

    public void onResponse(Call call, Response response) throws IOException {
        int code = response.code();
        byte[] body = response.body().bytes();
        if (code > 299) {
            this.onFailure(response.code(), body);
        } else {
            Headers headers = response.headers();
            Header[] hs = new Header[headers.size()];
            for (int i = 0; i < headers.size(); ++i) {
                hs[i] = new Header(headers.name(i), headers.value(i));
            }
            this.onSuccess(code, hs, body);
        }
    }

    public void onFailure(int status, byte[] data) {
    }

    public abstract void onSuccess(int var1, Header[] var2, byte[] var3);
}

