/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.core.response;

import com.ejianc.framework.core.exception.IErrorEnum;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CommonResponse<T>
implements Serializable {
    private static final long serialVersionUID = 2045521669273048261L;
    public static final int SUCCESS = 0;
    public static final int FAILED = 1;
    private int code = 0;
    private String msg = "";
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Throwable cause;
    private T data = null;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, Object> attachments = new HashMap<String, Object>();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private boolean thisTimeDone = true;

    @JsonIgnore
    public boolean isSuccess() {
        return this.getCode() == 0;
    }

    public static <T> CommonResponse<T> success(T data) {
        return CommonResponse.success("success", data);
    }

    public static <T> CommonResponse<T> success() {
        CommonResponse<T> result = new CommonResponse<T>();
        result.setCode(0);
        return result;
    }

    public static <T> CommonResponse<T> success(String msg) {
        CommonResponse<T> result = new CommonResponse<T>();
        result.setCode(0);
        result.setMsg(msg);
        return result;
    }

    public static <T> CommonResponse<T> success(String msg, T data) {
        CommonResponse<T> result = new CommonResponse<T>();
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            result.setMsg(msg);
        }
        result.setCode(0);
        result.setData(data);
        return result;
    }

    public static <T> CommonResponse<T> error(String msg) {
        return CommonResponse.error(msg, null);
    }

    public static CommonResponse<Object> error(String msg, Object object) {
        CommonResponse<Object> result = new CommonResponse<Object>();
        result.setCode(1);
        result.setMsg(msg);
        result.setData(object);
        return result;
    }

    public static <T> CommonResponse<T> error(int code, String msg) {
        return CommonResponse.error(code, msg, null);
    }

    public static <T> CommonResponse<T> error(String msg, Throwable cause) {
        return CommonResponse.error(1, msg, cause);
    }

    public static <T> CommonResponse<T> error(int code, String msg, Throwable cause) {
        CommonResponse<T> result = new CommonResponse<T>();
        result.setCode(code);
        result.setMsg(msg);
        result.setCause(cause);
        return result;
    }

    public static <T> CommonResponse<T> error(IErrorEnum errorEnum) {
        return CommonResponse.error(errorEnum.getErrorCode(), errorEnum.getErrorMsg());
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public void setCause(Throwable cause) {
        this.cause = cause;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public Map<String, Object> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(Map<String, Object> map) {
        if (map != null && map.size() > 0) {
            this.attachments.putAll(map);
        }
    }

    public void addAttachment(String key, Object att) {
        this.attachments.put(key, att);
    }

    public Object getAttachment(String key) {
        return this.attachments.get(key);
    }

    public boolean isThisTimeDone() {
        return this.thisTimeDone;
    }

    public void setThisTimeDone(boolean thisTimeDone) {
        this.thisTimeDone = thisTimeDone;
    }

    public <D> CommonResponse<D> duplicate(D data) {
        CommonResponse<D> serviceResult = new CommonResponse<D>();
        serviceResult.setData(data);
        serviceResult.setCode(this.getCode());
        serviceResult.setMsg(this.getMsg());
        serviceResult.setCause(this.getCause());
        serviceResult.setAttachments(this.getAttachments());
        return serviceResult;
    }
}

