package com.ejianc.framework.core.response;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum BillStateEnum  {
	
	UNCOMMITED_STATE(0, "自由态"),
	COMMITED_STATE(1, "已提交"),
	APPROVING_HAS_STATE(2, "审核中（有人审核）"),
	PASSED_STATE(3, "已通过"),
	UNAPPROVED(4, "审批驳回"),
	APPROVING_UNEXAM_STATE(5, "审核中(有审批流的提交态)");
	
	
	private final Integer billStateCode;
	private final String description;

	private static Map<Integer, BillStateEnum> enumMap = new HashMap<>();
	
	BillStateEnum(Integer billStateCode, String description) {
        this.billStateCode = billStateCode;
        this.description = description;
    }
	
	public Integer getBillStateCode() {
		return billStateCode;
	}
	public String getDescription() {
		return description;
	}

	static {
		enumMap = EnumSet.allOf(BillStateEnum.class).stream().collect(Collectors.toMap(BillStateEnum::getBillStateCode, Function.identity(), (k1,k2) -> k2));
	}

	public static BillStateEnum getEnumByStateCode(Integer billStateCode) {
		return enumMap.get(billStateCode);
	}
}
