package com.ejianc.framework.core.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.servlet.http.Cookie;

public class CookieUtil {
	public static Cookie createCookie(String key, String value) {
		return createCookie(key, value, true);
	}

	public static Cookie createCookie(String key, String value, boolean httpOnly) {
		try {
			Cookie cookie = new Cookie(key, URLEncoder.encode(value,"utf-8"));
			cookie.setHttpOnly(httpOnly);
			cookie.setMaxAge(-1);
			cookie.setPath("/");
			return cookie;
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		return null;
	}

	public static String findCookieValue(Cookie[] cookies, String key) {
		if (cookies != null) {
			for (Cookie cookie : cookies) {
				if (cookie.getName().equals(key)) {
					try {
						return URLDecoder.decode(cookie.getValue(),"utf-8");
					} catch (UnsupportedEncodingException e) {
						e.printStackTrace();
					}
				}
			}
		}
		return null;
	}

	public static Cookie expireCookieWithPath(String key, String path) {
		Cookie cookie = new Cookie(key, null);
		cookie.setMaxAge(0);
		cookie.setPath(path);
		return cookie;
	}
}