/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.core.kit.collection;

import com.ejianc.framework.core.kit.base.annotation.Nullable;
import com.google.common.collect.ObjectArrays;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;

public class ArrayUtil {
    public static <T> T[] newArray(Class<T> type, int length) {
        return (Object[])Array.newInstance(type, length);
    }

    public static <T> T[] toArray(Collection<T> col, Class<T> type) {
        return col.toArray((Object[])Array.newInstance(type, 0));
    }

    private static void swap(Object[] arr, int i, int j) {
        Object tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }

    public static <T> T[] shuffle(T[] array) {
        if (array != null && array.length > 1) {
            Random rand = new Random();
            return ArrayUtil.shuffle(array, rand);
        }
        return array;
    }

    public static <T> T[] shuffle(T[] array, Random random) {
        if (array != null && array.length > 1 && random != null) {
            for (int i = array.length; i > 1; --i) {
                ArrayUtil.swap(array, i - 1, random.nextInt(i));
            }
        }
        return array;
    }

    public static <T> T[] concat(@Nullable T element, T[] array) {
        return ObjectArrays.concat(element, (Object[])array);
    }

    public static <T> T[] concat(T[] array, @Nullable T element) {
        return ObjectArrays.concat((Object[])array, element);
    }

    public static <T> List<T> asList(T ... a) {
        return Arrays.asList(a);
    }

    public static List<Integer> intAsList(int ... backingArray) {
        return Ints.asList((int[])backingArray);
    }

    public static List<Long> longAsList(long ... backingArray) {
        return Longs.asList((long[])backingArray);
    }

    public static List<Double> doubleAsList(double ... backingArray) {
        return Doubles.asList((double[])backingArray);
    }
}

