package com.ejianc.framework.core.util;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.web.multipart.MultipartFile;

import com.ejianc.framework.core.exception.BusinessException;

@SuppressWarnings("resource")
public class ExcelReader {
	
	/**
	 * 读取Excel方法
	 * 
	 * @param fileName
	 * @param file
	 * @return
	 * @throws IOException
	 */
	public static List<List<String>> readExcel(MultipartFile file) {
		String originalFileName = file.getOriginalFilename();
        String extName = null;
        originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
        originalFileName.replaceAll("00.", "");
    	extName = FileUtils.getFileExt(originalFileName, false);
		
		if ("xls".equals(extName)) {
			return read2003Excel(file);
		} else if ("xlsx".equals(extName)) {
			return read2007Excel(file);
		} else {
			throw new BusinessException("不支持的文件类型");
		}
	}

	/**
	 * 读取 office 2003 excel
	 * 
	 * @throws IOException
	 * @throws FileNotFoundException
	 */
	private static List<List<String>> read2003Excel(MultipartFile file) {
		List<List<String>> list = new LinkedList<>();
		HSSFWorkbook hwb;
		try {
			hwb = new HSSFWorkbook(new BufferedInputStream(file.getInputStream()));
		} catch (IOException e) {
			throw new BusinessException(e.getMessage());
		}
		int size = hwb.getNumberOfSheets();
		HSSFSheet sheet ;
		for (int index = 0; index < size; index++) {
			sheet = hwb.getSheetAt(index);
			String value = null;
			HSSFRow row = null;
			HSSFCell cell = null;
			boolean isEmpty = true;
			int rowFirstCellNum = 0;
			int rowLastCellNum = 0;
			for (int i = sheet.getFirstRowNum()+1; i < sheet.getPhysicalNumberOfRows(); i++) {
				isEmpty = true;
				row = sheet.getRow(i);
				if (row == null) {
					continue;
				}
				rowLastCellNum = sheet.getRow(0).getLastCellNum();
				List<String> linked = new LinkedList<>();
				for (int j = rowFirstCellNum; j < rowLastCellNum; j++) {
					cell = row.getCell(j);
					if (cell == null) {
						linked.add("");
						continue;
					}
					switch (cell.getCellType()) {
						//数值型
						case XSSFCell.CELL_TYPE_NUMERIC:
							// 纯数字
//							Double big=cell.getNumericCellValue();
//							value = big.toString();
			                DecimalFormat df = new DecimalFormat("0");
			                value = df.format(cell.getNumericCellValue());
							//解决1234.0  去掉后面的.0
							if(null!=value&&!"".equals(value.trim())){
								String[] item = value.split("[.]");
								if(1<item.length&&("0".equals(item[1])||"00".equals(item[1])||"000".equals(item[1])||"0000".equals(item[1]))){
									value=item[0];
								}
							}
							break;
						//字符串类型
						case XSSFCell.CELL_TYPE_STRING:
							value = cell.getStringCellValue().toString();
							break;
						// 公式类型
						case XSSFCell.CELL_TYPE_FORMULA:
							//读公式计算值
							value = String.valueOf(cell.getNumericCellValue());
							if (value.equals("NaN")) {// 如果获取的数据值为非法值,则转换为获取字符串
								value = cell.getStringCellValue().toString();
							}
							break;
						// 布尔类型
						case XSSFCell.CELL_TYPE_BOOLEAN:
							value = " "+ cell.getBooleanCellValue();
							break;
						default:
							value = cell.getStringCellValue() + "";
					}
					linked.add(value);
				}

				if(list.size()>0){
					int headLength = list.get(0).size();
					int nowLinkLength = linked.size() ;
					if(nowLinkLength < headLength){
						for(int k=nowLinkLength;k<headLength;k++){
							linked.add(null);
						}
					}
				}

				//判断下linked是否为空
				if(isEmpty) {
					for(Object object:linked) {
						if(object != null && StringUtils.isNotBlank(String.valueOf(object))) {
							isEmpty = false;
							break;
						}
					}
				}
				if(!isEmpty) {
					list.add(linked);
				}else{
					break;
				}
			}
		}
		return list;
	}

	/**
	 * 读取2007数据
	 * 
	 * @param file
	 * @return
	 * @throws IOException
	 */
	private static List<List<String>> read2007Excel(MultipartFile file) {
		List<List<String>> list = new LinkedList<>();
		XSSFWorkbook xwb;
		try {
			xwb = new XSSFWorkbook(new BufferedInputStream(file.getInputStream()));
		} catch (IOException e) {
			throw new BusinessException(e.getMessage());
		}
		int size = xwb.getNumberOfSheets();
		XSSFSheet sheet ;
		for (int index = 0; index < size; index++) {
			sheet = xwb.getSheetAt(index);
			String value = null;
			XSSFRow row = null;
			XSSFCell cell = null;
			boolean isEmpty = true;
			int rowFirstCellNum = 0;
			int rowLastCellNum = 0;
			for (int i = sheet.getFirstRowNum()+1; i < sheet.getPhysicalNumberOfRows(); i++) {
				isEmpty = true;
				row = sheet.getRow(i);
				rowLastCellNum = sheet.getRow(0).getLastCellNum();
				if (row == null) {
					continue;
				}
				List<String> linked = new LinkedList<String>();
				for (int j = rowFirstCellNum; j < rowLastCellNum; j++) {
					cell = row.getCell(j);
					if (cell == null) {
						linked.add("");
						continue;
					}
					switch (cell.getCellType()) {
						//数值型
						case XSSFCell.CELL_TYPE_NUMERIC:
//							Double big=cell.getNumericCellValue();
//							value = big.toString();
			                DecimalFormat df = new DecimalFormat("0");
			                value = df.format(cell.getNumericCellValue());
							//解决1234.0  去掉后面的.0
							if(null!=value&&!"".equals(value.trim())){
								String[] item = value.split("[.]");
								if(1<item.length&&("0".equals(item[1])||"00".equals(item[1])||"000".equals(item[1])||"0000".equals(item[1]))){
									value=item[0];
								}
							}
							break;
						//字符串类型
						case XSSFCell.CELL_TYPE_STRING:
							value = cell.getStringCellValue().toString();
							break;
						// 公式类型
						case XSSFCell.CELL_TYPE_FORMULA:
							//读公式计算值
							value = String.valueOf(cell.getNumericCellValue());
							if (value.equals("NaN")) {// 如果获取的数据值为非法值,则转换为获取字符串
								value = cell.getStringCellValue().toString();
							}
							break;
						// 布尔类型
						case XSSFCell.CELL_TYPE_BOOLEAN:
							value = " "+ cell.getBooleanCellValue();
							break;
						default:
							value = cell.getStringCellValue() + "";
					}
					linked.add(value);
				}

				if(list.size()>0){
					int headLength = list.get(0).size();
					int nowLinkLength = linked.size() ;
					if(nowLinkLength < headLength){
						for(int k=nowLinkLength;k<headLength;k++){
							linked.add(null);
						}
					}
				}
				//判断下linked是否为空
				if(isEmpty) {
					for(Object object:linked) {
						if(object != null && StringUtils.isNotBlank(String.valueOf(object))) {
							isEmpty = false;
							break;
						}
					}
				}
				if(!isEmpty) {
					list.add(linked);
				}else{
					break;
				}
			}
		}
		return list;
	}
}
