package org.springframework.cloud.config.environment;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Simple plain text serializable encapsulation of a named source of key-value pairs.
 * Basically a DTO for {@link PropertySource}, but also applicable outside the domain of a
 * Spring application.
 * 
 * @author Dave Syer
 *
 */
public class PropertySource {

	private String name;

	private Map<?, ?> source;

	@JsonCreator
	public PropertySource(@JsonProperty("name") String name,
			@JsonProperty("source") Map<?, ?> source) {
		this.name = name;
		this.source = source;
	}

	public String getName() {
		return name;
	}

	public Map<?, ?> getSource() {
		return source;
	}

	@Override
	public String toString() {
		return "PropertySource [name=" + name + "]";
	}

}
