package com.ejianc.framework.core.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@SuppressWarnings({"unchecked","rawtypes"})
public class ResultAsTree {
	
	public static List<Map<String, Object>> createTreeData(List<Map> list) {
		List<Map<String, Object>> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();

		//循环list，放入listMap重
		Map<String, Map<String,Object>> listMap = new HashMap<>();
		for(Map<String, Object> item:list) {
			listMap.put(item.get("id").toString(), item);
		}
        
        for(int i =0; i<list.size(); i++) {
        	Map<String, Object> item = list.get(i);
        	String parentId = (item.get("parentId") != null) ? item.get("parentId").toString():"";
        	Map<String, Object> parent = listMap.get(parentId);
        	if(parent != null) {
        		List<Map<String, Object>> child = (List<Map<String, Object>>) parent.get("children");
        		if(child != null) {
        			child.add(item);
        		}else{
        			List<Map<String, Object>> children = new ArrayList<Map<String, Object>>();
        			children.add(item);
        			parent.put("children", children);
        		}
        	} else {
        		rootItems.add(item.get("id").toString());
        	}
        }
        
        for(String rootId : rootItems) {
        	resp.add(listMap.get(rootId));
        }
        
		return resp;
	}

}
