package com.ejianc.business.budget.vo;

import com.ejianc.business.cost.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


/**
 * 实际成本明细对比
 * 
 * @author yqls
 * 
 */
public class BudgetCostReportDetailVO extends BaseVO implements ITreeNodeB {
    private static final long serialVersionUID = 1L;

    private String detailIndex; // 序号  1   1.1
    private String subjectCode; // 科目编码
    private String subjectName; // 科目名称
    private Long parentId; // 父级主键
    private Integer leafFlag; // 是否末级
    private BigDecimal costMny; // 成本金额
    private BigDecimal budgetMny; // 预算金额
    private BigDecimal budgetCostMny; // 预算-成本
    private Long projectId; // 项目主键
    private String projectName; // 项目名称
    private List<ITreeNodeB> children;

    public String getDetailIndex() {
        return detailIndex;
    }

    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }

    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Integer getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Integer leafFlag) {
        this.leafFlag = leafFlag;
    }

    public BigDecimal getCostMny() {
        return costMny;
    }

    public void setCostMny(BigDecimal costMny) {
        this.costMny = costMny;
    }

    public BigDecimal getBudgetMny() {
        return budgetMny;
    }

    public void setBudgetMny(BigDecimal budgetMny) {
        this.budgetMny = budgetMny;
    }

    public BigDecimal getBudgetCostMny() {
        return budgetCostMny;
    }

    public void setBudgetCostMny(BigDecimal budgetCostMny) {
        this.budgetCostMny = budgetCostMny;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }

    public void setChildren(List<ITreeNodeB> children) {
        this.children = children;
    }
}
