package com.ejianc.business.budget.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.fieldCompare.CompareDifferenceUtil;
import com.ejianc.framework.skeleton.fieldCompare.DifferenceComparison;
import com.ejianc.framework.skeleton.fieldCompare.FieldDifferenceComparison;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 项目预算主实体
 * 
 * @author generator
 * 
 */
@DifferenceComparison(differnceList = "differnceList", beforeKeyPrefix = "before")
public class BudgetProjectProVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    List<CompareDifferenceUtil.FieldDifference> differnceList;

    public List<CompareDifferenceUtil.FieldDifference> getDiffernceList() {
        return differnceList;
    }

    public void setDiffernceList(List<CompareDifferenceUtil.FieldDifference> differnceList) {
        this.differnceList = differnceList;
    }

    private BigDecimal beforeBudgetTaxMny; // 预算总金额（含税）
    private BigDecimal beforeIndirectionTaxMny; // 间接费(含税)
    private BigDecimal beforeLaborTaxMny; // 人工费（含税）
    private BigDecimal beforeMaterialTaxMny; // 材料费（含税）


    public BigDecimal getBeforeBudgetTaxMny() {
        return beforeBudgetTaxMny;
    }

    public void setBeforeBudgetTaxMny(BigDecimal beforeBudgetTaxMny) {
        this.beforeBudgetTaxMny = beforeBudgetTaxMny;
    }

    public BigDecimal getBeforeIndirectionTaxMny() {
        return beforeIndirectionTaxMny;
    }

    public void setBeforeIndirectionTaxMny(BigDecimal beforeIndirectionTaxMny) {
        this.beforeIndirectionTaxMny = beforeIndirectionTaxMny;
    }

    public BigDecimal getBeforeLaborTaxMny() {
        return beforeLaborTaxMny;
    }

    public void setBeforeLaborTaxMny(BigDecimal beforeLaborTaxMny) {
        this.beforeLaborTaxMny = beforeLaborTaxMny;
    }

    public BigDecimal getBeforeMaterialTaxMny() {
        return beforeMaterialTaxMny;
    }

    public void setBeforeMaterialTaxMny(BigDecimal beforeMaterialTaxMny) {
        this.beforeMaterialTaxMny = beforeMaterialTaxMny;
    }

    private String billCode; // 单据编号
    private Long orgId; // 组织主键
    private String orgName; // 组织名称
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人
    private Long departmentId; // 经办人部门id
    private String departmentName; // 经办人部门
    @FieldDifferenceComparison
    private BigDecimal budgetTaxMny; // 预算总金额（含税）
    private BigDecimal budgetMny; // 预算总金额(无税)
    @FieldDifferenceComparison
    private BigDecimal indirectionTaxMny; // 间接费(含税)
    private BigDecimal indirectionMny; // 间接费（无税）
    @FieldDifferenceComparison
    private BigDecimal laborTaxMny; // 人工费（含税）
    private BigDecimal laborMny; // 人工费（无税）
    @FieldDifferenceComparison
    private BigDecimal materialTaxMny; // 材料费（含税）
    private BigDecimal materialMny; // 材料费（无税）
    private BigDecimal majorTaxMny; // 专业费（含税）
    private BigDecimal majorMny; // 专业费（无税）
    private BigDecimal mechanicalTaxMny; // 机械费(含税 )
    private BigDecimal mechanicalMny; // 机械费（无税）
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    private Integer changeVersion; // 变更版本
    private String changeCode; // 变更单号
    private Long changeId; // 变更主键
    private Integer billState; // 单据状态
    private String changeReason; // 变更原因
    private String memo; // 备注
    private String costTypeShow; // 备注
    private java.math.BigDecimal sporadicMaterialMny; // 零星材料费
    private BigDecimal taxRate; // 综合税率

    private List<BudgetProjectDetailProVO> detailList = new ArrayList<>(); // 项目预算清单明细

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public BigDecimal getSporadicMaterialMny() {
        return sporadicMaterialMny;
    }

    public void setSporadicMaterialMny(BigDecimal sporadicMaterialMny) {
        this.sporadicMaterialMny = sporadicMaterialMny;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public BigDecimal getBudgetTaxMny() {
        return budgetTaxMny;
    }

    public void setBudgetTaxMny(BigDecimal budgetTaxMny) {
        this.budgetTaxMny = budgetTaxMny;
    }
    public BigDecimal getBudgetMny() {
        return budgetMny;
    }

    public void setBudgetMny(BigDecimal budgetMny) {
        this.budgetMny = budgetMny;
    }
    public BigDecimal getIndirectionTaxMny() {
        return indirectionTaxMny;
    }

    public void setIndirectionTaxMny(BigDecimal indirectionTaxMny) {
        this.indirectionTaxMny = indirectionTaxMny;
    }
    public BigDecimal getIndirectionMny() {
        return indirectionMny;
    }

    public void setIndirectionMny(BigDecimal indirectionMny) {
        this.indirectionMny = indirectionMny;
    }
    public BigDecimal getLaborTaxMny() {
        return laborTaxMny;
    }

    public void setLaborTaxMny(BigDecimal laborTaxMny) {
        this.laborTaxMny = laborTaxMny;
    }
    public BigDecimal getLaborMny() {
        return laborMny;
    }

    public void setLaborMny(BigDecimal laborMny) {
        this.laborMny = laborMny;
    }
    public BigDecimal getMaterialTaxMny() {
        return materialTaxMny;
    }

    public void setMaterialTaxMny(BigDecimal materialTaxMny) {
        this.materialTaxMny = materialTaxMny;
    }
    public BigDecimal getMaterialMny() {
        return materialMny;
    }

    public void setMaterialMny(BigDecimal materialMny) {
        this.materialMny = materialMny;
    }
    public BigDecimal getMajorTaxMny() {
        return majorTaxMny;
    }

    public void setMajorTaxMny(BigDecimal majorTaxMny) {
        this.majorTaxMny = majorTaxMny;
    }
    public BigDecimal getMajorMny() {
        return majorMny;
    }

    public void setMajorMny(BigDecimal majorMny) {
        this.majorMny = majorMny;
    }
    public BigDecimal getMechanicalTaxMny() {
        return mechanicalTaxMny;
    }

    public void setMechanicalTaxMny(BigDecimal mechanicalTaxMny) {
        this.mechanicalTaxMny = mechanicalTaxMny;
    }
    public BigDecimal getMechanicalMny() {
        return mechanicalMny;
    }

    public void setMechanicalMny(BigDecimal mechanicalMny) {
        this.mechanicalMny = mechanicalMny;
    }
    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getCostTypeShow() {
        return costTypeShow;
    }

    public void setCostTypeShow(String costTypeShow) {
        this.costTypeShow = costTypeShow;
    }

    public List<BudgetProjectDetailProVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<BudgetProjectDetailProVO> detailList) {
        this.detailList = detailList;
    }
}
