package com.ejianc.business.budget.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;


/**
 * 清单定额关系设置子表
 * 
 * @author generator
 * 
 */
public class BudgetInfoSetDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long pid; // 主表主键
    private Long quotaId; // 定额主键
    private String quotaCode; // 项目编号
    private String quotaName; // 项目名称
    private String quotaDescription; // 项目特征描述
    private String quotaUnit; // 单位
    private BigDecimal quotaNum; // 工程量
    private String memo; // 备注
    

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    @ReferSerialTransfer(referCode="ref_quota_detail")
    public Long getQuotaId() {
        return quotaId;
    }

    @ReferDeserialTransfer
    public void setQuotaId(Long quotaId) {
        this.quotaId = quotaId;
    }

    public String getQuotaCode() {
        return quotaCode;
    }

    public void setQuotaCode(String quotaCode) {
        this.quotaCode = quotaCode;
    }
    public String getQuotaName() {
        return quotaName;
    }

    public void setQuotaName(String quotaName) {
        this.quotaName = quotaName;
    }
    public String getQuotaDescription() {
        return quotaDescription;
    }

    public void setQuotaDescription(String quotaDescription) {
        this.quotaDescription = quotaDescription;
    }
    public String getQuotaUnit() {
        return quotaUnit;
    }

    public void setQuotaUnit(String quotaUnit) {
        this.quotaUnit = quotaUnit;
    }
    public BigDecimal getQuotaNum() {
        return quotaNum;
    }

    public void setQuotaNum(BigDecimal quotaNum) {
        this.quotaNum = quotaNum;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
