package com.ejianc.business.budget.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.cost.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.fieldCompare.CompareDifferenceUtil;
import com.ejianc.framework.skeleton.fieldCompare.DifferenceComparison;
import com.ejianc.framework.skeleton.fieldCompare.FieldDifferenceComparison;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


/**
 * 项目预算清单明细
 *
 * @author generator
 */
@DifferenceComparison(changeFlag = "changeFlag", differnceList = "differnceList")
public class BudgetProjectDetailProVO extends BaseVO implements ITreeNodeB {
    private static final long serialVersionUID = 1L;

    private String beforeCode; // 清单编号
    private String beforeName; // 清单名称

    private Integer beforeCostType; // 费用类型
    private String beforeSpec; // 特征/规格型号
    private String beforeUnit; // 计量单位
    private BigDecimal beforeNum; // 工程量
    private BigDecimal beforeTaxPrice; // 综合单价（含税）
    private BigDecimal beforeLaborTaxMnyCost; // 人工费（含税）
    private BigDecimal beforeMaterialTaxMnyCost; // 材料费（含税）
    private BigDecimal beforeIndirectionTaxMnyCost; // 间接费用(含税)
    private BigDecimal beforeTaxMny; // 合价(含税)


    private String changeFlag;

    List<CompareDifferenceUtil.FieldDifference> differnceList;

    public String getChangeFlag() {
        return changeFlag;
    }

    public void setChangeFlag(String changeFlag) {
        this.changeFlag = changeFlag;
    }

    public List<CompareDifferenceUtil.FieldDifference> getDiffernceList() {
        return differnceList;
    }

    public void setDiffernceList(List<CompareDifferenceUtil.FieldDifference> differnceList) {
        this.differnceList = differnceList;
    }

    public String getBeforeCode() {
        return beforeCode;
    }

    public void setBeforeCode(String beforeCode) {
        this.beforeCode = beforeCode;
    }

    public String getBeforeName() {
        return beforeName;
    }

    public void setBeforeName(String beforeName) {
        this.beforeName = beforeName;
    }

    public Integer getBeforeCostType() {
        return beforeCostType;
    }

    public void setBeforeCostType(Integer beforeCostType) {
        this.beforeCostType = beforeCostType;
    }

    public String getBeforeSpec() {
        return beforeSpec;
    }

    public void setBeforeSpec(String beforeSpec) {
        this.beforeSpec = beforeSpec;
    }

    public String getBeforeUnit() {
        return beforeUnit;
    }

    public void setBeforeUnit(String beforeUnit) {
        this.beforeUnit = beforeUnit;
    }

    public BigDecimal getBeforeNum() {
        return beforeNum;
    }

    public void setBeforeNum(BigDecimal beforeNum) {
        this.beforeNum = beforeNum;
    }

    public BigDecimal getBeforeTaxPrice() {
        return beforeTaxPrice;
    }

    public void setBeforeTaxPrice(BigDecimal beforeTaxPrice) {
        this.beforeTaxPrice = beforeTaxPrice;
    }

    public BigDecimal getBeforeLaborTaxMnyCost() {
        return beforeLaborTaxMnyCost;
    }

    public void setBeforeLaborTaxMnyCost(BigDecimal beforeLaborTaxMnyCost) {
        this.beforeLaborTaxMnyCost = beforeLaborTaxMnyCost;
    }

    public BigDecimal getBeforeMaterialTaxMnyCost() {
        return beforeMaterialTaxMnyCost;
    }

    public void setBeforeMaterialTaxMnyCost(BigDecimal beforeMaterialTaxMnyCost) {
        this.beforeMaterialTaxMnyCost = beforeMaterialTaxMnyCost;
    }

    public BigDecimal getBeforeIndirectionTaxMnyCost() {
        return beforeIndirectionTaxMnyCost;
    }

    public void setBeforeIndirectionTaxMnyCost(BigDecimal beforeIndirectionTaxMnyCost) {
        this.beforeIndirectionTaxMnyCost = beforeIndirectionTaxMnyCost;
    }

    public BigDecimal getBeforeTaxMny() {
        return beforeTaxMny;
    }

    public void setBeforeTaxMny(BigDecimal beforeTaxMny) {
        this.beforeTaxMny = beforeTaxMny;
    }

    private Long budgetId; // 预算主键
    private String detailIndex; // 序号
    @FieldDifferenceComparison
    private String code; // 清单编号
    private Long parentId; // parent_id
    @FieldDifferenceComparison
    private String name; // 清单名称
    private Long categoryId; // 分类id
    private String categoryName; // 分类名称
    private Long materialId; // 物资id
    private String materialName; // 物资名称
    @FieldDifferenceComparison
    private Integer costType; // 费用类型
    private String costTypeName; // 费用类型名称
    @FieldDifferenceComparison
    private String spec; // 特征/规格型号
    @FieldDifferenceComparison
    private String unit; // 计量单位
    @FieldDifferenceComparison
    private BigDecimal num; // 工程量
    @FieldDifferenceComparison(name = "单价")
    private BigDecimal taxPrice; // 综合单价（含税）
    private BigDecimal price; // 综合单价（无税）
    private BigDecimal rate; // 税率
    @FieldDifferenceComparison
    private BigDecimal laborTaxMnyCost; // 人工费（含税）
    private BigDecimal laborMnyCost; // 人工费(无税)
    private BigDecimal majorTaxMnyCost; // 专业费（含税）
    private BigDecimal majorMnyCost; // 专业费（无税）
    @FieldDifferenceComparison
    private BigDecimal materialTaxMnyCost; // 材料费（含税）
    private BigDecimal materialMnyCost; // 材料费（无税）
    private BigDecimal mechanicalTaxMnyCost; // 机械费(含税)
    private BigDecimal mechanicalMnyCost; // 机械费（无税）
    @FieldDifferenceComparison
    private BigDecimal indirectionTaxMnyCost; // 间接费用(含税)
    private BigDecimal indirectionMnyCost; // 间接费用（无税）
    @FieldDifferenceComparison
    private BigDecimal taxMny; // 合价(含税)
    private BigDecimal mny; // 合价(无税)
    private Boolean leafFlag; // 是否末级
    private BigDecimal lockNum; // 占用数量
    private BigDecimal lockMny; // 占用金额(无税)
    private BigDecimal lockTaxMny; // 占用金额(含税)
    private Long changeId; // 变更主键
    private Long changeBid; // 变更子表主键
    private Long subjectId; // 成本科目id
    private String subjectName; // 成本科目
    private String subjectCode; // 成本科目编码
    private Integer subjectNum; // 成本数量
    private String tid;
    private String tpid;
    //错误类型
    private String warnType;
    private List<ITreeNodeB> children;

    // 列是否可以导入，true=可以导入，false=不可导入
    private Boolean importFlag;
    // 是否是父级错误
    private Boolean parentWarn;
    private String shadowId;
    private String key;
    private String entryType;//0 手动 1 档案
    //是否档案
    private String archiveFlag;//1 否 2 是
    /**
     * 模糊匹配生成档案使用
     */
    private Integer matchStatus; // 匹配状态：0-未匹配，1-已匹配，2-模糊匹配，
    private String matchStatusDescription;

    private Long commonId; // 通用的id（包含清单id和档案id），仅清单量价累计用

    private BigDecimal sumNum; // 累计目标成本完成量

    private BigDecimal sumTaxMny; // 目标成本完成金额


    private Integer budgetType; // 预算类型：0-中标预算1-施工图预算2-结算预算3-变更4-签证5-索赔6-其他
    private Long sourceId; // 来源ID

    private BigDecimal lossRate; // 材料耗率
    private Long brandId; // 品牌
    private String brandName; // 品牌名称
    private BigDecimal guidePrice; // 指导价
    private BigDecimal competeFactor; // 竞聘系数

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public BigDecimal getGuidePrice() {
        return guidePrice;
    }

    public void setGuidePrice(BigDecimal guidePrice) {
        this.guidePrice = guidePrice;
    }

    public BigDecimal getCompeteFactor() {
        return competeFactor;
    }

    public void setCompeteFactor(BigDecimal competeFactor) {
        this.competeFactor = competeFactor;
    }

    public BigDecimal getLossRate() {
        return lossRate;
    }

    public void setLossRate(BigDecimal lossRate) {
        this.lossRate = lossRate;
    }

    public Integer getBudgetType() {
        return budgetType;
    }

    public void setBudgetType(Integer budgetType) {
        this.budgetType = budgetType;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public BigDecimal getSumNum() {
        return sumNum;
    }

    public void setSumNum(BigDecimal sumNum) {
        this.sumNum = sumNum;
    }

    public BigDecimal getSumTaxMny() {
        return sumTaxMny;
    }

    public void setSumTaxMny(BigDecimal sumTaxMny) {
        this.sumTaxMny = sumTaxMny;
    }

    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    public String getWarnType() {
        return warnType;
    }

    public void setWarnType(String warnType) {
        this.warnType = warnType;
    }

    public void setChildren(List<ITreeNodeB> children) {
        this.children = children;
    }


    public Long getBudgetId() {
        return budgetId;
    }

    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }

    public String getDetailIndex() {
        return detailIndex;
    }

    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }


    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }


    public Integer getCostType() {
        return costType;
    }

    public void setCostType(Integer costType) {
        this.costType = costType;
    }

    public String getCostTypeName() {
        return costTypeName;
    }

    public void setCostTypeName(String costTypeName) {
        this.costTypeName = costTypeName;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }

    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getRate() {
        return rate;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    public BigDecimal getLaborTaxMnyCost() {
        return laborTaxMnyCost;
    }

    public void setLaborTaxMnyCost(BigDecimal laborTaxMnyCost) {
        this.laborTaxMnyCost = laborTaxMnyCost;
    }

    public BigDecimal getLaborMnyCost() {
        return laborMnyCost;
    }

    public void setLaborMnyCost(BigDecimal laborMnyCost) {
        this.laborMnyCost = laborMnyCost;
    }

    public BigDecimal getMajorTaxMnyCost() {
        return majorTaxMnyCost;
    }

    public void setMajorTaxMnyCost(BigDecimal majorTaxMnyCost) {
        this.majorTaxMnyCost = majorTaxMnyCost;
    }

    public BigDecimal getMajorMnyCost() {
        return majorMnyCost;
    }

    public void setMajorMnyCost(BigDecimal majorMnyCost) {
        this.majorMnyCost = majorMnyCost;
    }

    public BigDecimal getMaterialTaxMnyCost() {
        return materialTaxMnyCost;
    }

    public void setMaterialTaxMnyCost(BigDecimal materialTaxMnyCost) {
        this.materialTaxMnyCost = materialTaxMnyCost;
    }

    public BigDecimal getMaterialMnyCost() {
        return materialMnyCost;
    }

    public void setMaterialMnyCost(BigDecimal materialMnyCost) {
        this.materialMnyCost = materialMnyCost;
    }

    public BigDecimal getMechanicalTaxMnyCost() {
        return mechanicalTaxMnyCost;
    }

    public void setMechanicalTaxMnyCost(BigDecimal mechanicalTaxMnyCost) {
        this.mechanicalTaxMnyCost = mechanicalTaxMnyCost;
    }

    public BigDecimal getMechanicalMnyCost() {
        return mechanicalMnyCost;
    }

    public void setMechanicalMnyCost(BigDecimal mechanicalMnyCost) {
        this.mechanicalMnyCost = mechanicalMnyCost;
    }

    public BigDecimal getIndirectionTaxMnyCost() {
        return indirectionTaxMnyCost;
    }

    public void setIndirectionTaxMnyCost(BigDecimal indirectionTaxMnyCost) {
        this.indirectionTaxMnyCost = indirectionTaxMnyCost;
    }

    public BigDecimal getIndirectionMnyCost() {
        return indirectionMnyCost;
    }

    public void setIndirectionMnyCost(BigDecimal indirectionMnyCost) {
        this.indirectionMnyCost = indirectionMnyCost;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }

    public Boolean getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }

    public BigDecimal getLockNum() {
        return lockNum;
    }

    public void setLockNum(BigDecimal lockNum) {
        this.lockNum = lockNum;
    }

    public BigDecimal getLockMny() {
        return lockMny;
    }

    public void setLockMny(BigDecimal lockMny) {
        this.lockMny = lockMny;
    }

    public BigDecimal getLockTaxMny() {
        return lockTaxMny;
    }

    public void setLockTaxMny(BigDecimal lockTaxMny) {
        this.lockTaxMny = lockTaxMny;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Long getChangeBid() {
        return changeBid;
    }

    public void setChangeBid(Long changeBid) {
        this.changeBid = changeBid;
    }

    public Boolean getImportFlag() {
        return importFlag;
    }

    public void setImportFlag(Boolean importFlag) {
        this.importFlag = importFlag;
    }

    public Boolean getParentWarn() {
        return parentWarn;
    }

    public void setParentWarn(Boolean parentWarn) {
        this.parentWarn = parentWarn;
    }

    public String getShadowId() {
        return shadowId;
    }

    public void setShadowId(String shadowId) {
        this.shadowId = shadowId;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Integer getMatchStatus() {
        return matchStatus;
    }

    public void setMatchStatus(Integer matchStatus) {
        this.matchStatus = matchStatus;
    }

    public String getEntryType() {
        return entryType;
    }

    public void setEntryType(String entryType) {
        this.entryType = entryType;
    }

    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public Long getCommonId() {
        return commonId;
    }

    public void setCommonId(Long commonId) {
        this.commonId = commonId;
    }

    public String getArchiveFlag() {
        return archiveFlag;
    }

    public void setArchiveFlag(String archiveFlag) {
        this.archiveFlag = archiveFlag;
    }

    public Integer getSubjectNum() {
        return subjectNum;
    }

    public void setSubjectNum(Integer subjectNum) {
        this.subjectNum = subjectNum;
    }

    public String getMatchStatusDescription() {
        return matchStatusDescription;
    }

    public void setMatchStatusDescription(String matchStatusDescription) {
        this.matchStatusDescription = matchStatusDescription;
    }
}
