package com.ejianc.business.cost.vo;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 指导价
 * 
 * @author generator
 * 
 */
public class GuidePriceVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    private String title; // 主题
    private Long orgId; // 发布单位
    private String orgName; // 发布单位名称
    private String orgCode; // 编码
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date releaseDate; // 发布日期
    private Long releaseUserId; // 发布人
    private String releaseUserName; // 发布人名称
    private Integer status; // 状态：0、关闭； 1、启动
    private String memo; // 描述

    private List<GuidePriceDetailVO> detailList = new ArrayList<>(); // 指导价-价格明细

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Date getReleaseDate() {
        return releaseDate;
    }

    public void setReleaseDate(Date releaseDate) {
        this.releaseDate = releaseDate;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getReleaseUserId() {
        return releaseUserId;
    }
    @ReferDeserialTransfer
    public void setReleaseUserId(Long releaseUserId) {
        this.releaseUserId = releaseUserId;
    }
    public String getReleaseUserName() {
        return releaseUserName;
    }

    public void setReleaseUserName(String releaseUserName) {
        this.releaseUserName = releaseUserName;
    }
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
     public List<GuidePriceDetailVO> getDetailList() {
        return detailList;
     }

     public void setDetailList(List<GuidePriceDetailVO> detailList) {
        this.detailList = detailList;
     }
}
