package com.ejianc.business.cost.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.cost.vo.SchemeOtherVO;
import com.ejianc.business.cost.vo.SchemeIndirectVO;

/**
 * 标前策划成本
 * 
 * @author generator
 * 
 */
public class SchemeVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long projectId; // 项目id
    private String projectCode; // 项目code
    private String projectName; // 项目名称
    private BigDecimal laborMny; // 工程人工费
    private BigDecimal materialsMny; // 工程材料费
    private BigDecimal directTotalMny; // 工程直接费合计
    private BigDecimal indirectlyTotalMny; // 工程间接费合计
    private BigDecimal otherTotalMny; // 其他费合计
    private BigDecimal amountMny; // 成本总金额
    private BigDecimal biddingMny; // 预估中标金额
    private BigDecimal netReturnMny; // 净利润金额
    private BigDecimal netReturnScale; // 净利润率
    private String memo; // 备注
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门
    private String departmentName; // 经办部门名称
    private Long parentOrgId; // 项目部上级组织Id（区域名称）
    private String parentOrgName; // 项目部上级组织名称
    private String parentOrgCode; // 项目部上级组织编码
    private Integer billState; // 单据状态
    private String billStateName; // 单据状态翻译字段


    private List<SchemeOtherVO> schemeOtherList = new ArrayList<>(); // 标签策划成本-其他费用
    private List<SchemeIndirectVO> schemeIndirectList = new ArrayList<>(); // 标签策划成本-间接费用
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public BigDecimal getLaborMny() {
        return laborMny;
    }

    public void setLaborMny(BigDecimal laborMny) {
        this.laborMny = laborMny;
    }
    public BigDecimal getMaterialsMny() {
        return materialsMny;
    }

    public void setMaterialsMny(BigDecimal materialsMny) {
        this.materialsMny = materialsMny;
    }
    public BigDecimal getDirectTotalMny() {
        return directTotalMny;
    }

    public void setDirectTotalMny(BigDecimal directTotalMny) {
        this.directTotalMny = directTotalMny;
    }
    public BigDecimal getIndirectlyTotalMny() {
        return indirectlyTotalMny;
    }

    public void setIndirectlyTotalMny(BigDecimal indirectlyTotalMny) {
        this.indirectlyTotalMny = indirectlyTotalMny;
    }
    public BigDecimal getOtherTotalMny() {
        return otherTotalMny;
    }

    public void setOtherTotalMny(BigDecimal otherTotalMny) {
        this.otherTotalMny = otherTotalMny;
    }
    public BigDecimal getAmountMny() {
        return amountMny;
    }

    public void setAmountMny(BigDecimal amountMny) {
        this.amountMny = amountMny;
    }
    public BigDecimal getBiddingMny() {
        return biddingMny;
    }

    public void setBiddingMny(BigDecimal biddingMny) {
        this.biddingMny = biddingMny;
    }
    public BigDecimal getNetReturnMny() {
        return netReturnMny;
    }

    public void setNetReturnMny(BigDecimal netReturnMny) {
        this.netReturnMny = netReturnMny;
    }
    public BigDecimal getNetReturnScale() {
        return netReturnScale;
    }

    public void setNetReturnScale(BigDecimal netReturnScale) {
        this.netReturnScale = netReturnScale;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public List<SchemeIndirectVO> getSchemeIndirectList() {
        return schemeIndirectList;
    }

    public void setSchemeIndirectList(List<SchemeIndirectVO> schemeIndirectList) {
        this.schemeIndirectList = schemeIndirectList;
    }

    public List<SchemeOtherVO> getSchemeOtherVOList() {
        return schemeOtherList;
    }

    public void setSchemeOtherVOList(List<SchemeOtherVO> schemeOtherVOList) {
        this.schemeOtherList = schemeOtherVOList;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
}
