package com.ejianc.business.cost.vo;

import com.ejianc.business.sub.vo.CertificateVO;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 对外签证
 *
 * @author generator
 *
 */
public class ClaimVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编号
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private Long projManagerId; // 项目负责人ID
    private String projManagerName; // 项目负责人名称
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date occurDate; // 发生日期
    private Integer changeType; // 变更类型，1-施工范围内增补变更，2-施工范围线外增补，3-非增补变更
    private String commitFileDesc; // 提交资料说明
    private Integer visaState; // 是否办理对外签证
    private String noVisaReason; // 不办理签证理由
    private Integer offerState; // 是否需要报价
    private String firstExpect; // 甲方预期
    private Integer imageState; // 对外签证是否需要附图
    private String imageType; // 对外签证图纸类型
    private Integer importanceState; // 是否为大变更
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门
    private String departmentName; // 经办部门名称
    private String memo; // 备注
    private Integer billState; // 单据状态
    private BigDecimal preApproveMny; // 预计审定金额
    private BigDecimal offerMny; // 报价金额
    private BigDecimal costMny; // 成本金额
    private BigDecimal firstAgreeMny; // 甲方批复金额
    private Integer lockState; // 锁定状态1-锁项2-锁价

    private String linkFile;
    private String imageFile;
    private String signFile;
    private String priceFile;
    private String qualityFile;

    private List<ClaimDetailVO> detailList = new ArrayList<>(); // 对外签证明细
    private List<ApprovmentVO> approvmentList = new ArrayList<>(); // 甲方批复明细
    private List<CertificateVO> certificateList = new ArrayList<>();// 对内签证明细

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjManagerId() {
        return projManagerId;
    }

    public void setProjManagerId(Long projManagerId) {
        this.projManagerId = projManagerId;
    }
    public String getProjManagerName() {
        return projManagerName;
    }

    public void setProjManagerName(String projManagerName) {
        this.projManagerName = projManagerName;
    }
    public Date getOccurDate() {
        return occurDate;
    }

    public void setOccurDate(Date occurDate) {
        this.occurDate = occurDate;
    }
    public Integer getChangeType() {
        return changeType;
    }

    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }
    public String getCommitFileDesc() {
        return commitFileDesc;
    }

    public void setCommitFileDesc(String commitFileDesc) {
        this.commitFileDesc = commitFileDesc;
    }
    public Integer getVisaState() {
        return visaState;
    }

    public void setVisaState(Integer visaState) {
        this.visaState = visaState;
    }
    public String getNoVisaReason() {
        return noVisaReason;
    }

    public void setNoVisaReason(String noVisaReason) {
        this.noVisaReason = noVisaReason;
    }
    public Integer getOfferState() {
        return offerState;
    }

    public void setOfferState(Integer offerState) {
        this.offerState = offerState;
    }
    public String getFirstExpect() {
        return firstExpect;
    }

    public void setFirstExpect(String firstExpect) {
        this.firstExpect = firstExpect;
    }
    public Integer getImageState() {
        return imageState;
    }

    public void setImageState(Integer imageState) {
        this.imageState = imageState;
    }
    public String getImageType() {
        return imageType;
    }

    public void setImageType(String imageType) {
        this.imageType = imageType;
    }
    public Integer getImportanceState() {
        return importanceState;
    }

    public void setImportanceState(Integer importanceState) {
        this.importanceState = importanceState;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }

    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public BigDecimal getPreApproveMny() {
        return preApproveMny;
    }

    public void setPreApproveMny(BigDecimal preApproveMny) {
        this.preApproveMny = preApproveMny;
    }
    public BigDecimal getOfferMny() {
        return offerMny;
    }

    public void setOfferMny(BigDecimal offerMny) {
        this.offerMny = offerMny;
    }
    public BigDecimal getCostMny() {
        return costMny;
    }

    public void setCostMny(BigDecimal costMny) {
        this.costMny = costMny;
    }
    public BigDecimal getFirstAgreeMny() {
        return firstAgreeMny;
    }

    public void setFirstAgreeMny(BigDecimal firstAgreeMny) {
        this.firstAgreeMny = firstAgreeMny;
    }
    public Integer getLockState() {
        return lockState;
    }

    public void setLockState(Integer lockState) {
        this.lockState = lockState;
    }

    public List<ClaimDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ClaimDetailVO> detailList) {
        this.detailList = detailList;
    }

    public List<ApprovmentVO> getApprovmentList() {
        return approvmentList;
    }

    public void setApprovmentList(List<ApprovmentVO> approvmentList) {
        this.approvmentList = approvmentList;
    }

    public String getLinkFile() {
        return linkFile;
    }

    public void setLinkFile(String linkFile) {
        this.linkFile = linkFile;
    }

    public String getImageFile() {
        return imageFile;
    }

    public void setImageFile(String imageFile) {
        this.imageFile = imageFile;
    }

    public String getSignFile() {
        return signFile;
    }

    public void setSignFile(String signFile) {
        this.signFile = signFile;
    }

    public String getPriceFile() {
        return priceFile;
    }

    public void setPriceFile(String priceFile) {
        this.priceFile = priceFile;
    }

    public String getQualityFile() {
        return qualityFile;
    }

    public void setQualityFile(String qualityFile) {
        this.qualityFile = qualityFile;
    }

    public List<CertificateVO> getCertificateList() {
        return certificateList;
    }

    public void setCertificateList(List<CertificateVO> certificateList) {
        this.certificateList = certificateList;
    }
}
