/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.utils;

import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.FileUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.web.multipart.MultipartFile;

public class HuaKangExcelReader {
    private static int TITLE_LAST_ROW_NUM = 6;

    public static List<List<String>> readExcel(MultipartFile file, Integer projNameLine, Integer beginLine) {
        String originalFileName = file.getOriginalFilename();
        String extName = null;
        originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
        originalFileName.replaceAll("00.", "");
        extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
        if ("xls".equals(extName)) {
            return HuaKangExcelReader.read2003Excel(file, projNameLine, beginLine);
        }
        if ("xlsx".equals(extName)) {
            return HuaKangExcelReader.read2007Excel(file, projNameLine, beginLine);
        }
        throw new BusinessException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b");
    }

    private static List<List<String>> read2003Excel(MultipartFile file, Integer projNameLine, Integer beginLine) {
        HSSFWorkbook hwb;
        LinkedList<List<String>> list = new LinkedList<List<String>>();
        try {
            hwb = new HSSFWorkbook((InputStream)new BufferedInputStream(file.getInputStream()));
        }
        catch (IOException e) {
            throw new BusinessException(e.getMessage());
        }
        List<Integer> idexList = HuaKangExcelReader.get2003IdexList(hwb, projNameLine, beginLine);
        int size = hwb.getNumberOfSheets();
        block9: for (int index = 0; index < size; ++index) {
            HSSFSheet sheet = hwb.getSheetAt(index);
            String value = null;
            HSSFRow row = null;
            HSSFCell cell = null;
            boolean isEmpty = true;
            int firstRowNum = sheet.getFirstRowNum();
            int physicalNumberOfRows = sheet.getPhysicalNumberOfRows();
            for (int i = firstRowNum + 1; i < physicalNumberOfRows; ++i) {
                isEmpty = true;
                row = sheet.getRow(i);
                if (row == null || i != projNameLine - 1 && i < beginLine - 1 || i >= beginLine - 1 && (null == row.getCell(idexList.get(2).intValue()) || StringUtils.isEmpty((CharSequence)row.getCell(idexList.get(2).intValue()).getStringCellValue()))) continue;
                LinkedList<String> linked = new LinkedList<String>();
                linked.add(sheet.getSheetName());
                for (Integer n : idexList) {
                    cell = row.getCell(n.intValue());
                    if (cell == null) {
                        linked.add("");
                        continue;
                    }
                    switch (cell.getCellType()) {
                        case 0: {
                            cell.setCellType(1);
                            value = cell.getStringCellValue();
                            break;
                        }
                        case 1: {
                            value = cell.getStringCellValue().toString();
                            break;
                        }
                        case 2: {
                            HSSFFormulaEvaluator evaluator = new HSSFFormulaEvaluator(hwb);
                            CellValue cellValue = evaluator.evaluate((Cell)cell);
                            int actualType = cellValue.getCellType();
                            if (actualType == 4) {
                                value = cellValue.getBooleanValue() + "";
                                break;
                            }
                            if (actualType == 0) {
                                cell.setCellType(1);
                                value = cell.getStringCellValue();
                                break;
                            }
                            if (actualType != 1) break;
                            value = cellValue.getStringValue();
                            break;
                        }
                        case 4: {
                            value = " " + cell.getBooleanCellValue();
                            break;
                        }
                        case 3: {
                            value = "";
                            break;
                        }
                        default: {
                            value = "Error";
                        }
                    }
                    linked.add(value);
                }
                if (list.size() > 0) {
                    int headLength = ((List)list.get(0)).size();
                    int n = linked.size();
                    if (n < headLength) {
                        for (int k = n; k < headLength; ++k) {
                            linked.add(null);
                        }
                    }
                }
                if (isEmpty) {
                    for (Integer n : linked) {
                        if (n == null || !StringUtils.isNotBlank((CharSequence)String.valueOf(n))) continue;
                        isEmpty = false;
                        break;
                    }
                }
                if (!isEmpty) {
                    list.add(linked);
                    continue;
                }
                if (i > sheet.getPhysicalNumberOfRows() - 3) continue block9;
            }
        }
        return list;
    }

    private static List<Integer> get2003IdexList(HSSFWorkbook hwb, Integer projNameLine, Integer beginLine) {
        LinkedList<Integer> indexList = new LinkedList<Integer>();
        int detailIndexCellNum = 0;
        int codeCellNum = 1;
        int nameCellNum = 2;
        int descCellNum = 3;
        int unitCellNum = 4;
        int numCellNum = 5;
        int taxPriceCellNum = 6;
        int taxMnyCellNum = 7;
        int indexKnownNum = 0;
        List<List<String>> result = HuaKangExcelReader.get2003HeadData(hwb, hwb.getSheetAt(0), projNameLine, beginLine);
        Iterator<List<String>> iterator = result.iterator();
        while (iterator.hasNext()) {
            List<String> datas = iterator.next();
            int _indexKnownNum = indexKnownNum;
            for (int j = 0; j < datas.size(); ++j) {
                String s = datas.get(j);
                if (s.replaceAll("\\s*|\\r|\\n|\\t", "").contains("\u5e8f\u53f7")) {
                    detailIndexCellNum = j;
                    ++indexKnownNum;
                    continue;
                }
                if (s.replaceAll("\\s*|\\r|\\n|\\t", "").contains("\u9879\u76ee\u7f16\u7801")) {
                    codeCellNum = j;
                    ++indexKnownNum;
                    continue;
                }
                if (s.replaceAll("\\s*|\\r|\\n|\\t", "").contains("\u9879\u76ee\u540d\u79f0")) {
                    nameCellNum = j;
                    ++indexKnownNum;
                    continue;
                }
                if (s.replaceAll("\\s*|\\r|\\n|\\t", "").contains("\u9879\u76ee\u7279\u5f81")) {
                    descCellNum = j;
                    ++indexKnownNum;
                    continue;
                }
                if (s.replaceAll("\\s*|\\r|\\n|\\t", "").contains("\u8ba1\u91cf\u5355\u4f4d")) {
                    unitCellNum = j;
                    ++indexKnownNum;
                    continue;
                }
                if (s.replaceAll("\\s*|\\r|\\n|\\t", "").contains("\u5de5\u7a0b\u91cf") || s.replaceAll("\\s*|\\r|\\n|\\t", "").contains("\u5de5\u7a0b\u6570\u91cf")) {
                    numCellNum = j;
                    ++indexKnownNum;
                    continue;
                }
                if (s.replaceAll("\\s*|\\r|\\n|\\t", "").contains("\u7efc\u5408\u5355\u4ef7")) {
                    taxPriceCellNum = j;
                    ++indexKnownNum;
                    continue;
                }
                if (!s.replaceAll("\\s*|\\r|\\n|\\t", "").contains("\u5408\u4ef7")) continue;
                taxMnyCellNum = j;
                ++indexKnownNum;
            }
            if (indexKnownNum > _indexKnownNum) {
                iterator.remove();
            }
            if (indexKnownNum != 8) continue;
            break;
        }
        if (indexKnownNum < 8 && result.size() == 0) {
            throw new BusinessException("\u672a\u8bc6\u522b\u8868\u5934\u5b57\u6bb5\u4fe1\u606f");
        }
        indexList.add(detailIndexCellNum);
        indexList.add(codeCellNum);
        indexList.add(nameCellNum);
        indexList.add(descCellNum);
        indexList.add(unitCellNum);
        indexList.add(numCellNum);
        indexList.add(taxPriceCellNum);
        indexList.add(taxMnyCellNum);
        return indexList;
    }

    private static List<List<String>> get2003HeadData(HSSFWorkbook hwb, HSSFSheet sheet, Integer projNameLine, Integer beginLine) {
        LinkedList<List<String>> list = new LinkedList<List<String>>();
        String value = null;
        HSSFRow row = null;
        HSSFCell cell = null;
        boolean isEmpty = true;
        int rowFirstCellNum = 0;
        int rowLastCellNum = 0;
        for (int i = sheet.getFirstRowNum() + 1; i < sheet.getPhysicalNumberOfRows(); ++i) {
            isEmpty = true;
            row = sheet.getRow(i);
            if (row == null || i < projNameLine || i >= beginLine - 1) continue;
            rowLastCellNum = row.getLastCellNum();
            LinkedList<String> linked = new LinkedList<String>();
            for (int j = rowFirstCellNum; j < rowLastCellNum; ++j) {
                cell = row.getCell(j);
                if (cell == null) {
                    linked.add("");
                    continue;
                }
                switch (cell.getCellType()) {
                    case 0: {
                        cell.setCellType(1);
                        value = cell.getStringCellValue();
                        break;
                    }
                    case 1: {
                        value = cell.getStringCellValue().toString();
                        break;
                    }
                    case 2: {
                        HSSFFormulaEvaluator hSSFFormulaEvaluator = new HSSFFormulaEvaluator(hwb);
                        CellValue cellValue = hSSFFormulaEvaluator.evaluate((Cell)cell);
                        int actualType = cellValue.getCellType();
                        if (actualType == 4) {
                            value = cellValue.getBooleanValue() + "";
                            break;
                        }
                        if (actualType == 0) {
                            cell.setCellType(1);
                            value = cell.getStringCellValue();
                            break;
                        }
                        if (actualType != 1) break;
                        value = cellValue.getStringValue();
                        break;
                    }
                    case 4: {
                        value = " " + cell.getBooleanCellValue();
                        break;
                    }
                    case 3: {
                        value = "";
                        break;
                    }
                    default: {
                        value = "Error";
                    }
                }
                linked.add(value);
            }
            if (list.size() > 0) {
                int headLength = ((List)list.get(0)).size();
                int n = linked.size();
                if (n < headLength) {
                    for (int k = n; k < headLength; ++k) {
                        linked.add(null);
                    }
                }
            }
            if (isEmpty) {
                for (Object e : linked) {
                    if (e == null || !StringUtils.isNotBlank((CharSequence)String.valueOf(e))) continue;
                    isEmpty = false;
                    break;
                }
            }
            if (!isEmpty) {
                list.add(linked);
                continue;
            }
            if (i >= beginLine) break;
        }
        return list;
    }

    private static List<List<String>> read2007Excel(MultipartFile file, Integer projNameLine, Integer beginLine) {
        XSSFWorkbook xwb;
        LinkedList<List<String>> list = new LinkedList<List<String>>();
        try {
            xwb = new XSSFWorkbook((InputStream)new BufferedInputStream(file.getInputStream()));
        }
        catch (IOException e) {
            throw new BusinessException(e.getMessage());
        }
        List<Integer> idexList = HuaKangExcelReader.get2007IdexList(xwb, projNameLine, beginLine);
        int size = xwb.getNumberOfSheets();
        block9: for (int index = 0; index < size; ++index) {
            XSSFSheet sheet = xwb.getSheetAt(index);
            String value = null;
            XSSFRow row = null;
            XSSFCell cell = null;
            boolean isEmpty = true;
            int firstRowNum = sheet.getFirstRowNum();
            int physicalNumberOfRows = sheet.getPhysicalNumberOfRows();
            for (int i = firstRowNum + 1; i < physicalNumberOfRows; ++i) {
                isEmpty = true;
                row = sheet.getRow(i);
                if (row == null || i != projNameLine - 1 && i < beginLine - 1 || i >= beginLine - 1 && (null == row.getCell(idexList.get(2).intValue()) || StringUtils.isEmpty((CharSequence)row.getCell(idexList.get(2).intValue()).getStringCellValue()))) continue;
                LinkedList<String> linked = new LinkedList<String>();
                linked.add(sheet.getSheetName());
                for (Integer n : idexList) {
                    cell = row.getCell(n.intValue());
                    if (cell == null) {
                        linked.add("");
                        continue;
                    }
                    switch (cell.getCellType()) {
                        case 0: {
                            cell.setCellType(1);
                            value = cell.getStringCellValue();
                            break;
                        }
                        case 1: {
                            value = cell.getStringCellValue().toString();
                            break;
                        }
                        case 2: {
                            XSSFFormulaEvaluator evaluator = new XSSFFormulaEvaluator(xwb);
                            CellValue cellValue = evaluator.evaluate((Cell)cell);
                            int actualType = cellValue.getCellType();
                            if (actualType == 4) {
                                value = cellValue.getBooleanValue() + "";
                                break;
                            }
                            if (actualType == 0) {
                                cell.setCellType(1);
                                value = cell.getStringCellValue();
                                break;
                            }
                            if (actualType != 1) break;
                            value = cellValue.getStringValue();
                            break;
                        }
                        case 4: {
                            value = " " + cell.getBooleanCellValue();
                            break;
                        }
                        case 3: {
                            value = "";
                            break;
                        }
                        default: {
                            value = "Error";
                        }
                    }
                    linked.add(value);
                }
                if (list.size() > 0) {
                    int headLength = ((List)list.get(0)).size();
                    int n = linked.size();
                    if (n < headLength) {
                        for (int k = n; k < headLength; ++k) {
                            linked.add(null);
                        }
                    }
                }
                if (isEmpty) {
                    for (Integer n : linked) {
                        if (n == null || !StringUtils.isNotBlank((CharSequence)String.valueOf(n))) continue;
                        isEmpty = false;
                        break;
                    }
                }
                if (!isEmpty) {
                    list.add(linked);
                    continue;
                }
                if (i > sheet.getPhysicalNumberOfRows() - 3) continue block9;
            }
        }
        return list;
    }

    private static List<Integer> get2007IdexList(XSSFWorkbook xwb, Integer projNameLine, Integer beginLine) {
        LinkedList<Integer> indexList = new LinkedList<Integer>();
        int detailIndexCellNum = 0;
        int codeCellNum = 1;
        int nameCellNum = 2;
        int descCellNum = 3;
        int unitCellNum = 4;
        int numCellNum = 5;
        int taxPriceCellNum = 6;
        int taxMnyCellNum = 7;
        int indexKnownNum = 0;
        List<List<String>> result = HuaKangExcelReader.get2007HeadData(xwb, xwb.getSheetAt(0), projNameLine, beginLine);
        Iterator<List<String>> iterator = result.iterator();
        while (iterator.hasNext()) {
            List<String> datas = iterator.next();
            int _indexKnownNum = indexKnownNum;
            for (int j = 0; j < datas.size(); ++j) {
                String s = datas.get(j);
                if (s.replaceAll("\\s*|\\r|\\n|\\t", "").contains("\u5e8f\u53f7")) {
                    detailIndexCellNum = j;
                    ++indexKnownNum;
                    continue;
                }
                if (s.replaceAll("\\s*|\\r|\\n|\\t", "").contains("\u9879\u76ee\u7f16\u7801")) {
                    codeCellNum = j;
                    ++indexKnownNum;
                    continue;
                }
                if (s.trim().replaceAll("\\s*|\\r|\\n|\\t", "").contains("\u9879\u76ee\u540d\u79f0")) {
                    nameCellNum = j;
                    ++indexKnownNum;
                    continue;
                }
                if (s.replaceAll("\\s*|\\r|\\n|\\t", "").contains("\u9879\u76ee\u7279\u5f81")) {
                    descCellNum = j;
                    ++indexKnownNum;
                    continue;
                }
                if (s.replaceAll("\\s*|\\r|\\n|\\t", "").contains("\u8ba1\u91cf\u5355\u4f4d")) {
                    unitCellNum = j;
                    ++indexKnownNum;
                    continue;
                }
                if (s.replaceAll("\\s*|\\r|\\n|\\t", "").contains("\u5de5\u7a0b\u91cf") || s.replaceAll("\\s*|\\r|\\n|\\t", "").contains("\u5de5\u7a0b\u6570\u91cf")) {
                    numCellNum = j;
                    ++indexKnownNum;
                    continue;
                }
                if (s.replaceAll("\\s*|\\r|\\n|\\t", "").contains("\u7efc\u5408\u5355\u4ef7")) {
                    taxPriceCellNum = j;
                    ++indexKnownNum;
                    continue;
                }
                if (!s.replaceAll("\\s*|\\r|\\n|\\t", "").contains("\u5408\u4ef7")) continue;
                taxMnyCellNum = j;
                ++indexKnownNum;
            }
            if (indexKnownNum > _indexKnownNum) {
                iterator.remove();
            }
            if (indexKnownNum != 8) continue;
            break;
        }
        if (indexKnownNum < 8 && result.size() == 0) {
            throw new BusinessException("\u672a\u8bc6\u522b\u8868\u5934\u5b57\u6bb5\u4fe1\u606f");
        }
        indexList.add(detailIndexCellNum);
        indexList.add(codeCellNum);
        indexList.add(nameCellNum);
        indexList.add(descCellNum);
        indexList.add(unitCellNum);
        indexList.add(numCellNum);
        indexList.add(taxPriceCellNum);
        indexList.add(taxMnyCellNum);
        return indexList;
    }

    private static List<List<String>> get2007HeadData(XSSFWorkbook xwb, XSSFSheet sheet, Integer projNameLine, Integer beginLine) {
        LinkedList<List<String>> list = new LinkedList<List<String>>();
        String value = null;
        XSSFRow row = null;
        XSSFCell cell = null;
        boolean isEmpty = true;
        int rowFirstCellNum = 0;
        int rowLastCellNum = 0;
        for (int i = sheet.getFirstRowNum() + 1; i < sheet.getPhysicalNumberOfRows(); ++i) {
            isEmpty = true;
            row = sheet.getRow(i);
            if (row == null || i < projNameLine || i >= beginLine - 1) continue;
            rowLastCellNum = row.getLastCellNum();
            LinkedList<String> linked = new LinkedList<String>();
            for (int j = rowFirstCellNum; j < rowLastCellNum; ++j) {
                cell = row.getCell(j);
                if (cell == null) {
                    linked.add("");
                    continue;
                }
                switch (cell.getCellType()) {
                    case 0: {
                        cell.setCellType(1);
                        value = cell.getStringCellValue();
                        break;
                    }
                    case 1: {
                        value = cell.getStringCellValue().toString();
                        break;
                    }
                    case 2: {
                        XSSFFormulaEvaluator xSSFFormulaEvaluator = new XSSFFormulaEvaluator(xwb);
                        CellValue cellValue = xSSFFormulaEvaluator.evaluate((Cell)cell);
                        int actualType = cellValue.getCellType();
                        if (actualType == 4) {
                            value = cellValue.getBooleanValue() + "";
                            break;
                        }
                        if (actualType == 0) {
                            cell.setCellType(1);
                            value = cell.getStringCellValue();
                            break;
                        }
                        if (actualType != 1) break;
                        value = cellValue.getStringValue();
                        break;
                    }
                    case 4: {
                        value = " " + cell.getBooleanCellValue();
                        break;
                    }
                    case 3: {
                        value = "";
                        break;
                    }
                    default: {
                        value = "Error";
                    }
                }
                linked.add(value);
            }
            if (list.size() > 0) {
                int headLength = ((List)list.get(0)).size();
                int n = linked.size();
                if (n < headLength) {
                    for (int k = n; k < headLength; ++k) {
                        linked.add(null);
                    }
                }
            }
            if (isEmpty) {
                for (Object e : linked) {
                    if (e == null || !StringUtils.isNotBlank((CharSequence)String.valueOf(e))) continue;
                    isEmpty = false;
                    break;
                }
            }
            if (!isEmpty) {
                list.add(linked);
                continue;
            }
            if (i >= beginLine) break;
        }
        return list;
    }
}

