package com.ejianc.business.budget.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 匹配结果
 *
 * @author generator
 *
 */
public class BudgetMatchVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String projectName; // 项目名称
    private Integer budgetType; // 预算类型：0-中标预算1-施工图预算2-结算预算3签证4-其他
    private Long budgetId; // 预算主键
    private String detailIndex; // 序号
    private String code; // 清单编号
    private Long parentId; // parent_id
    private String name; // 项目名称
    private String projectFeature; // 项目特征描述
    private String unit; // 计量单位
    private java.math.BigDecimal num; // 工程量
    private java.math.BigDecimal price; // 综合单价
    private java.math.BigDecimal laborCost; // 人工费
    private java.math.BigDecimal materialCost; // 材料费
    private java.math.BigDecimal mechanicalCost; // 机械费
    private java.math.BigDecimal otherCost; // 其他费用
    private java.math.BigDecimal mny; // 合价
    private Boolean leafFlag; // 是否末级
    private Integer changeType; // 变更类型,1-变更量，2-变更价，3-增补项，4-变更量价，5-中止，6-其他
    private Long changeId; // 变更主键
    private Long changeBid; // 变更子表主键
    private Long subjectId; // 成本科目主键
    private String subjectName; // 成本科目名称
    private Integer resultState; // 匹配状态 1-已匹配2-存在相似清单,3-无相似清单,4-已替换,5-已忽略
    private Integer baseResultState; // 匹配状态 1-已匹配2-存在相似清单,3-无相似清单,4-已替换,5-已忽略
    private String resultStateName;
    private Long setDetailId; // 定额清单设置子表ID
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date matchTime;// 匹配时间
    private String sheetName;

    private Long setId; // 主表ID
    private Long setTypeId; // 类型子表ID
    private String detailCode; // 清单编码
    private String detailName; // 清单名称
    private String description; // 特征描述
    private String detailUnit; // 单位
    private BigDecimal detailNum; // 工程量
    private String quotaName; // 关联定额
    private String features; // 关键特征值
    private String memo; // 备注

    public Integer getBaseResultState() {
        return baseResultState;
    }

    public void setBaseResultState(Integer baseResultState) {
        this.baseResultState = baseResultState;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Integer getBudgetType() {
        return budgetType;
    }

    public void setBudgetType(Integer budgetType) {
        this.budgetType = budgetType;
    }

    /**
     * 预算主键
     */
    public Long getBudgetId() {
        return budgetId;
    }

    /**
     * 预算主键
     */
    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }
    /**
     * 序号
     */
    public String getDetailIndex() {
        return detailIndex;
    }

    /**
     * 序号
     */
    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }
    /**
     * 清单编号
     */
    public String getCode() {
        return code;
    }

    /**
     * 清单编号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * parent_id
     */
    public Long getParentId() {
        return parentId;
    }

    /**
     * parent_id
     */
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    /**
     * 项目名称
     */
    public String getName() {
        return name;
    }

    /**
     * 项目名称
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 项目特征描述
     */
    public String getProjectFeature() {
        return projectFeature;
    }

    /**
     * 项目特征描述
     */
    public void setProjectFeature(String projectFeature) {
        this.projectFeature = projectFeature;
    }
    /**
     * 计量单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 计量单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 工程量
     */
    public java.math.BigDecimal getNum() {
        return num;
    }

    /**
     * 工程量
     */
    public void setNum(java.math.BigDecimal num) {
        this.num = num;
    }
    /**
     * 综合单价
     */
    public java.math.BigDecimal getPrice() {
        return price;
    }

    /**
     * 综合单价
     */
    public void setPrice(java.math.BigDecimal price) {
        this.price = price;
    }
    /**
     * 人工费
     */
    public java.math.BigDecimal getLaborCost() {
        return laborCost;
    }

    /**
     * 人工费
     */
    public void setLaborCost(java.math.BigDecimal laborCost) {
        this.laborCost = laborCost;
    }
    /**
     * 材料费
     */
    public java.math.BigDecimal getMaterialCost() {
        return materialCost;
    }

    /**
     * 材料费
     */
    public void setMaterialCost(java.math.BigDecimal materialCost) {
        this.materialCost = materialCost;
    }
    /**
     * 机械费
     */
    public java.math.BigDecimal getMechanicalCost() {
        return mechanicalCost;
    }

    /**
     * 机械费
     */
    public void setMechanicalCost(java.math.BigDecimal mechanicalCost) {
        this.mechanicalCost = mechanicalCost;
    }
    /**
     * 其他费用
     */
    public java.math.BigDecimal getOtherCost() {
        return otherCost;
    }

    /**
     * 其他费用
     */
    public void setOtherCost(java.math.BigDecimal otherCost) {
        this.otherCost = otherCost;
    }
    /**
     * 合价
     */
    public java.math.BigDecimal getMny() {
        return mny;
    }

    /**
     * 合价
     */
    public void setMny(java.math.BigDecimal mny) {
        this.mny = mny;
    }
    /**
     * 是否末级
     */
    public Boolean getLeafFlag() {
        return leafFlag;
    }

    /**
     * 是否末级
     */
    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }
    /**
     * 变更类型,1-变更量，2-变更价，3-增补项，4-变更量价，5-中止，6-其他
     */
    public Integer getChangeType() {
        return changeType;
    }

    /**
     * 变更类型,1-变更量，2-变更价，3-增补项，4-变更量价，5-中止，6-其他
     */
    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }
    /**
     * 变更主键
     */
    public Long getChangeId() {
        return changeId;
    }

    /**
     * 变更主键
     */
    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    /**
     * 变更子表主键
     */
    public Long getChangeBid() {
        return changeBid;
    }

    /**
     * 变更子表主键
     */
    public void setChangeBid(Long changeBid) {
        this.changeBid = changeBid;
    }
    /**
     * 成本科目主键
     */
    @ReferSerialTransfer(referCode="cost-subject-set")
    public Long getSubjectId() {
        return subjectId;
    }

    /**
     * 成本科目主键
     */
    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }
    /**
     * 成本科目名称
     */
    public String getSubjectName() {
        return subjectName;
    }

    /**
     * 成本科目名称
     */
    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public Integer getResultState() {
        return resultState;
    }

    public void setResultState(Integer resultState) {
        this.resultState = resultState;
    }

    public Long getSetDetailId() {
        return setDetailId;
    }

    public void setSetDetailId(Long setDetailId) {
        this.setDetailId = setDetailId;
    }

    public String getSheetName() {
        return sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public Date getMatchTime() {
        return matchTime;
    }

    public void setMatchTime(Date matchTime) {
        this.matchTime = matchTime;
    }

    public Long getSetId() {
        return setId;
    }

    public void setSetId(Long setId) {
        this.setId = setId;
    }

    public Long getSetTypeId() {
        return setTypeId;
    }

    public void setSetTypeId(Long setTypeId) {
        this.setTypeId = setTypeId;
    }

    public String getDetailCode() {
        return detailCode;
    }

    public void setDetailCode(String detailCode) {
        this.detailCode = detailCode;
    }

    public String getDetailName() {
        return detailName;
    }

    public void setDetailName(String detailName) {
        this.detailName = detailName;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDetailUnit() {
        return detailUnit;
    }

    public void setDetailUnit(String detailUnit) {
        this.detailUnit = detailUnit;
    }

    public BigDecimal getDetailNum() {
        return detailNum;
    }

    public void setDetailNum(BigDecimal detailNum) {
        this.detailNum = detailNum;
    }

    public String getQuotaName() {
        return quotaName;
    }

    public void setQuotaName(String quotaName) {
        this.quotaName = quotaName;
    }

    public String getFeatures() {
        return features;
    }

    public void setFeatures(String features) {
        this.features = features;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getResultStateName() {
        return resultStateName;
    }

    public void setResultStateName(String resultStateName) {
        this.resultStateName = resultStateName;
    }
}
