package com.ejianc.business.budget.utils;

import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @description: StingNameUtils
 * @author songlx
 * @date 2024/9/10
 * @version 1.0
 */
public class StringNameUtils {


    /**
     * 处理空字符
     *
     * @param str  str
     * @param flag true:只去除首尾空格，false:去除空格和空白字符
     *
     * @return {@link String}
     */
    public static String handleBlankString(String str, boolean flag) {
        if (StringUtils.isBlank(str)) {
            return "";
        }
        if (flag) {
            // 只去除首尾空格
            return str.trim();
        } else {
            // 去除空格和空白字符
            return str.replaceAll("\\s*", "");
        }
    }

    /**
     * 处理特殊字符串
     *
     * @param str str
     *
     * @return {@link String}
     */
    public static String handleSpecialString(String str) {
        // 去除特殊字符和数字，只返回英文和汉字
        Pattern p = Pattern.compile("[^(a-zA-Z\\u4e00-\\u9fa5)]");
        Matcher matcher = p.matcher(str);
        return matcher.replaceAll("");
    }




    public static List<String> splitString(String input) {
        List<String> result = new ArrayList<>();
        int length = input.length();
        int length_start = (int) Math.ceil((double) length / 2);
        int per = (int) Math.ceil((double) length / 10);
        for (int j = length_start; j <= length; j += per) {
            for (int i = 0; i <= length - j; i += per) {
                result.add(input.substring(i, i + j));
            }
        }
        return result;
    }

    public static void main(String[] args) {
        String name = "兰溪市人民医";
        String name1 = handleBlankString(name, false);
        String segmentation = handleSpecialString(name1);
        List<String> names = splitString(segmentation);
        System.out.println(names.size());
        for (String s : names) {
            System.out.println(s);
        }
    }
}
