package com.ejianc.business.budget.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.budget.vo.BudgetProjectDetailChangeProVO;
import com.ejianc.business.budget.vo.BudgetProjectHistoryProVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 项目预算变更单主实体
 *
 * @author generator
 *
 */
public class BudgetProjectChangeProVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    private Long budgetId; // 预算主键
    private String billCode; // 单据编号
    private Long orgId; // 组织主键
    private String orgName; // 组织名称
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人
    private Long departmentId; // 经办人部门id
    private String departmentName; // 经办人部门
    private BigDecimal beforeChangeBudgetTaxMny; // 之前的预算总金额（含税）
    private BigDecimal budgetTaxMny; // 预算总金额（含税）
    private BigDecimal beforeChangeBudgetMny; // 之前的预算总金额（含税）
    private BigDecimal budgetMny; // 预算总金额(无税)
    private BigDecimal beforeChangeIndirectionTaxMny; // 之前的间接费（含税）
    private BigDecimal indirectionTaxMny; // 间接费(含税)
    private BigDecimal beforeChangeIndirectionMny; // 之前的间接费(无税)
    private BigDecimal indirectionMny; // 间接费（无税）
    private BigDecimal beforeChangeLaborTaxMny; // 之前的人工费（含税）
    private BigDecimal laborTaxMny; // 人工费（含税）
    private BigDecimal beforeChangeLaborMny; // 之前的人工费（无税）
    private BigDecimal laborMny; // 人工费（无税）
    private BigDecimal beforeChangeMaterialTaxMny; // 之前的材料费(含税)
    private BigDecimal materialTaxMny; // 材料费（含税）
    private BigDecimal beforeChangeMaterialMny; // 之前的材料费（无税）
    private BigDecimal materialMny; // 材料费（无税）
    private BigDecimal beforeChangeMajorTaxMny; // 之前的专业费（含税）
    private BigDecimal majorTaxMny; // 专业费（含税）
    private BigDecimal beforeChangeMajorMny; // 之前的专业费(无税)
    private BigDecimal majorMny; // 专业费（无税）
    private BigDecimal beforeChangeMechanicalTaxMny; // 之前的机械费（含税）
    private BigDecimal mechanicalTaxMny; // 机械费(含税 )
    private BigDecimal beforeChangeMechanicalMny; // 之前机械费（无税）
    private BigDecimal mechanicalMny; // 机械费（无税）
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    private Integer billState; // 单据状态
    private String changeReason; // 变更原因
    private String memo; // 备注
    private String costTypeShow; // 备注
    /**
     * 生效日期
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date effectiveDate;
    private java.math.BigDecimal sporadicMaterialMny; // 零星材料费
    private BigDecimal taxRate; // 综合税率
    private Long sourceId; // 来源ID


    private List<BudgetProjectDetailChangeProVO> detailList = new ArrayList<>(); // 项目预算变更清单明细

    private List<BudgetProjectBusinessChangeProVO> businessList = new ArrayList<>(); // 目标成本变更-业务单据关联

    public List<BudgetProjectBusinessChangeProVO> getBusinessList() {
        return businessList;
    }

    public void setBusinessList(List<BudgetProjectBusinessChangeProVO> businessList) {
        this.businessList = businessList;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Long getBudgetId() {
        return budgetId;
    }

    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public BigDecimal getSporadicMaterialMny() {
        return sporadicMaterialMny;
    }

    public void setSporadicMaterialMny(BigDecimal sporadicMaterialMny) {
        this.sporadicMaterialMny = sporadicMaterialMny;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public BigDecimal getBeforeChangeBudgetTaxMny() {
        return beforeChangeBudgetTaxMny;
    }

    public void setBeforeChangeBudgetTaxMny(BigDecimal beforeChangeBudgetTaxMny) {
        this.beforeChangeBudgetTaxMny = beforeChangeBudgetTaxMny;
    }
    public BigDecimal getBudgetTaxMny() {
        return budgetTaxMny;
    }

    public void setBudgetTaxMny(BigDecimal budgetTaxMny) {
        this.budgetTaxMny = budgetTaxMny;
    }
    public BigDecimal getBeforeChangeBudgetMny() {
        return beforeChangeBudgetMny;
    }

    public void setBeforeChangeBudgetMny(BigDecimal beforeChangeBudgetMny) {
        this.beforeChangeBudgetMny = beforeChangeBudgetMny;
    }
    public BigDecimal getBudgetMny() {
        return budgetMny;
    }

    public void setBudgetMny(BigDecimal budgetMny) {
        this.budgetMny = budgetMny;
    }

    public BigDecimal getBeforeChangeIndirectionTaxMny() {
        return beforeChangeIndirectionTaxMny;
    }

    public void setBeforeChangeIndirectionTaxMny(BigDecimal beforeChangeIndirectionTaxMny) {
        this.beforeChangeIndirectionTaxMny = beforeChangeIndirectionTaxMny;
    }

    public BigDecimal getIndirectionTaxMny() {
        return indirectionTaxMny;
    }

    public void setIndirectionTaxMny(BigDecimal indirectionTaxMny) {
        this.indirectionTaxMny = indirectionTaxMny;
    }
    public BigDecimal getBeforeChangeIndirectionMny() {
        return beforeChangeIndirectionMny;
    }

    public void setBeforeChangeIndirectionMny(BigDecimal beforeChangeIndirectionMny) {
        this.beforeChangeIndirectionMny = beforeChangeIndirectionMny;
    }
    public BigDecimal getIndirectionMny() {
        return indirectionMny;
    }

    public void setIndirectionMny(BigDecimal indirectionMny) {
        this.indirectionMny = indirectionMny;
    }
    public BigDecimal getBeforeChangeLaborTaxMny() {
        return beforeChangeLaborTaxMny;
    }

    public void setBeforeChangeLaborTaxMny(BigDecimal beforeChangeLaborTaxMny) {
        this.beforeChangeLaborTaxMny = beforeChangeLaborTaxMny;
    }
    public BigDecimal getLaborTaxMny() {
        return laborTaxMny;
    }

    public void setLaborTaxMny(BigDecimal laborTaxMny) {
        this.laborTaxMny = laborTaxMny;
    }
    public BigDecimal getBeforeChangeLaborMny() {
        return beforeChangeLaborMny;
    }

    public void setBeforeChangeLaborMny(BigDecimal beforeChangeLaborMny) {
        this.beforeChangeLaborMny = beforeChangeLaborMny;
    }
    public BigDecimal getLaborMny() {
        return laborMny;
    }

    public void setLaborMny(BigDecimal laborMny) {
        this.laborMny = laborMny;
    }
    public BigDecimal getBeforeChangeMaterialTaxMny() {
        return beforeChangeMaterialTaxMny;
    }

    public void setBeforeChangeMaterialTaxMny(BigDecimal beforeChangeMaterialTaxMny) {
        this.beforeChangeMaterialTaxMny = beforeChangeMaterialTaxMny;
    }
    public BigDecimal getMaterialTaxMny() {
        return materialTaxMny;
    }

    public void setMaterialTaxMny(BigDecimal materialTaxMny) {
        this.materialTaxMny = materialTaxMny;
    }
    public BigDecimal getBeforeChangeMaterialMny() {
        return beforeChangeMaterialMny;
    }

    public void setBeforeChangeMaterialMny(BigDecimal beforeChangeMaterialMny) {
        this.beforeChangeMaterialMny = beforeChangeMaterialMny;
    }
    public BigDecimal getMaterialMny() {
        return materialMny;
    }

    public void setMaterialMny(BigDecimal materialMny) {
        this.materialMny = materialMny;
    }
    public BigDecimal getBeforeChangeMajorTaxMny() {
        return beforeChangeMajorTaxMny;
    }

    public void setBeforeChangeMajorTaxMny(BigDecimal beforeChangeMajorTaxMny) {
        this.beforeChangeMajorTaxMny = beforeChangeMajorTaxMny;
    }
    public BigDecimal getMajorTaxMny() {
        return majorTaxMny;
    }

    public void setMajorTaxMny(BigDecimal majorTaxMny) {
        this.majorTaxMny = majorTaxMny;
    }
    public BigDecimal getBeforeChangeMajorMny() {
        return beforeChangeMajorMny;
    }

    public void setBeforeChangeMajorMny(BigDecimal beforeChangeMajorMny) {
        this.beforeChangeMajorMny = beforeChangeMajorMny;
    }
    public BigDecimal getMajorMny() {
        return majorMny;
    }

    public void setMajorMny(BigDecimal majorMny) {
        this.majorMny = majorMny;
    }
    public BigDecimal getBeforeChangeMechanicalTaxMny() {
        return beforeChangeMechanicalTaxMny;
    }

    public void setBeforeChangeMechanicalTaxMny(BigDecimal beforeChangeMechanicalTaxMny) {
        this.beforeChangeMechanicalTaxMny = beforeChangeMechanicalTaxMny;
    }
    public BigDecimal getMechanicalTaxMny() {
        return mechanicalTaxMny;
    }

    public void setMechanicalTaxMny(BigDecimal mechanicalTaxMny) {
        this.mechanicalTaxMny = mechanicalTaxMny;
    }
    public BigDecimal getBeforeChangeMechanicalMny() {
        return beforeChangeMechanicalMny;
    }

    public void setBeforeChangeMechanicalMny(BigDecimal beforeChangeMechanicalMny) {
        this.beforeChangeMechanicalMny = beforeChangeMechanicalMny;
    }
    public BigDecimal getMechanicalMny() {
        return mechanicalMny;
    }

    public void setMechanicalMny(BigDecimal mechanicalMny) {
        this.mechanicalMny = mechanicalMny;
    }
    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getCostTypeShow() {
        return costTypeShow;
    }

    public void setCostTypeShow(String costTypeShow) {
        this.costTypeShow = costTypeShow;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public List<BudgetProjectDetailChangeProVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<BudgetProjectDetailChangeProVO> detailList) {
        this.detailList = detailList;
    }
}
