package com.ejianc.business.cost.api;

import com.ejianc.business.cost.hystrix.CostDocumentsHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;

/**
 * 费用项明细中间表交互
 *
 * @author sunyj
 *
 */
@FeignClient(name= "ejc-cost-web", url="${common.env.feign-client-url}", path="ejc-cost-web", fallback = CostDocumentsHystrix.class)
public interface ICostDocumentsApi {

    @GetMapping(value = "/api/costDocuments/queryFeeMny")
    CommonResponse<BigDecimal> queryFeeMny(@RequestParam(value = "projectId") Long projectId, @RequestParam(value = "feeTypeId") Long feeTypeId);

}
