package com.ejianc.business.cost.vo;

import com.ejianc.business.cost.utils.ITreeNodeB;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

/**
 * 数据对象
 *
 * @author sunyj
 *
 *
 */
public class TemplateDatas implements ITreeNodeB {
    private static final long serialVersionUID = 8038149984818112449L;

    private Long id;
    private String subjectName;//科目名称
    private String subjectCode;//科目编码
    private String detailIndex;
    private Long parentId;
    private Integer number;
    private BigDecimal periodMnys;//期间合计
    private FieldItem fields;
    private TemplateItem data;
    private List<ITreeNodeB> children;

    public static TemplateDatas New() {
        return new TemplateDatas();
    }

    private TemplateDatas() {
        this.data = new TemplateItem();
        this.fields = new FieldItem();
    }

    public Integer getNumber() {
        return number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public TemplateDatas setSubjectName(String subjectName) {
        this.subjectName = subjectName;
        return this;
    }

	public String getsetSubjectCode() {
        return subjectCode;
    }

    public TemplateDatas setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
        return this;
    }

    public BigDecimal getPeriodMnys() {
        return periodMnys;
    }

    public TemplateDatas setPeriodMnys(BigDecimal periodMnys) {
        this.periodMnys = periodMnys;
        return this;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSubjectCode() {
        return subjectCode;
    }

    public String getDetailIndex() {
        return detailIndex;
    }

    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public void setChildren(List<ITreeNodeB> children) {
        this.children = children;
    }

    public FieldItem getFields() {
        return fields;
    }

    public TemplateItem getData() {
        return data;
    }

    public TemplateDatas addMin(String key, BigDecimal value){
        return this;
    }
    public TemplateDatas add(String key, BigDecimal value){
        data.put(key, value);
        return this;
    }

    public TemplateDatas addField(String key, String value){
        fields.put(key, value);
        return this;
    }

    public class TemplateItem extends LinkedHashMap<String, BigDecimal> {

        private static final long serialVersionUID = -3728490424738325020L;

        public TemplateItem() {}

        public TemplateItem(String key, BigDecimal value) {
            this.put(key, value);
        }
    }


    public class FieldItem extends LinkedHashMap<String, String> {

        private static final long serialVersionUID = -3728490424738325020L;

        public FieldItem() {}

        public FieldItem(String key, String value) {
            this.put(key, value);
        }
    }

    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;

    }
}
