package com.ejianc.business.cost.vo;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 成本设置
 * 
 * @author generator
 * 
 */
public class SettingVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String taxFlag; // 是否含税 0-是，1-否
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private String materialCost; // 物资成本 0-出库入成本，1-物资合同结算入成本
    private String periodRule; // 期间规则 0-固定日期，1-自然月
    private Integer endDay; // 月结束日期
    private String memo; // 备注
    private Integer billState; // 单据状态（审批必须字段）
    private String createUserName; // 创建人名称
    private Integer pushFlag; // 是否推送 1是 0 否
    private String costTypeShow; //費用类型显示

    // 科目明细子表
    private List<SubjectVO> subjectDetails = new ArrayList<SubjectVO>();

    public List<SubjectVO> getSubjectDetails() {
        return subjectDetails;
    }

    public void setSubjectDetails(List<SubjectVO> subjectDetails) {
        this.subjectDetails = subjectDetails;
    }

    /**
     * 是否含税 0-是，1-否
     */
    public String getTaxFlag() {
        return taxFlag;
    }

    /**
     * 是否含税 0-是，1-否
     */
    public void setTaxFlag(String taxFlag) {
        this.taxFlag = taxFlag;
    }
    /**
     * 项目
     */
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 物资成本 0-出库入成本，1-物资合同结算入成本
     */
    public String getMaterialCost() {
        return materialCost;
    }

    /**
     * 物资成本 0-出库入成本，1-物资合同结算入成本
     */
    public void setMaterialCost(String materialCost) {
        this.materialCost = materialCost;
    }
    /**
     * 期间规则 0-固定日期，1-自然月
     */
    public String getPeriodRule() {
        return periodRule;
    }

    /**
     * 期间规则 0-固定日期，1-自然月
     */
    public void setPeriodRule(String periodRule) {
        this.periodRule = periodRule;
    }
    /**
     * 月结束日期
     */
    public Integer getEndDay() {
        return endDay;
    }

    /**
     * 月结束日期
     */
    public void setEndDay(Integer endDay) {
        this.endDay = endDay;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 创建人名称
     */
    public String getCreateUserName() {
        return createUserName;
    }

    /**
     * 创建人名称
     */
    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public Integer getPushFlag() {
        return pushFlag;
    }

    public void setPushFlag(Integer pushFlag) {
        this.pushFlag = pushFlag;
    }

    public String getCostTypeShow() {
        return costTypeShow;
    }

    public void setCostTypeShow(String costTypeShow) {
        this.costTypeShow = costTypeShow;
    }
}
