package com.ejianc.business.cost.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.cost.vo.AdjustmentDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 预算量调整申请单
 * 
 * @author generator
 * 
 */
public class AdjustmentVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编号
    private Long projectId; // 项目id
    private String projectCode; // 项目code
    private String projectName; // 项目名称
    private String theme; // 主题
    private Integer changeType; // 变更类型 0-清单内,1-清单外
    private String changeTypeName;//变更类型
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyTime; // 申请日期
    private String memo; // 具体说明
    private String adjustmentReason; // 调整原因
    private Integer adjustmentNormal; // 正常调量
    private Integer projectReason; // 项目原因
    private BigDecimal sum; // 累计
    private String projectPerson; // 项目责任人
    private Integer budgetReason; // 预算量
    private String budgetPerson; // 预算责任人
    private Integer drawingReason; // 图纸原因
    private String drawingPerson; // 图纸责任人
    private Integer gifts; // 赠送
    private BigDecimal giftsSum; // 累计赠送
    private BigDecimal giftsAlready; // 已赠送
    private BigDecimal giftsThis; // 本次赠送
    private String giftsReason; // 赠送原因
    private String laborMemo; // 对应的劳务标段
    private Integer isAuditing; // 是否需要总经理审核
    private Integer isVisa; // 是否需要办理对外签证
    private Integer isReason; // 是否项目原因
    private BigDecimal deductionMny; // 扣款金额
    private String visaMemo; // 对外签证办理事项
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long employeeId; // 申请人
    private String employeeName; // 申请人名称
    private Long departmentId; // 申请部门
    private String departmentName; // 申请部门名称
    private Long parentOrgId; // 项目部上级组织Id（区域名称）
    private String parentOrgName; // 项目部上级组织名称
    private String parentOrgCode; // 项目部上级组织编码
    private Integer billState; // 单据状态
    private String billStateName; // 单据状态翻译字段

    // 2025-03-06 添加字段
    private BigDecimal adjustmentNormalMny; // 正常调量金额
    private BigDecimal projectReasonMny; // 项目原因金额
    private BigDecimal budgetReasonMny; // 预算量金额
    private BigDecimal drawingReasonMny; // 图纸原因金额
    private BigDecimal giftsMny; // 赠送金额
    private String giftsPerson; // 赠送责任人

    private List<AdjustmentDetailVO> adjustmentDetailList = new ArrayList<>(); // 预算量调整申请单-ERP材料调整表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getTheme() {
        return theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }
    public Integer getChangeType() {
        return changeType;
    }

    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }
    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getAdjustmentReason() {
        return adjustmentReason;
    }

    public void setAdjustmentReason(String adjustmentReason) {
        this.adjustmentReason = adjustmentReason;
    }
    public Integer getAdjustmentNormal() {
        return adjustmentNormal;
    }

    public void setAdjustmentNormal(Integer adjustmentNormal) {
        this.adjustmentNormal = adjustmentNormal;
    }
    public Integer getProjectReason() {
        return projectReason;
    }

    public void setProjectReason(Integer projectReason) {
        this.projectReason = projectReason;
    }
    public BigDecimal getSum() {
        return sum;
    }

    public void setSum(BigDecimal sum) {
        this.sum = sum;
    }
    public String getProjectPerson() {
        return projectPerson;
    }

    public void setProjectPerson(String projectPerson) {
        this.projectPerson = projectPerson;
    }
    public Integer getBudgetReason() {
        return budgetReason;
    }

    public void setBudgetReason(Integer budgetReason) {
        this.budgetReason = budgetReason;
    }
    public String getBudgetPerson() {
        return budgetPerson;
    }

    public void setBudgetPerson(String budgetPerson) {
        this.budgetPerson = budgetPerson;
    }
    public Integer getDrawingReason() {
        return drawingReason;
    }

    public void setDrawingReason(Integer drawingReason) {
        this.drawingReason = drawingReason;
    }
    public String getDrawingPerson() {
        return drawingPerson;
    }

    public void setDrawingPerson(String drawingPerson) {
        this.drawingPerson = drawingPerson;
    }
    public Integer getGifts() {
        return gifts;
    }

    public void setGifts(Integer gifts) {
        this.gifts = gifts;
    }
    public BigDecimal getGiftsSum() {
        return giftsSum;
    }

    public void setGiftsSum(BigDecimal giftsSum) {
        this.giftsSum = giftsSum;
    }
    public BigDecimal getGiftsAlready() {
        return giftsAlready;
    }

    public void setGiftsAlready(BigDecimal giftsAlready) {
        this.giftsAlready = giftsAlready;
    }
    public BigDecimal getGiftsThis() {
        return giftsThis;
    }

    public void setGiftsThis(BigDecimal giftsThis) {
        this.giftsThis = giftsThis;
    }

    public String getGiftsReason() {
        return giftsReason;
    }

    public void setGiftsReason(String giftsReason) {
        this.giftsReason = giftsReason;
    }

    public String getLaborMemo() {
        return laborMemo;
    }

    public void setLaborMemo(String laborMemo) {
        this.laborMemo = laborMemo;
    }
    public Integer getIsAuditing() {
        return isAuditing;
    }

    public void setIsAuditing(Integer isAuditing) {
        this.isAuditing = isAuditing;
    }
    public Integer getIsVisa() {
        return isVisa;
    }

    public void setIsVisa(Integer isVisa) {
        this.isVisa = isVisa;
    }
    public Integer getIsReason() {
        return isReason;
    }

    public void setIsReason(Integer isReason) {
        this.isReason = isReason;
    }
    public BigDecimal getDeductionMny() {
        return deductionMny;
    }

    public void setDeductionMny(BigDecimal deductionMny) {
        this.deductionMny = deductionMny;
    }
    public String getVisaMemo() {
        return visaMemo;
    }

    public void setVisaMemo(String visaMemo) {
        this.visaMemo = visaMemo;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public String getChangeTypeName() {
        return changeTypeName;
    }

    public void setChangeTypeName(String changeTypeName) {
        this.changeTypeName = changeTypeName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public List<AdjustmentDetailVO> getAdjustmentDetailList() {
        return adjustmentDetailList;
    }

    public void setAdjustmentDetailList(List<AdjustmentDetailVO> adjustmentDetailList) {
        this.adjustmentDetailList = adjustmentDetailList;
    }

    public BigDecimal getAdjustmentNormalMny() {
        return adjustmentNormalMny;
    }

    public void setAdjustmentNormalMny(BigDecimal adjustmentNormalMny) {
        this.adjustmentNormalMny = adjustmentNormalMny;
    }

    public BigDecimal getProjectReasonMny() {
        return projectReasonMny;
    }

    public void setProjectReasonMny(BigDecimal projectReasonMny) {
        this.projectReasonMny = projectReasonMny;
    }

    public BigDecimal getBudgetReasonMny() {
        return budgetReasonMny;
    }

    public void setBudgetReasonMny(BigDecimal budgetReasonMny) {
        this.budgetReasonMny = budgetReasonMny;
    }

    public BigDecimal getDrawingReasonMny() {
        return drawingReasonMny;
    }

    public void setDrawingReasonMny(BigDecimal drawingReasonMny) {
        this.drawingReasonMny = drawingReasonMny;
    }

    public BigDecimal getGiftsMny() {
        return giftsMny;
    }

    public void setGiftsMny(BigDecimal giftsMny) {
        this.giftsMny = giftsMny;
    }

    public String getGiftsPerson() {
        return giftsPerson;
    }

    public void setGiftsPerson(String giftsPerson) {
        this.giftsPerson = giftsPerson;
    }

}
