package com.ejianc.business.budget.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.budget.hystrix.BudgetProjectHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 预算API接口
 *
 * @author yqls
 *
 */
@FeignClient(name= "ejc-cost-web", url="${common.env.feign-client-url}", path="ejc-cost-web", fallback = BudgetProjectHystrix.class)
public interface IBudgetProjectApi {

	/**
	 * 根据queryParam查询预算列表
	 * @param queryParam
	 * @return
	 */
	@PostMapping(value = "/api/budget/getBudgetListByQueryParam")
	public CommonResponse<JSONObject> getBudgetListByQueryParam(@RequestBody QueryParam queryParam);


}
