package com.ejianc.business.budget.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;


/**
 * 目标成本变更-业务单据关联
 *
 * @author generator
 *
 */
public class BudgetProjectBusinessChangeProVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long budgetChangeId; // 变更主表id
    private Long busId; // 单据ID
    private String busType; // 单据类型
    private String busCode; // 单据编码
    private String busMemo; // 说明
    private Long busEmployeeId; // 经办人
    private String busEmployeeName; // 经办人
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date busDate; // 日期

    public Long getBusId() {
        return busId;
    }

    public void setBusId(Long busId) {
        this.busId = busId;
    }

    public Long getBudgetChangeId() {
        return budgetChangeId;
    }

    public void setBudgetChangeId(Long budgetChangeId) {
        this.budgetChangeId = budgetChangeId;
    }

    public String getBusType() {
        return busType;
    }

    public void setBusType(String busType) {
        this.busType = busType;
    }

    public String getBusCode() {
        return busCode;
    }

    public void setBusCode(String busCode) {
        this.busCode = busCode;
    }

    public String getBusMemo() {
        return busMemo;
    }

    public void setBusMemo(String busMemo) {
        this.busMemo = busMemo;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getBusEmployeeId() {
        return busEmployeeId;
    }

    @ReferDeserialTransfer
    public void setBusEmployeeId(Long busEmployeeId) {
        this.busEmployeeId = busEmployeeId;
    }

    public String getBusEmployeeName() {
        return busEmployeeName;
    }

    public void setBusEmployeeName(String busEmployeeName) {
        this.busEmployeeName = busEmployeeName;
    }

    public Date getBusDate() {
        return busDate;
    }

    public void setBusDate(Date busDate) {
        this.busDate = busDate;
    }

}
