package com.ejianc.business.budget.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 项目预算变更单
 *
 * @author generator
 *
 */
 @TableName("ejc_budget_project_change")
public class BudgetProjectChangeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="budget_id")
    private Long budgetId; // 预算主键
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="unassociate")
    private Integer unassociate; // 未关联科目项
    @TableField(value="budget_mny")
    private java.math.BigDecimal budgetMny; // 预算金额
    @TableField(value="labor_mny")
    private java.math.BigDecimal laborMny; // 人工费
    @TableField(value="material_mny")
    private java.math.BigDecimal materialMny; // 材料费
    @TableField(value="mechanical_mny")
    private java.math.BigDecimal mechanicalMny; // 机械费
    @TableField(value="other_mny")
    private java.math.BigDecimal otherMny; // 其他费
    @TableField(value="change_status")
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    @TableField(value="change_version")
    private Integer changeVersion; // 变更版本
    @TableField(value="change_code")
    private String changeCode; // 变更单号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="linked_flag")
    private Integer linkedFlag; // 是否关联科目
    @TableField(value="base_budget_money")
    private java.math.BigDecimal baseBudgetMoney; // 初始版本金额
    @TableField(value="before_change_budget_mny")
    private java.math.BigDecimal beforeChangeBudgetMny; // 变更前金额
    @TableField(value="base_labor_mny")
    private java.math.BigDecimal baseLaborMny; // 初始版本人工费
    @TableField(value="before_change_labor_mny")
    private java.math.BigDecimal beforeChangeLaborMny; // 变更前人工费
    @TableField(value="base_material_mny")
    private java.math.BigDecimal baseMaterialMny; // 初始版本材料费
    @TableField(value="before_change_material_mny")
    private java.math.BigDecimal beforeChangeMaterialMny; // 变更前材料费
    @TableField(value="base_mechanical_mny")
    private java.math.BigDecimal baseMechanicalMny; // 初始版本机械费
    @TableField(value="before_change_mechanical_mny")
    private java.math.BigDecimal beforeChangeMechanicalMny; // 变更前机械费
    @TableField(value="base_other_mny")
    private java.math.BigDecimal baseOtherMny; // 初始版本其他费用
    @TableField(value="before_change_other_mny")
    private java.math.BigDecimal beforeChangeOtherMny; // 变更前其他费用
    @TableField(value="change_reason")
    private String changeReason; // 变更原因
    @TableField(value="budget_type")
    private Integer budgetType; // 预算类型：0-中标预算1-施工图预算2-结算预算3-变更4-签证5-索赔6-其他
    /**
     * 生效时间
     */
    @TableField("used_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date usedTime;

    @TableField(exist=false)
    @SubEntity(serviceName="budgetProjectDetailChangeService",pidName = "budgetChangeId")
    private List<BudgetProjectDetailChangeEntity> checkList = new ArrayList<>(); // 项目预算变更清单


    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Date getUsedTime() {
        return usedTime;
    }

    public void setUsedTime(Date usedTime) {
        this.usedTime = usedTime;
    }

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    /**
     * 预算主键
     */
    public Long getBudgetId() {
        return budgetId;
    }

    /**
     * 预算主键
     */
    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 未关联科目项
     */
    public Integer getUnassociate() {
        return unassociate;
    }

    /**
     * 未关联科目项
     */
    public void setUnassociate(Integer unassociate) {
        this.unassociate = unassociate;
    }
    /**
     * 预算金额
     */
    public java.math.BigDecimal getBudgetMny() {
        return budgetMny;
    }

    /**
     * 预算金额
     */
    public void setBudgetMny(java.math.BigDecimal budgetMny) {
        this.budgetMny = budgetMny;
    }
    /**
     * 人工费
     */
    public java.math.BigDecimal getLaborMny() {
        return laborMny;
    }

    /**
     * 人工费
     */
    public void setLaborMny(java.math.BigDecimal laborMny) {
        this.laborMny = laborMny;
    }
    /**
     * 材料费
     */
    public java.math.BigDecimal getMaterialMny() {
        return materialMny;
    }

    /**
     * 材料费
     */
    public void setMaterialMny(java.math.BigDecimal materialMny) {
        this.materialMny = materialMny;
    }
    /**
     * 机械费
     */
    public java.math.BigDecimal getMechanicalMny() {
        return mechanicalMny;
    }

    /**
     * 机械费
     */
    public void setMechanicalMny(java.math.BigDecimal mechanicalMny) {
        this.mechanicalMny = mechanicalMny;
    }
    /**
     * 其他费
     */
    public java.math.BigDecimal getOtherMny() {
        return otherMny;
    }

    /**
     * 其他费
     */
    public void setOtherMny(java.math.BigDecimal otherMny) {
        this.otherMny = otherMny;
    }
    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    public Integer getChangeStatus() {
        return changeStatus;
    }

    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    /**
     * 变更版本
     */
    public Integer getChangeVersion() {
        return changeVersion;
    }

    /**
     * 变更版本
     */
    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    /**
     * 变更单号
     */
    public String getChangeCode() {
        return changeCode;
    }

    /**
     * 变更单号
     */
    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 是否关联科目
     */
    public Integer getLinkedFlag() {
        return linkedFlag;
    }

    /**
     * 是否关联科目
     */
    public void setLinkedFlag(Integer linkedFlag) {
        this.linkedFlag = linkedFlag;
    }
    /**
     * 初始版本金额
     */
    public java.math.BigDecimal getBaseBudgetMoney() {
        return baseBudgetMoney;
    }

    /**
     * 初始版本金额
     */
    public void setBaseBudgetMoney(java.math.BigDecimal baseBudgetMoney) {
        this.baseBudgetMoney = baseBudgetMoney;
    }
    /**
     * 变更前金额
     */
    public java.math.BigDecimal getBeforeChangeBudgetMny() {
        return beforeChangeBudgetMny;
    }

    /**
     * 变更前金额
     */
    public void setBeforeChangeBudgetMny(java.math.BigDecimal beforeChangeBudgetMny) {
        this.beforeChangeBudgetMny = beforeChangeBudgetMny;
    }
    /**
     * 初始版本人工费
     */
    public java.math.BigDecimal getBaseLaborMny() {
        return baseLaborMny;
    }

    /**
     * 初始版本人工费
     */
    public void setBaseLaborMny(java.math.BigDecimal baseLaborMny) {
        this.baseLaborMny = baseLaborMny;
    }
    /**
     * 变更前人工费
     */
    public java.math.BigDecimal getBeforeChangeLaborMny() {
        return beforeChangeLaborMny;
    }

    /**
     * 变更前人工费
     */
    public void setBeforeChangeLaborMny(java.math.BigDecimal beforeChangeLaborMny) {
        this.beforeChangeLaborMny = beforeChangeLaborMny;
    }
    /**
     * 初始版本材料费
     */
    public java.math.BigDecimal getBaseMaterialMny() {
        return baseMaterialMny;
    }

    /**
     * 初始版本材料费
     */
    public void setBaseMaterialMny(java.math.BigDecimal baseMaterialMny) {
        this.baseMaterialMny = baseMaterialMny;
    }
    /**
     * 变更前材料费
     */
    public java.math.BigDecimal getBeforeChangeMaterialMny() {
        return beforeChangeMaterialMny;
    }

    /**
     * 变更前材料费
     */
    public void setBeforeChangeMaterialMny(java.math.BigDecimal beforeChangeMaterialMny) {
        this.beforeChangeMaterialMny = beforeChangeMaterialMny;
    }
    /**
     * 初始版本机械费
     */
    public java.math.BigDecimal getBaseMechanicalMny() {
        return baseMechanicalMny;
    }

    /**
     * 初始版本机械费
     */
    public void setBaseMechanicalMny(java.math.BigDecimal baseMechanicalMny) {
        this.baseMechanicalMny = baseMechanicalMny;
    }
    /**
     * 变更前机械费
     */
    public java.math.BigDecimal getBeforeChangeMechanicalMny() {
        return beforeChangeMechanicalMny;
    }

    /**
     * 变更前机械费
     */
    public void setBeforeChangeMechanicalMny(java.math.BigDecimal beforeChangeMechanicalMny) {
        this.beforeChangeMechanicalMny = beforeChangeMechanicalMny;
    }
    /**
     * 初始版本其他费用
     */
    public java.math.BigDecimal getBaseOtherMny() {
        return baseOtherMny;
    }

    /**
     * 初始版本其他费用
     */
    public void setBaseOtherMny(java.math.BigDecimal baseOtherMny) {
        this.baseOtherMny = baseOtherMny;
    }
    /**
     * 变更前其他费用
     */
    public java.math.BigDecimal getBeforeChangeOtherMny() {
        return beforeChangeOtherMny;
    }

    /**
     * 变更前其他费用
     */
    public void setBeforeChangeOtherMny(java.math.BigDecimal beforeChangeOtherMny) {
        this.beforeChangeOtherMny = beforeChangeOtherMny;
    }

    public Integer getBudgetType() {
        return budgetType;
    }

    public void setBudgetType(Integer budgetType) {
        this.budgetType = budgetType;
    }

    public List<BudgetProjectDetailChangeEntity> getCheckList() {
        return checkList;
    }

    public void setCheckList(List<BudgetProjectDetailChangeEntity> checkList) {
        this.checkList = checkList;
    }
}
