package com.ejianc.business.budget.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.budget.bean.BudgetProjectDetailChangeProEntity;
import com.ejianc.business.budget.bean.BudgetProjectHistoryProEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 项目预算变更单主实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_budget_project_change_pro")
public class BudgetProjectChangeProEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="budget_id")
    private Long budgetId; // 预算主键
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="org_id")
    private Long orgId; // 组织主键
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="department_id")
    private Long departmentId; // 经办人部门id
    @TableField(value="department_name")
    private String departmentName; // 经办人部门
    @TableField(value="before_change_budget_tax_mny")
    private BigDecimal beforeChangeBudgetTaxMny; // 之前的预算总金额（含税）
    @TableField(value="budget_tax_mny")
    private BigDecimal budgetTaxMny; // 预算总金额（含税）
    @TableField(value="before_change_budget_mny")
    private BigDecimal beforeChangeBudgetMny; // 之前的预算总金额（含税）
    @TableField(value="budget_mny")
    private BigDecimal budgetMny; // 预算总金额(无税)
    @TableField(value="before_change_indirection_tax_mny")
    private String beforeChangeIndirectionTaxMny; // 之前的间接费（含税）
    @TableField(value="indirection_tax_mny")
    private BigDecimal indirectionTaxMny; // 间接费(含税)
    @TableField(value="before_change_indirection_mny")
    private BigDecimal beforeChangeIndirectionMny; // 之前的间接费(无税)
    @TableField(value="sporadic_material_mny")
    private java.math.BigDecimal sporadicMaterialMny; // 零星材料费
    @TableField(value="indirection_mny")
    private BigDecimal indirectionMny; // 间接费（无税）
    @TableField(value="before_change_labor_tax_mny")
    private BigDecimal beforeChangeLaborTaxMny; // 之前的人工费（含税）
    @TableField(value="labor_tax_mny")
    private BigDecimal laborTaxMny; // 人工费（含税）
    @TableField(value="before_change_labor_mny")
    private BigDecimal beforeChangeLaborMny; // 之前的人工费（无税）
    @TableField(value="labor_mny")
    private BigDecimal laborMny; // 人工费（无税）
    @TableField(value="before_change_material_tax_mny")
    private BigDecimal beforeChangeMaterialTaxMny; // 之前的材料费(含税)
    @TableField(value="material_tax_mny")
    private BigDecimal materialTaxMny; // 材料费（含税）
    @TableField(value="before_change_material_mny")
    private BigDecimal beforeChangeMaterialMny; // 之前的材料费（无税）
    @TableField(value="material_mny")
    private BigDecimal materialMny; // 材料费（无税）
    @TableField(value="before_change_major_tax_mny")
    private BigDecimal beforeChangeMajorTaxMny; // 之前的专业费（含税）
    @TableField(value="major_tax_mny")
    private BigDecimal majorTaxMny; // 专业费（含税）
    @TableField(value="before_change_major_mny")
    private BigDecimal beforeChangeMajorMny; // 之前的专业费(无税)
    @TableField(value="major_mny")
    private BigDecimal majorMny; // 专业费（无税）
    @TableField(value="before_change_mechanical_tax_mny")
    private BigDecimal beforeChangeMechanicalTaxMny; // 之前的机械费（含税）
    @TableField(value="mechanical_tax_mny")
    private BigDecimal mechanicalTaxMny; // 机械费(含税 )
    @TableField(value="before_change_mechanical_mny")
    private BigDecimal beforeChangeMechanicalMny; // 之前机械费（无税）
    @TableField(value="mechanical_mny")
    private BigDecimal mechanicalMny; // 机械费（无税）
    @TableField(value="change_status")
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="change_reason")
    private String changeReason; // 变更原因
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="cost_type_show")
    private String costTypeShow; // 费用类型显示
    /**
     * 生效日期
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value = "effective_date")
    private Date effectiveDate;
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 综合税率


    @TableField(exist=false)
    @SubEntity(serviceName="budgetProjectDetailChangeProService",pidName = "budgetChangeId")//此处有pid="xxx"，默认值pid="pid"
    private List<BudgetProjectDetailChangeProEntity> detailList = new ArrayList<>(); // 项目预算变更清单明细

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Long getBudgetId() {
        return budgetId;
    }

    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public BigDecimal getBeforeChangeBudgetTaxMny() {
        return beforeChangeBudgetTaxMny;
    }

    public void setBeforeChangeBudgetTaxMny(BigDecimal beforeChangeBudgetTaxMny) {
        this.beforeChangeBudgetTaxMny = beforeChangeBudgetTaxMny;
    }
    public BigDecimal getBudgetTaxMny() {
        return budgetTaxMny;
    }

    public void setBudgetTaxMny(BigDecimal budgetTaxMny) {
        this.budgetTaxMny = budgetTaxMny;
    }
    public BigDecimal getBeforeChangeBudgetMny() {
        return beforeChangeBudgetMny;
    }

    public void setBeforeChangeBudgetMny(BigDecimal beforeChangeBudgetMny) {
        this.beforeChangeBudgetMny = beforeChangeBudgetMny;
    }
    public BigDecimal getBudgetMny() {
        return budgetMny;
    }

    public BigDecimal getSporadicMaterialMny() {
        return sporadicMaterialMny;
    }

    public void setSporadicMaterialMny(BigDecimal sporadicMaterialMny) {
        this.sporadicMaterialMny = sporadicMaterialMny;
    }

    public void setBudgetMny(BigDecimal budgetMny) {
        this.budgetMny = budgetMny;
    }
    public String getBeforeChangeIndirectionTaxMny() {
        return beforeChangeIndirectionTaxMny;
    }

    public void setBeforeChangeIndirectionTaxMny(String beforeChangeIndirectionTaxMny) {
        this.beforeChangeIndirectionTaxMny = beforeChangeIndirectionTaxMny;
    }
    public BigDecimal getIndirectionTaxMny() {
        return indirectionTaxMny;
    }

    public void setIndirectionTaxMny(BigDecimal indirectionTaxMny) {
        this.indirectionTaxMny = indirectionTaxMny;
    }
    public BigDecimal getBeforeChangeIndirectionMny() {
        return beforeChangeIndirectionMny;
    }

    public void setBeforeChangeIndirectionMny(BigDecimal beforeChangeIndirectionMny) {
        this.beforeChangeIndirectionMny = beforeChangeIndirectionMny;
    }
    public BigDecimal getIndirectionMny() {
        return indirectionMny;
    }

    public void setIndirectionMny(BigDecimal indirectionMny) {
        this.indirectionMny = indirectionMny;
    }
    public BigDecimal getBeforeChangeLaborTaxMny() {
        return beforeChangeLaborTaxMny;
    }

    public void setBeforeChangeLaborTaxMny(BigDecimal beforeChangeLaborTaxMny) {
        this.beforeChangeLaborTaxMny = beforeChangeLaborTaxMny;
    }
    public BigDecimal getLaborTaxMny() {
        return laborTaxMny;
    }

    public void setLaborTaxMny(BigDecimal laborTaxMny) {
        this.laborTaxMny = laborTaxMny;
    }
    public BigDecimal getBeforeChangeLaborMny() {
        return beforeChangeLaborMny;
    }

    public void setBeforeChangeLaborMny(BigDecimal beforeChangeLaborMny) {
        this.beforeChangeLaborMny = beforeChangeLaborMny;
    }
    public BigDecimal getLaborMny() {
        return laborMny;
    }

    public void setLaborMny(BigDecimal laborMny) {
        this.laborMny = laborMny;
    }
    public BigDecimal getBeforeChangeMaterialTaxMny() {
        return beforeChangeMaterialTaxMny;
    }

    public void setBeforeChangeMaterialTaxMny(BigDecimal beforeChangeMaterialTaxMny) {
        this.beforeChangeMaterialTaxMny = beforeChangeMaterialTaxMny;
    }
    public BigDecimal getMaterialTaxMny() {
        return materialTaxMny;
    }

    public void setMaterialTaxMny(BigDecimal materialTaxMny) {
        this.materialTaxMny = materialTaxMny;
    }
    public BigDecimal getBeforeChangeMaterialMny() {
        return beforeChangeMaterialMny;
    }

    public void setBeforeChangeMaterialMny(BigDecimal beforeChangeMaterialMny) {
        this.beforeChangeMaterialMny = beforeChangeMaterialMny;
    }
    public BigDecimal getMaterialMny() {
        return materialMny;
    }

    public void setMaterialMny(BigDecimal materialMny) {
        this.materialMny = materialMny;
    }
    public BigDecimal getBeforeChangeMajorTaxMny() {
        return beforeChangeMajorTaxMny;
    }

    public void setBeforeChangeMajorTaxMny(BigDecimal beforeChangeMajorTaxMny) {
        this.beforeChangeMajorTaxMny = beforeChangeMajorTaxMny;
    }
    public BigDecimal getMajorTaxMny() {
        return majorTaxMny;
    }

    public void setMajorTaxMny(BigDecimal majorTaxMny) {
        this.majorTaxMny = majorTaxMny;
    }
    public BigDecimal getBeforeChangeMajorMny() {
        return beforeChangeMajorMny;
    }

    public void setBeforeChangeMajorMny(BigDecimal beforeChangeMajorMny) {
        this.beforeChangeMajorMny = beforeChangeMajorMny;
    }
    public BigDecimal getMajorMny() {
        return majorMny;
    }

    public void setMajorMny(BigDecimal majorMny) {
        this.majorMny = majorMny;
    }
    public BigDecimal getBeforeChangeMechanicalTaxMny() {
        return beforeChangeMechanicalTaxMny;
    }

    public void setBeforeChangeMechanicalTaxMny(BigDecimal beforeChangeMechanicalTaxMny) {
        this.beforeChangeMechanicalTaxMny = beforeChangeMechanicalTaxMny;
    }
    public BigDecimal getMechanicalTaxMny() {
        return mechanicalTaxMny;
    }

    public void setMechanicalTaxMny(BigDecimal mechanicalTaxMny) {
        this.mechanicalTaxMny = mechanicalTaxMny;
    }
    public BigDecimal getBeforeChangeMechanicalMny() {
        return beforeChangeMechanicalMny;
    }

    public void setBeforeChangeMechanicalMny(BigDecimal beforeChangeMechanicalMny) {
        this.beforeChangeMechanicalMny = beforeChangeMechanicalMny;
    }
    public BigDecimal getMechanicalMny() {
        return mechanicalMny;
    }

    public void setMechanicalMny(BigDecimal mechanicalMny) {
        this.mechanicalMny = mechanicalMny;
    }
    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getCostTypeShow() {
        return costTypeShow;
    }

    public void setCostTypeShow(String costTypeShow) {
        this.costTypeShow = costTypeShow;
    }

    public List<BudgetProjectDetailChangeProEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<BudgetProjectDetailChangeProEntity> detailList) {
        this.detailList = detailList;
    }
}
