package com.ejianc.business.budget.bean;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.budget.bean.BudgetProjectDetailEntity;

/**
 * 项目预算
 *
 * @author generator
 */
@TableName("ejc_budget_project")
public class BudgetProjectEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "bill_code")
    private String billCode; // 单据编号
    @TableField(value = "org_id")
    private Long orgId; // 组织
    @TableField(value = "org_name")
    private String orgName; // 组织名称
    @TableField(value = "project_id")
    private Long projectId; // 项目
    @TableField(value = "project_name")
    private String projectName; // 项目名称
    @TableField(value = "unassociate")
    private Integer unassociate; // 未关联科目项
    @TableField(value = "budget_mny")
    private BigDecimal budgetMny; // 预算金额
    @TableField(value = "labor_mny")
    private BigDecimal laborMny; // 人工费
    @TableField(value = "material_mny")
    private BigDecimal materialMny; // 材料费
    @TableField(value = "mechanical_mny")
    private BigDecimal mechanicalMny; // 机械费
    @TableField(value = "other_mny")
    private BigDecimal otherMny; // 其他费
    @TableField(value = "change_status")
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    @TableField(value = "change_version")
    private Integer changeVersion; // 变更版本
    @TableField(value = "change_code")
    private String changeCode; // 变更单号
    @TableField(value = "change_id")
    private Long changeId; // 变更主键
    @TableField(value = "bill_state")
    private Integer billState; // 单据状态
    @TableField(value = "linked_flag")
    private Integer linkedFlag; // 是否关联科目
    @TableField(value = "base_budget_money")
    private BigDecimal baseBudgetMoney; // 初始版本金额
    @TableField(value = "before_change_budget_mny")
    private BigDecimal beforeChangeBudgetMny; // 变更前金额
    @TableField(value = "changing_budget_mny")
    private BigDecimal changingBudgetMny; // 变更中金额
    @TableField(value = "base_labor_mny")
    private BigDecimal baseLaborMny; // 初始版本人工费
    @TableField(value = "before_change_labor_mny")
    private BigDecimal beforeChangeLaborMny; // 变更前人工费
    @TableField(value = "changing_labor_mny")
    private BigDecimal changingLaborMny; // 变更中人工费
    @TableField(value = "base_material_mny")
    private BigDecimal baseMaterialMny; // 初始版本材料费
    @TableField(value = "before_change_material_mny")
    private BigDecimal beforeChangeMaterialMny; // 变更前材料费
    @TableField(value = "changing_material_mny")
    private BigDecimal changingMaterialMny; // 变更中材料费
    @TableField(value = "base_mechanical_mny")
    private BigDecimal baseMechanicalMny; // 初始版本机械费
    @TableField(value = "before_change_mechanical_mny")
    private BigDecimal beforeChangeMechanicalMny; // 变更前机械费
    @TableField(value = "changing_mechanical_mny")
    private BigDecimal changingMechanicalMny; // 变更中机械费
    @TableField(value = "base_other_mny")
    private BigDecimal baseOtherMny; // 初始版本其他费用
    @TableField(value = "before_change_other_mny")
    private BigDecimal beforeChangeOtherMny; // 变更前其他费用
    @TableField(value = "changing_other_mny")
    private BigDecimal changingOtherMny; // 变更中其他费用
    @TableField(value = "change_reason")
    private String changeReason; // 变更原因
    @TableField(value = "budget_type")
    private Integer budgetType; // 预算类型：0-中标预算1-施工图预算2-结算预算3-变更4-签证5-索赔6-其他
    @TableField(value = "target_id")
    private Long targetId; // 转换后目标成本ID
    @TableField(value = "employee_id")
    private Long employeeId; // 经办人
    @TableField(value = "employee_name")
    private String employeeName; // 经办人名称
    @TableField(value = "department_id")
    private Long departmentId; // 经办部门
    @TableField(value = "department_name")
    private String departmentName; // 经办部门名称
    @TableField(value = "total_mny")
    private BigDecimal totalMny; // 预算总金额
    @TableField(value = "base_total_mny")
    private BigDecimal baseTotalMny; // 初始版本预算总金额
    @TableField(value = "before_change_total_mny")
    private BigDecimal beforeChangeTotalMny; // 变更前预算总金额
    @TableField(value = "changing_total_mny")
    private BigDecimal changingTotalMny; // 变更中预算总金额

    @TableField(exist = false)
    @SubEntity(serviceName = "budgetProjectDetailService", pidName = "budgetId")
    private List<BudgetProjectDetailEntity> checkList = new ArrayList<>(); // 项目预算清单


    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    /**
     * 未关联科目项
     */
    public Integer getUnassociate() {
        return unassociate;
    }

    /**
     * 未关联科目项
     */
    public void setUnassociate(Integer unassociate) {
        this.unassociate = unassociate;
    }

    /**
     * 预算金额
     */
    public BigDecimal getBudgetMny() {
        return budgetMny;
    }

    /**
     * 预算金额
     */
    public void setBudgetMny(BigDecimal budgetMny) {
        this.budgetMny = budgetMny;
    }

    /**
     * 人工费
     */
    public BigDecimal getLaborMny() {
        return laborMny;
    }

    /**
     * 人工费
     */
    public void setLaborMny(BigDecimal laborMny) {
        this.laborMny = laborMny;
    }

    /**
     * 材料费
     */
    public BigDecimal getMaterialMny() {
        return materialMny;
    }

    /**
     * 材料费
     */
    public void setMaterialMny(BigDecimal materialMny) {
        this.materialMny = materialMny;
    }

    /**
     * 机械费
     */
    public BigDecimal getMechanicalMny() {
        return mechanicalMny;
    }

    /**
     * 机械费
     */
    public void setMechanicalMny(BigDecimal mechanicalMny) {
        this.mechanicalMny = mechanicalMny;
    }

    /**
     * 其他费
     */
    public BigDecimal getOtherMny() {
        return otherMny;
    }

    /**
     * 其他费
     */
    public void setOtherMny(BigDecimal otherMny) {
        this.otherMny = otherMny;
    }

    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    public Integer getChangeStatus() {
        return changeStatus;
    }

    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }

    /**
     * 变更版本
     */
    public Integer getChangeVersion() {
        return changeVersion;
    }

    /**
     * 变更版本
     */
    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    /**
     * 变更单号
     */
    public String getChangeCode() {
        return changeCode;
    }

    /**
     * 变更单号
     */
    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }

    /**
     * 变更主键
     */
    public Long getChangeId() {
        return changeId;
    }

    /**
     * 变更主键
     */
    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    /**
     * 是否关联科目
     */
    public Integer getLinkedFlag() {
        return linkedFlag;
    }

    /**
     * 是否关联科目
     */
    public void setLinkedFlag(Integer linkedFlag) {
        this.linkedFlag = linkedFlag;
    }

    /**
     * 初始版本金额
     */
    public BigDecimal getBaseBudgetMoney() {
        return baseBudgetMoney;
    }

    /**
     * 初始版本金额
     */
    public void setBaseBudgetMoney(BigDecimal baseBudgetMoney) {
        this.baseBudgetMoney = baseBudgetMoney;
    }

    /**
     * 变更前金额
     */
    public BigDecimal getBeforeChangeBudgetMny() {
        return beforeChangeBudgetMny;
    }

    /**
     * 变更前金额
     */
    public void setBeforeChangeBudgetMny(BigDecimal beforeChangeBudgetMny) {
        this.beforeChangeBudgetMny = beforeChangeBudgetMny;
    }

    /**
     * 变更中金额
     */
    public BigDecimal getChangingBudgetMny() {
        return changingBudgetMny;
    }

    /**
     * 变更中金额
     */
    public void setChangingBudgetMny(BigDecimal changingBudgetMny) {
        this.changingBudgetMny = changingBudgetMny;
    }

    /**
     * 初始版本人工费
     */
    public BigDecimal getBaseLaborMny() {
        return baseLaborMny;
    }

    /**
     * 初始版本人工费
     */
    public void setBaseLaborMny(BigDecimal baseLaborMny) {
        this.baseLaborMny = baseLaborMny;
    }

    /**
     * 变更前人工费
     */
    public BigDecimal getBeforeChangeLaborMny() {
        return beforeChangeLaborMny;
    }

    /**
     * 变更前人工费
     */
    public void setBeforeChangeLaborMny(BigDecimal beforeChangeLaborMny) {
        this.beforeChangeLaborMny = beforeChangeLaborMny;
    }

    /**
     * 变更中人工费
     */
    public BigDecimal getChangingLaborMny() {
        return changingLaborMny;
    }

    /**
     * 变更中人工费
     */
    public void setChangingLaborMny(BigDecimal changingLaborMny) {
        this.changingLaborMny = changingLaborMny;
    }

    /**
     * 初始版本材料费
     */
    public BigDecimal getBaseMaterialMny() {
        return baseMaterialMny;
    }

    /**
     * 初始版本材料费
     */
    public void setBaseMaterialMny(BigDecimal baseMaterialMny) {
        this.baseMaterialMny = baseMaterialMny;
    }

    /**
     * 变更前材料费
     */
    public BigDecimal getBeforeChangeMaterialMny() {
        return beforeChangeMaterialMny;
    }

    /**
     * 变更前材料费
     */
    public void setBeforeChangeMaterialMny(BigDecimal beforeChangeMaterialMny) {
        this.beforeChangeMaterialMny = beforeChangeMaterialMny;
    }

    /**
     * 变更中材料费
     */
    public BigDecimal getChangingMaterialMny() {
        return changingMaterialMny;
    }

    /**
     * 变更中材料费
     */
    public void setChangingMaterialMny(BigDecimal changingMaterialMny) {
        this.changingMaterialMny = changingMaterialMny;
    }

    /**
     * 初始版本机械费
     */
    public BigDecimal getBaseMechanicalMny() {
        return baseMechanicalMny;
    }

    /**
     * 初始版本机械费
     */
    public void setBaseMechanicalMny(BigDecimal baseMechanicalMny) {
        this.baseMechanicalMny = baseMechanicalMny;
    }

    /**
     * 变更前机械费
     */
    public BigDecimal getBeforeChangeMechanicalMny() {
        return beforeChangeMechanicalMny;
    }

    /**
     * 变更前机械费
     */
    public void setBeforeChangeMechanicalMny(BigDecimal beforeChangeMechanicalMny) {
        this.beforeChangeMechanicalMny = beforeChangeMechanicalMny;
    }

    /**
     * 变更中机械费
     */
    public BigDecimal getChangingMechanicalMny() {
        return changingMechanicalMny;
    }

    /**
     * 变更中机械费
     */
    public void setChangingMechanicalMny(BigDecimal changingMechanicalMny) {
        this.changingMechanicalMny = changingMechanicalMny;
    }

    /**
     * 初始版本其他费用
     */
    public BigDecimal getBaseOtherMny() {
        return baseOtherMny;
    }

    /**
     * 初始版本其他费用
     */
    public void setBaseOtherMny(BigDecimal baseOtherMny) {
        this.baseOtherMny = baseOtherMny;
    }

    /**
     * 变更前其他费用
     */
    public BigDecimal getBeforeChangeOtherMny() {
        return beforeChangeOtherMny;
    }

    /**
     * 变更前其他费用
     */
    public void setBeforeChangeOtherMny(BigDecimal beforeChangeOtherMny) {
        this.beforeChangeOtherMny = beforeChangeOtherMny;
    }

    /**
     * 变更中其他费用
     */
    public BigDecimal getChangingOtherMny() {
        return changingOtherMny;
    }

    /**
     * 变更中其他费用
     */
    public void setChangingOtherMny(BigDecimal changingOtherMny) {
        this.changingOtherMny = changingOtherMny;
    }

    public Integer getBudgetType() {
        return budgetType;
    }

    public void setBudgetType(Integer budgetType) {
        this.budgetType = budgetType;
    }

    public Long getTargetId() {
        return targetId;
    }

    public void setTargetId(Long targetId) {
        this.targetId = targetId;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public BigDecimal getTotalMny() {
        return totalMny;
    }

    public void setTotalMny(BigDecimal totalMny) {
        this.totalMny = totalMny;
    }

    public BigDecimal getBaseTotalMny() {
        return baseTotalMny;
    }

    public void setBaseTotalMny(BigDecimal baseTotalMny) {
        this.baseTotalMny = baseTotalMny;
    }

    public BigDecimal getBeforeChangeTotalMny() {
        return beforeChangeTotalMny;
    }

    public void setBeforeChangeTotalMny(BigDecimal beforeChangeTotalMny) {
        this.beforeChangeTotalMny = beforeChangeTotalMny;
    }

    public BigDecimal getChangingTotalMny() {
        return changingTotalMny;
    }

    public void setChangingTotalMny(BigDecimal changingTotalMny) {
        this.changingTotalMny = changingTotalMny;
    }

    public List<BudgetProjectDetailEntity> getCheckList() {
        return checkList;
    }

    public void setCheckList(List<BudgetProjectDetailEntity> checkList) {
        this.checkList = checkList;
    }
}
