package com.ejianc.business.budget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.BudgetSetDetailEntity;
import com.ejianc.business.budget.bean.BudgetSetFeaturesEntity;
import com.ejianc.business.budget.bean.BudgetSetQuotaEntity;
import com.ejianc.business.budget.service.IBudgetSetDetailService;
import com.ejianc.business.budget.vo.BudgetSetDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 清单定额关系明细
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("budgetSetDetail")
public class BudgetSetDetailController implements Serializable {
	private static final long serialVersionUID = 1L;

    @Autowired
    private IBudgetSetDetailService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BudgetSetDetailVO> saveOrUpdate(@RequestBody BudgetSetDetailVO saveOrUpdateVO) {
        BudgetSetDetailEntity entity = BeanMapper.map(saveOrUpdateVO, BudgetSetDetailEntity.class);
        if (CollectionUtils.isNotEmpty(entity.getQuotaList())) {
            List<String> nameList = entity.getQuotaList().stream().map(BudgetSetQuotaEntity::getQuotaName).collect(Collectors.toList());
            entity.setQuotaName(StringUtils.join(nameList, ","));
        }
        if (CollectionUtils.isNotEmpty(entity.getFeaturesList())) {
            List<String> nameList = entity.getFeaturesList().stream().map(BudgetSetFeaturesEntity::getFeaturesName).collect(Collectors.toList());
            entity.setFeatures(StringUtils.join(nameList, ","));
        }
        service.saveOrUpdate(entity, false);
        BudgetSetDetailVO vo = BeanMapper.map(entity, BudgetSetDetailVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetSetDetailVO> queryDetail(Long id) {
    	BudgetSetDetailEntity entity = service.selectById(id);
    	BudgetSetDetailVO vo = BeanMapper.map(entity, BudgetSetDetailVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetSetDetailVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (BudgetSetDetailVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(BudgetSetDetailVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BudgetSetDetailVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<BudgetSetDetailEntity> page = service.queryPage(param,false);
        IPage<BudgetSetDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BudgetSetDetailVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<BudgetSetDetailEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BudgetSetDetail-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refBudgetSetDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BudgetSetDetailVO>> refBudgetSetDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<BudgetSetDetailEntity> page = service.queryPage(param,false);
        IPage<BudgetSetDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BudgetSetDetailVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "BudgetSetDetail-import.xlsx", "明细模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return service.excelImport(request);
    }
}
