package com.ejianc.business.budget.service.impl;

import com.ejianc.business.budget.bean.*;
import com.ejianc.business.budget.mapper.BudgetProjectProMapper;
import com.ejianc.business.budget.service.IBudgetProjectDetailChangeProService;
import com.ejianc.business.budget.service.IBudgetProjectDetailProService;
import com.ejianc.business.budget.vo.*;
import com.ejianc.business.budget.vo.comparator.BudgetDetailChangeProComparatoeVo;
import com.ejianc.business.cost.utils.TreeNodeBUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.budget.mapper.BudgetProjectChangeProMapper;
import com.ejianc.business.budget.service.IBudgetProjectChangeProService;

import java.util.Collections;
import java.util.List;

/**
 * 项目预算变更单主实体
 * 
 * @author generator
 * 
 */
@Service("budgetProjectChangeProService")
public class BudgetProjectChangeProServiceImpl extends BaseServiceImpl<BudgetProjectChangeProMapper, BudgetProjectChangeProEntity> implements IBudgetProjectChangeProService{
    @Autowired
    private  BudgetProjectChangeProMapper changeMapper;
    @Autowired
    private BudgetProjectProMapper budgetMapper;
    @Autowired
    private IBudgetProjectDetailChangeProService detailChangeProService;
    @Autowired
    private IBudgetProjectDetailProService detailsService;
    @Override
    public BudgetProjectChangeProVO queryDetail(Long id) {
        BudgetProjectChangeProEntity entity = changeMapper.selectById(id);
        BudgetProjectChangeProVO changeVo = BeanMapper.map(entity, BudgetProjectChangeProVO.class);
        QueryParam param = new QueryParam();
        param.getParams().put("budget_change_id", new Parameter(QueryParam.EQ, changeVo.getId()));
        List<BudgetProjectDetailChangeProEntity> deils = detailChangeProService.queryList(param);
        List<BudgetProjectDetailChangeProVO> checkList = BeanMapper.mapList(deils,BudgetProjectDetailChangeProVO.class);
        if (checkList != null && checkList.size() > 0) {
            for (BudgetProjectDetailChangeProVO vo : checkList) {
                vo.setTid(vo.getId().toString());
                vo.setTpid(vo.getParentId() != null && vo.getParentId() > 0 ? vo.getParentId().toString() : "");
                vo.setRowState("edit");
            }
            changeVo.setDetailList(TreeNodeBUtil.buildTree(checkList));
        }
        return changeVo;
    }

    @Override
    public BudgetProjectChangeProVO queryDetailChange(Long id) {
        BudgetProjectProEntity entity = budgetMapper.selectById(id);
        if (entity != null) {
            BudgetProjectChangeProVO budgetProjectVO = BeanMapper.map(entity, BudgetProjectChangeProVO.class);
            budgetProjectVO.setBillState(null);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("budgetId", new Parameter(QueryParam.EQ, budgetProjectVO.getId()));
            List<BudgetProjectDetailProEntity> detailEntities = detailsService.queryList(queryParam, false);

            List<BudgetProjectDetailChangeProVO> resultMapList = BeanMapper.mapList(detailEntities, BudgetProjectDetailChangeProVO.class);
            if (CollectionUtils.isNotEmpty(resultMapList)) {
                for (BudgetProjectDetailChangeProVO cdEntity : resultMapList) {
                    cdEntity.setTid(cdEntity.getId().toString());
                    cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
                    cdEntity.setBudgetId(entity.getId());
                    cdEntity.setBudgetDetailId(cdEntity.getId());
                    cdEntity.setVersion(null);
                    cdEntity.setCreateUserCode(null);
                    cdEntity.setCreateTime(null);
                    cdEntity.setUpdateUserCode(null);
                    cdEntity.setUpdateTime(null);
                    //设置成本科目的id name code 和预算清单保持一致
                    cdEntity.setSubjectId(cdEntity.getId());
                    cdEntity.setSubjectName(cdEntity.getName());
                    cdEntity.setSubjectCode(cdEntity.getCode());
                    cdEntity.setRowState("edit");
                }
                //实现排序
                Collections.sort(resultMapList, new BudgetDetailChangeProComparatoeVo());
                budgetProjectVO.setDetailList(TreeNodeBUtil.buildTree(resultMapList));
            }
            budgetProjectVO.setBeforeChangeBudgetTaxMny(budgetProjectVO.getBudgetTaxMny());
            budgetProjectVO.setBeforeChangeBudgetMny(budgetProjectVO.getBudgetMny());
            budgetProjectVO.setBeforeChangeLaborMny(budgetProjectVO.getLaborMny());
            budgetProjectVO.setBeforeChangeLaborTaxMny(budgetProjectVO.getLaborTaxMny());
            budgetProjectVO.setBeforeChangeMajorMny(budgetProjectVO.getMajorMny());
            budgetProjectVO.setBeforeChangeMajorTaxMny(budgetProjectVO.getMajorTaxMny());
            budgetProjectVO.setBeforeChangeMaterialMny(budgetProjectVO.getMaterialMny());
            budgetProjectVO.setBeforeChangeMaterialTaxMny(budgetProjectVO.getMaterialTaxMny());
            budgetProjectVO.setBeforeChangeIndirectionMny(budgetProjectVO.getIndirectionMny());
            budgetProjectVO.setBeforeChangeIndirectionTaxMny(budgetProjectVO.getIndirectionTaxMny());
            budgetProjectVO.setBeforeChangeMechanicalTaxMny(budgetProjectVO.getMechanicalTaxMny());
            budgetProjectVO.setBeforeChangeMechanicalMny(budgetProjectVO.getMechanicalMny());
            budgetProjectVO.setBudgetId(entity.getId());
            budgetProjectVO.setCostTypeShow(budgetProjectVO.getCostTypeShow());
            budgetProjectVO.setId(null);
            budgetProjectVO.setBillState(null);
            budgetProjectVO.setCreateUserCode(null);
            budgetProjectVO.setCreateTime(null);
            budgetProjectVO.setUpdateUserCode(null);
            budgetProjectVO.setUpdateTime(null);
            return budgetProjectVO;
        }
        return null;
    }
}
