package com.ejianc.business.budget.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.budget.bean.BudgetProjectDetailEntity;
import com.ejianc.business.budget.bean.BudgetProjectDetailHistoryEntity;
import com.ejianc.business.budget.bean.BudgetProjectEntity;
import com.ejianc.business.budget.service.IBudgetProjectDetailHistoryService;
import com.ejianc.business.budget.service.IBudgetProjectService;
import com.ejianc.business.budget.vo.BudgetProjectChangeVO;
import com.ejianc.business.budget.vo.BudgetProjectDetailChangeVO;
import com.ejianc.business.budget.vo.BudgetProjectDetailHistoryVO;
import com.ejianc.business.budget.vo.BudgetProjectHistoryVO;
import com.ejianc.business.budget.vo.comparator.BudgetDetailHistoryComparatoeVo;
import com.ejianc.business.cost.utils.TreeNodeBUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.budget.mapper.BudgetProjectHistoryMapper;
import com.ejianc.business.budget.bean.BudgetProjectHistoryEntity;
import com.ejianc.business.budget.service.IBudgetProjectHistoryService;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 项目预算记录表
 *
 * @author generator
 *
 */
@Service("budgetProjectHistoryService")
public class BudgetProjectHistoryServiceImpl extends BaseServiceImpl<BudgetProjectHistoryMapper, BudgetProjectHistoryEntity> implements IBudgetProjectHistoryService{

    @Autowired
    private IBudgetProjectDetailHistoryService historyDetailService;
    @Autowired
    private IBudgetProjectService budgetService;

    @Override
    public BudgetProjectHistoryVO queryDetailByChangeId(Long id) {

        BudgetProjectHistoryEntity historyEntity = baseMapper.selectOne(new QueryWrapper<BudgetProjectHistoryEntity>().eq("change_id", id));
        if(historyEntity !=null){
            BudgetProjectHistoryVO historyVo = BeanMapper.map(historyEntity, BudgetProjectHistoryVO.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("budget_history_id", new Parameter(QueryParam.EQ, historyEntity.getId()));
            queryParam.getParams().put("change_type", new Parameter(QueryParam.NE, 5));
            //queryParam.getOrderMap().put("detailIndex", "asc");
            List<BudgetProjectDetailHistoryEntity> historyDetailEntities = historyDetailService.queryList(queryParam, false);

            if(historyDetailEntities != null && historyDetailEntities.size() > 0) {
                List<BudgetProjectDetailHistoryVO> detailVos = BeanMapper.mapList(historyDetailEntities, BudgetProjectDetailHistoryVO.class);
                //实现排序
                Collections.sort(detailVos,new BudgetDetailHistoryComparatoeVo());
                for(BudgetProjectDetailHistoryVO cdEntity:detailVos){
                    cdEntity.setTid(cdEntity.getId().toString());
                    cdEntity.setTpid(cdEntity.getParentId()!= null&&cdEntity.getParentId()>0?cdEntity.getParentId().toString():"");
                    //cdEntity.setRowState("edit");
                }
                historyVo.setCheckList(TreeNodeBUtil.buildTree(detailVos));
            }

            return historyVo;
        }
        return null;
    }

    @Override
    public BudgetProjectChangeVO queryChange(Long budgetId) {
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        BudgetProjectHistoryEntity changeEntity = baseMapper.selectOne(new QueryWrapper<BudgetProjectHistoryEntity>()
                .eq("budget_id", budgetId)
                .in("bill_state", billStatus).orderByDesc("change_version").last("limit 1"));
        if (null != changeEntity) {
            Map<Long, BudgetProjectDetailHistoryEntity> map = selectById(changeEntity.getId()).getCheckList().stream().collect(Collectors.toMap(BudgetProjectDetailHistoryEntity::getBudgetDetailId, Function.identity(), (key1, key2) -> key1));
            BudgetProjectEntity entity = budgetService.selectById(budgetId);
            BudgetProjectChangeVO changeVO = BeanMapper.map(entity, BudgetProjectChangeVO.class);
            changeVO.setBeforeChangeBudgetMny(changeEntity.getBudgetMny());
            for (BudgetProjectDetailChangeVO detailVO : changeVO.getCheckList()) {
                BudgetProjectDetailHistoryEntity projectDetailEntity = map.get(detailVO.getId());
                if (null != projectDetailEntity) {
                    detailVO.setBeforeChangeCode(projectDetailEntity.getCode());
                    detailVO.setBeforeChangeName(projectDetailEntity.getName());
                    detailVO.setBeforeChangeProjectFeature(projectDetailEntity.getProjectFeature());
                    detailVO.setBeforeChangeUnit(projectDetailEntity.getUnit());
                    detailVO.setBeforeChangeNum(projectDetailEntity.getNum());
                    detailVO.setBeforeChangePrice(projectDetailEntity.getPrice());
                    detailVO.setBeforeChangeMny(projectDetailEntity.getMny());
                    if(!detailVO.getBeforeChangeCode().equals(detailVO.getCode()) || !detailVO.getBeforeChangeName().equals(detailVO.getName())
                            || !nullToTrim(detailVO.getBeforeChangeProjectFeature()).equals(nullToTrim(detailVO.getProjectFeature())) || !detailVO.getBeforeChangeUnit().equals(detailVO.getUnit())
                            || !ComputeUtil.equals(detailVO.getBeforeChangeNum(), detailVO.getNum()) || !ComputeUtil.equals(detailVO.getBeforeChangePrice(), detailVO.getPrice())
                            || !ComputeUtil.equals(detailVO.getBeforeChangeMny(), detailVO.getMny())
                    ){
                        detailVO.setChangeFlag(true);
                    }else
                        detailVO.setChangeFlag(false);
                }else {
                    detailVO.setChangeFlag(true);
                }
            }
            changeVO.setCheckList(TreeNodeBUtil.buildTree(changeVO.getCheckList()));
            return changeVO;
        }
        return null;
    }

    private String nullToTrim(String source){
        if (null == source) {
            return "";
        }
        return source;
    }
}
