package com.ejianc.business.budget.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.budget.bean.BudgetProjectDetailProEntity;
import com.ejianc.business.budget.bean.BudgetProjectProEntity;
import com.ejianc.business.budget.service.IBudgetProjectDetailProService;
import com.ejianc.business.budget.service.IBudgetProjectProService;
import com.ejianc.business.cost.bean.SettingEntity;
import com.ejianc.business.cost.bean.SubjectEntity;
import com.ejianc.business.cost.service.ISettingService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service("budgetProjectPro")
public class BudgetProjectProBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBudgetProjectProService service;
    @Autowired
    private IBudgetProjectProService budgetProjectProService;

    @Autowired
    private ISettingService settingService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    //物资进成本方式
    private static final String materialInCostCode = "P-97949U38";
    //含税无税入成本
    private static final String TaxInCostCode = "P-BP0a7Z39";

    private static final String budgetPushCost = "P-340m7240";

    @Autowired
    private IBudgetProjectDetailProService detailProService;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        // 提交前校验，主要针对于项目预算书转换生成的目标成本（自由态）不完整，不能直接提交
        LambdaQueryWrapper<BudgetProjectDetailProEntity> lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(BudgetProjectDetailProEntity::getBudgetId, billId);
        lambdaQuery.eq(BudgetProjectDetailProEntity::getLeafFlag, 1);
        lambdaQuery.and(t -> t.isNull(BudgetProjectDetailProEntity::getNum).or().isNull(BudgetProjectDetailProEntity::getPrice));
        List<BudgetProjectDetailProEntity> list = detailProService.list(lambdaQuery);
        if (CollectionUtils.isNotEmpty(list)) {
            BudgetProjectDetailProEntity detailProEntity = list.get(0);
            return CommonResponse.error("成本清单【编码：" + detailProEntity.getCode() + "，名称：" + detailProEntity.getName() + "】的工程量和单价不能为空！");
        }
        return CommonResponse.success();
    }


    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }


    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }


    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        BudgetProjectProEntity entity = service.selectById(billId);
        QueryWrapper<SettingEntity> settingQueryWrapper = new QueryWrapper<>();
        settingQueryWrapper.eq("project_id", entity.getProjectId());
        List<SettingEntity> list = settingService.list(settingQueryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            for (SettingEntity settingEntity : list) {
                Integer pushFlag = settingEntity.getPushFlag();
                if (pushFlag == null || pushFlag == 0) {
                    return CommonResponse.error("该项目有自制的成本设置单据，请删除后再操作！");
                }
            }
        }
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse<ParamRegisterSetVO> budgetPushResponse = paramConfigApi.getByCode(budgetPushCost);
        if (budgetPushResponse.isSuccess()) {
            ParamRegisterSetVO data = budgetPushResponse.getData();
            if ("是".equals(data.getValueData())) {
                BudgetProjectProEntity entity = service.selectById(billId);
                QueryWrapper<SettingEntity> settingQueryWrapper = new QueryWrapper<>();
                settingQueryWrapper.eq("project_id", entity.getProjectId());
                settingQueryWrapper.eq("push_flag", 1);
                List<SettingEntity> settingList = settingService.list(settingQueryWrapper);
                if (CollectionUtils.isEmpty(settingList)) {
                    //没有执行插入
                    List<BudgetProjectDetailProEntity> detailList = entity.getDetailList();
                    SettingEntity settingEntity = new SettingEntity();
                    settingEntity.setId(billId);
                    settingEntity.setProjectId(entity.getProjectId());
                    settingEntity.setProjectName(entity.getProjectName());
                    settingEntity.setOrgId(entity.getOrgId());
                    settingEntity.setOrgName(entity.getOrgName());
                    settingEntity.setPeriodRule("1");
                    settingEntity.setBillState(3);
                    settingEntity.setPushFlag(1);
                    CommonResponse<ParamRegisterSetVO> materialInCostSet = paramConfigApi.getByCode(materialInCostCode);
                    if (materialInCostSet.isSuccess()) {
                        ParamRegisterSetVO materialInCostSetData = materialInCostSet.getData();
                        if (materialInCostSetData.getValueData().equals("1")) {
                            settingEntity.setMaterialCost("0");
                        } else if (materialInCostSetData.getValueData().equals("2")) {
                            settingEntity.setMaterialCost("1");
                        }
                    }
                    CommonResponse<ParamRegisterSetVO> taxInCostSet = paramConfigApi.getByCode(TaxInCostCode);
                    if (taxInCostSet.isSuccess()) {
                        ParamRegisterSetVO taxInCostData = taxInCostSet.getData();
                        if (taxInCostData.getValueData().equals("1")) {
                            settingEntity.setTaxFlag("1");
                        } else {
                            settingEntity.setTaxFlag("0");
                        }
                    }
                    ArrayList<SubjectEntity> subjectEntities = new ArrayList<>();
                    if (CollectionUtils.isNotEmpty(detailList)) {
                        for (BudgetProjectDetailProEntity detailProEntity : detailList) {
                            SubjectEntity subjectEntity = new SubjectEntity();
                            subjectEntity.setId(detailProEntity.getId());
                            subjectEntity.setCostType(detailProEntity.getCostType());
                            subjectEntity.setSubjectCode(detailProEntity.getCode());
                            subjectEntity.setSubjectName(detailProEntity.getSubjectName());
                            subjectEntity.setDetailIndex(detailProEntity.getDetailIndex());
                            subjectEntity.setParentId(detailProEntity.getParentId());
                            subjectEntity.setTid(detailProEntity.getId());
                            subjectEntity.setLeafFlag(detailProEntity.getLeafFlag() == 1 ? true : false);
                            subjectEntity.setStatus(true);
                            subjectEntities.add(subjectEntity);
                        }
                        settingEntity.setSubjectDetails(subjectEntities);
                    }
                    settingService.saveOrUpdate(settingEntity, false);
                }
            }
        }
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        BudgetProjectProEntity entity = budgetProjectProService.selectById(billId);
        if (entity.getChangeStatus() != 1) {
            return CommonResponse.error("单据已变更，无法弃审！");
        }
        CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
        if (res.isSuccess()) {//单据未被下游单据引用
            return CommonResponse.success();
        } else {
            return CommonResponse.error(res.getMsg());
        }
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        settingService.delById(billId);
        return CommonResponse.success();
    }

}
