package com.ejianc.business.budget.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.*;
import com.ejianc.business.budget.mapper.BudgetProjectDetailProMapper;
import com.ejianc.business.budget.mapper.BudgetProjectProMapper;
import com.ejianc.business.budget.service.*;
import com.ejianc.business.budget.vo.*;
import com.ejianc.business.budget.vo.comparator.BudgetDetailProComparatoeVo;
import com.ejianc.business.cost.bean.SubjectEntity;
import com.ejianc.business.cost.service.ISettingService;
import com.ejianc.business.cost.service.ISubjectService;
import com.ejianc.business.cost.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.fieldCompare.CompareDifferenceUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 项目预算主实体
 *
 * @author generator
 */
@Service("budgetProjectProService")
public class BudgetProjectProServiceImpl extends BaseServiceImpl<BudgetProjectProMapper, BudgetProjectProEntity> implements IBudgetProjectProService {
    @Autowired
    private BudgetProjectProMapper budgetProjectProMapper;
    @Autowired
    private IBudgetProjectDetailProService budgetProjectDetailProService;
    @Autowired
    private BudgetProjectDetailProMapper budgetProjectDetailProMapper;
    @Autowired
    private IBudgetProjectProService budgetProService;
    @Autowired
    private ISettingService settingService;
    @Autowired
    private ISubjectService subjectService;
    @Autowired
    private IQuotaDetailService quotaDetailService;//定额库
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "PROJECT_BUDGET_PRO_CHANGE_CODE";//此处需要根据实际修改
    @Autowired
    private SessionManager sessionManager;


    @Override
    public BudgetProjectProVO queryDetail(Long id) {
        BudgetProjectProEntity entity = budgetProjectProMapper.selectById(id);
        if (entity != null) {
            BudgetProjectProVO vo = BeanMapper.map(entity, BudgetProjectProVO.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("budget_id", new Parameter(QueryParam.EQ, vo.getId()));
            List<BudgetProjectDetailProEntity> detailProEntityList = budgetProjectDetailProService.queryList(queryParam, false);
            if (CollectionUtils.isNotEmpty(detailProEntityList)) {
                List<BudgetProjectDetailProVO> resultMapList = BeanMapper.mapList(detailProEntityList, BudgetProjectDetailProVO.class);
                for (BudgetProjectDetailProVO cdEntity : resultMapList) {
                    cdEntity.setTid(cdEntity.getId().toString());
                    cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
                    cdEntity.setRowState("edit");
                }
                //实现排序
                Collections.sort(resultMapList, new BudgetDetailProComparatoeVo());
                vo.setDetailList(TreeNodeBUtil.buildTree(resultMapList));
            }
            return vo;
        }
        return null;
    }

    @Override
    public List<BudgetProjectDetailReferenProVO> queryDetailList(Page<BudgetProjectDetailReferenProVO> page, QueryWrapper wrapper, Long projectId, String costType) {
        return budgetProjectProMapper.queryDetailList(page, wrapper, projectId, costType);
    }

    @Override
    public List<BudgetProjectDetailReferenProVO> queryOtherDetailList(Page<BudgetProjectDetailReferenProVO> page, QueryWrapper wrapper, Long projectId, String costType) {
        return budgetProjectProMapper.queryOtherDetailList(page, wrapper, projectId, costType);
    }


    /**
     * 获取预算量价
     *
     * @param paramControlVO 项目预算Pro参数控制VO
     * @return {@link BudgetProjectProQuantityAndMnyVO}
     */
    @Override
    public BudgetProjectProQuantityAndMnyVO fetchQuantityAndMny(BudgetProjectProParamControlVO paramControlVO) {
        if (paramControlVO.getProjectId() == null) {
            return null;
        }

        BudgetProjectProQuantityAndMnyVO quantityAndMnyVO = new BudgetProjectProQuantityAndMnyVO();

        // 1、根据项目id查询已生效的预算编制单据信息，获取表头各金额和总金额数据
        LambdaQueryWrapper<BudgetProjectProEntity> lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(BudgetProjectProEntity::getProjectId, paramControlVO.getProjectId());
        lambdaQuery.in(BudgetProjectProEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        BudgetProjectProEntity entity = super.getOne(lambdaQuery);
        if (entity == null) {
            return null;
        }

        // 预算总金额（含税）
        quantityAndMnyVO.setBudgetTaxMny(entity.getBudgetTaxMny());
        // 预算总金额(无税)
        quantityAndMnyVO.setBudgetMny(entity.getBudgetMny());
        // 间接费(含税)
        quantityAndMnyVO.setIndirectionTaxMny(entity.getIndirectionTaxMny());
        // 间接费（无税）
        quantityAndMnyVO.setIndirectionMny(entity.getIndirectionMny());
        // 人工费（含税）
        quantityAndMnyVO.setLaborTaxMny(entity.getLaborTaxMny());
        // 人工费（无税）
        quantityAndMnyVO.setLaborMny(entity.getLaborMny());
        // 材料费（含税）
        quantityAndMnyVO.setMaterialTaxMny(entity.getMaterialTaxMny());
        // 材料费（无税）
        quantityAndMnyVO.setMaterialMny(entity.getMaterialMny());
        // 专业费（含税）
        quantityAndMnyVO.setMajorTaxMny(entity.getMajorTaxMny());
        // 专业费（无税）
        quantityAndMnyVO.setMajorMny(entity.getMajorMny());
        // 机械费(含税 )
        quantityAndMnyVO.setMechanicalTaxMny(entity.getMechanicalTaxMny());
        // 机械费（无税）
        quantityAndMnyVO.setMechanicalMny(entity.getMechanicalMny());
        //零星材料金额
        quantityAndMnyVO.setSporadicMaterialMny(entity.getSporadicMaterialMny());
        // 2、根据预算编制id和费用类型以及档案ids（可以不传），按照清单维度和档案维度查询预算清单量价（累计工程量、累计无税金额、累计含税金额）累计值
        Map<Long, BudgetProjectDetailProVO> detailProMap;
        if ((paramControlVO.getCostType() == 2 || paramControlVO.getCostType() == 4) && CollectionUtils.isNotEmpty(paramControlVO.getIds())) {
            detailProMap = budgetProjectDetailProMapper.fetchDetailProMapByQuantityAndMny(entity.getId(), paramControlVO.getCostType(), paramControlVO.getIds());
        } else {
            detailProMap = budgetProjectDetailProMapper.fetchDetailProMap(entity.getId(), paramControlVO.getCostType());
        }
        quantityAndMnyVO.setDetailProMap(detailProMap);

        return quantityAndMnyVO;
    }

    @Override
    public List<BudgetProjectDetailProVO> querySubDetailList(Page<BudgetProjectDetailProVO> page, QueryWrapper wrapper, Long projectId, String costType) {
        return budgetProjectProMapper.querySubDetailList(page, wrapper, projectId, costType);
    }

    @Override
    public void pushCostSetting(Long budgetId) {
        ArrayList<SubjectEntity> subjectAndUpdateList = new ArrayList<>();
        Map<Long, SubjectEntity> subjectMap = new HashMap<>();
        BudgetProjectProEntity entity = budgetProService.selectById(budgetId);
        List<BudgetProjectDetailProEntity> detailList = entity.getDetailList();
        QueryWrapper<SubjectEntity> objectQueryWrapper = new QueryWrapper<>();
        objectQueryWrapper.eq("setting_id", budgetId);
        List<SubjectEntity> subjectEntities = subjectService.list(objectQueryWrapper);
        if (CollectionUtils.isNotEmpty(detailList)) {
            if (CollectionUtils.isNotEmpty(subjectEntities)) {
                subjectMap = subjectEntities.stream().collect(Collectors.toMap(k -> k.getId(), (k) -> k));
                for (BudgetProjectDetailProEntity projectDetailProEntity : detailList) {
                    SubjectEntity subjectEntity = null;
                    if (subjectMap.containsKey(projectDetailProEntity.getId())) {
                        //修改
                        subjectEntity = subjectMap.get(projectDetailProEntity.getId());
                        subjectEntity.setParentId(projectDetailProEntity.getParentId());
                        subjectEntity.setVersion(subjectEntity.getVersion());
                    } else {
                        //插入
                        subjectEntity = new SubjectEntity();
                        subjectEntity.setSettingId(budgetId);
                        subjectEntity.setId(projectDetailProEntity.getId());
                        subjectEntity.setVersion(null);
                    }
                    //移除没有移除完就删除
                    subjectMap.remove(subjectEntity.getId());

                    subjectEntity.setCostType(projectDetailProEntity.getCostType());
                    subjectEntity.setParentId(projectDetailProEntity.getParentId());
                    subjectEntity.setTid(projectDetailProEntity.getId());
                    subjectEntity.setSubjectName(projectDetailProEntity.getSubjectName());
                    subjectEntity.setSubjectCode(projectDetailProEntity.getSubjectCode());
                    subjectEntity.setLeafFlag(projectDetailProEntity.getLeafFlag() == 1 ? true : false);
                    subjectEntity.setDetailIndex(projectDetailProEntity.getDetailIndex());
                    subjectEntity.setStatus(true);
                    subjectAndUpdateList.add(subjectEntity);
                }
            } else {
                //清单没有执行全部插入
                for (BudgetProjectDetailProEntity detailProEntity : detailList) {
                    SubjectEntity subjectEntity = new SubjectEntity();
                    subjectEntity.setSettingId(budgetId);
                    subjectEntity.setCostType(detailProEntity.getCostType());
                    subjectEntity.setId(detailProEntity.getId());
                    subjectEntity.setParentId(detailProEntity.getParentId());
                    subjectEntity.setTid(detailProEntity.getId());
                    subjectEntity.setVersion(null);
                    subjectEntity.setSubjectName(detailProEntity.getSubjectName());
                    subjectEntity.setSubjectCode(detailProEntity.getSubjectCode());
                    subjectEntity.setLeafFlag(detailProEntity.getLeafFlag() == 1 ? true : false);
                    subjectEntity.setDetailIndex(detailProEntity.getDetailIndex());
                    subjectEntity.setStatus(true);
                    subjectAndUpdateList.add(subjectEntity);
                }
            }
            if (!subjectMap.isEmpty()) {
                List<Long> ids = subjectMap.keySet().stream().collect(Collectors.toList());
                subjectService.removeByIds(ids);
            }
            subjectService.saveOrUpdateBatch(subjectAndUpdateList, subjectAndUpdateList.size());
        } else {
            //预算清单子表为空 成本设置也该为空
            if (CollectionUtils.isNotEmpty(subjectEntities)) {
                List<Long> ids = subjectEntities.stream().map(SubjectEntity::getId).collect(Collectors.toList());
                subjectService.removeByIds(ids);
            }
        }
    }

    @Override
    public List<BudgetProjectDetailProVO> queryOnlySuject(Long projectId, Integer costType, Set<Long> subjectIds) {
        return budgetProjectProMapper.queryOnlySuject(projectId, costType, subjectIds);
    }

    /**
     * 根据项目id查询该项目的预算编制单中 物资档案的预算总量
     *
     * @param projectId
     * @return
     */
    @Override
    public Map<Long, BigDecimal> getBudgetProjectProQuantityByProjectId(Long projectId) {
        Map<Long, BigDecimal> map = new HashMap<>();
        if (projectId != null) {
            List<BudgetProjectProQuantityVO> list = budgetProjectDetailProMapper.getBudgetProjectProQuantityByProjectId(projectId);
            if (CollectionUtils.isNotEmpty(list)) {
                map = list.stream().collect(Collectors.toMap(BudgetProjectProQuantityVO::getMaterialId, BudgetProjectProQuantityVO::getNum, (key1, key2) -> key2));
            }
        }
        return map;

    }

    @Override
    public List<BudgetProjectDetailProVO> getBudgetProjectDetailProDataAndSum(Long projectId) {
        return budgetProjectProMapper.getBudgetProjectDetailProDataAndSum(projectId);
    }

    @Override
    public BudgetProjectVO convertToPro(BudgetProjectVO budgetProjectVO) {
       /* LambdaQueryWrapper<BudgetProjectProEntity> qry = new LambdaQueryWrapper<>();
        qry.eq(BudgetProjectProEntity::getProjectId, budgetProjectVO.getProjectId());
        BudgetProjectProEntity proEntity = getOne(qry, false);
        if (null != proEntity && !BillStateEnum.UNCOMMITED_STATE.getBillStateCode().equals(proEntity.getBillState()) && !BillStateEnum.COMMITED_STATE.getBillStateCode().equals(proEntity.getBillState()) && !BillStateEnum.PASSED_STATE.getBillStateCode().equals(proEntity.getBillState())) {
            throw new BusinessException("该项目存在非自由态或者非生效的目标成本单据，不允许转换!");
        }
        Integer successNum = 0;
        Integer totalNum = budgetProjectVO.getCheckList().size();
        List<BudgetProjectDetailVO> errResult = new ArrayList<>();
        LambdaQueryWrapper<BudgetS> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(BudgetInfoSetEntity::getTenantId, InvocationInfoProxy.getTenantid());
        List<BudgetInfoSetEntity> list = budgetInfoSetService.list(queryWrapper);// 关系表中的清单
        Map<String, BudgetInfoSetEntity> detailMap = list.stream().collect(Collectors.toMap(BudgetInfoSetEntity::getCode, Function.identity(), (key1, key2) -> key1));
        for (BudgetProjectDetailVO detailVO : budgetProjectVO.getCheckList()) {
            if (detailMap.containsKey(detailVO.getCode())) {
                successNum++;
                detailVO.setSuccessVO(BeanMapper.map(detailMap.get(detailVO.getCode()), BudgetInfoSetVO.class));
            } else {
                queryWrapper = new LambdaQueryWrapper<>();
                queryWrapper.eq(BudgetInfoSetEntity::getTenantId, InvocationInfoProxy.getTenantid());
                queryWrapper.like(BudgetInfoSetEntity::getName, detailVO.getName());
                List<BudgetInfoSetEntity> nameResult = budgetInfoSetService.list(queryWrapper);// 关系表中的清单
                if (CollectionUtils.isNotEmpty(nameResult)) {
                    Map<Long, BudgetInfoSetEntity> map = nameResult.stream().collect(Collectors.toMap(BudgetInfoSetEntity::getId, Function.identity(), (key1, key2) -> key1));
                    //存在相似清单，但是已替换
                    if (null != detailVO.getMatchId() && map.containsKey(detailVO.getMatchId())) {
                        detailVO.setErrState(3);
                        detailVO.setSuccessVO(BeanMapper.map(map.get(detailVO.getMatchId()), BudgetInfoSetVO.class));
                    } else {
                        //存在相似清单未替换
                        detailVO.setErrState(2);
                        detailVO.setErrList(BeanMapper.mapList(nameResult, BudgetInfoSetVO.class));
                        errResult.add(detailVO);
                    }
                } else {
                    //未匹配
                    detailVO.setErrState(1);
                    errResult.add(detailVO);
                }
            }
        }*/
        BudgetProjectVO result = new BudgetProjectVO();
        //有错误
        /*if (CollectionUtils.isNotEmpty(errResult)) {
            result.setTotalNum(totalNum);
            result.setSuccessNum(successNum);
            result.setErrList(errResult);
        } else {
            Integer index = null;
            if (null == proEntity) {
                index = 0;
            } else {
                QueryWrapper<BudgetProjectDetailProEntity> query = Wrappers.query();
                query.eq("budget_id", proEntity.getId());
                query.isNull("parent_id");
                query.select("MAX(detail_index) AS detail_index");
                BudgetProjectDetailProEntity detailProEntity = budgetProjectDetailProMapper.selectOne(query);
                index = null != detailProEntity && StringUtils.isNotBlank(detailProEntity.getDetailIndex()) ? Integer.parseInt((String) detailProEntity.getDetailIndex()) : 0;
            }
            List<BudgetProjectDetailProEntity> detailList = new ArrayList<>();
            for (BudgetProjectDetailVO detailVO : budgetProjectVO.getCheckList()) {
                BudgetInfoSetVO successVO = detailVO.getSuccessVO();
                LambdaQueryWrapper<BudgetInfoSetDetailEntity> query = new LambdaQueryWrapper<>();
                query.eq(BudgetInfoSetDetailEntity::getPid, successVO.getId());
                List<BudgetInfoSetDetailEntity> entities = budgetInfoSetDetailService.list(query);// 关系表中的定额
                if (CollectionUtils.isNotEmpty(entities)) {
                    Map<Long, BigDecimal> map = entities.stream().collect(Collectors.toMap(BudgetInfoSetDetailEntity::getQuotaId, BudgetInfoSetDetailEntity::getQuotaNum, (key1, key2) -> key1));
                    LambdaQueryWrapper<QuotaDetailEntity> wrapper = new LambdaQueryWrapper<>();
                    wrapper.in(QuotaDetailEntity::getId, new ArrayList<>(map.keySet()));
                    List<QuotaDetailEntity> storeList = quotaDetailService.list(wrapper);// 定额库
                    for (QuotaDetailEntity detailEntity : storeList) {
						index++;
                        detailList.addAll(convert(budgetProjectVO, successVO, detailVO.getNum(), map, detailEntity, index, proEntity));
                    }
                }
            }
            result.setTargetId(makeTarget(detailList, budgetProjectVO, proEntity));
        }*/
        return result;
    }

    @Autowired
    private IBudgetProjectHistoryProService historyProService;

    @Override
    public BudgetProjectProVO compareDetail(Long id) {
        BudgetProjectProEntity entity = this.selectById(id);
        BudgetProjectProVO vo = BeanMapper.map(entity, BudgetProjectProVO.class);
        List<BudgetProjectDetailProVO> detailList = vo.getDetailList();

        LambdaQueryWrapper<BudgetProjectHistoryProEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(BudgetProjectHistoryProEntity::getBudgetId, id);
        queryWrapper.orderByDesc(BudgetProjectHistoryProEntity::getCreateTime);
        List<BudgetProjectHistoryProEntity> list = historyProService.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            BudgetProjectHistoryProEntity budgetProjectHistoryProEntity = list.get(0);
            BudgetProjectHistoryProEntity budgetProjectHistory = historyProService.selectById(budgetProjectHistoryProEntity.getId());
            BudgetProjectHistoryProVO historyVO = BeanMapper.map(budgetProjectHistory, BudgetProjectHistoryProVO.class);

            CompareDifferenceUtil.compareObj(historyVO, vo);
            CompareDifferenceUtil.compareList(historyVO.getDetailList(), vo.getDetailList());

       /*     vo.setBeforeBudgetTaxMny(historyVO.getBudgetTaxMny());
            vo.setBeforeMaterialTaxMny(historyVO.getMaterialTaxMny());
            vo.setBeforeLaborTaxMny(historyVO.getLaborTaxMny());
            vo.setBeforeIndirectionTaxMny(historyVO.getIndirectionTaxMny());

            if (CollectionUtils.isNotEmpty(detailList)) {
                List<BudgetProjectDetailHistoryProVO> historyVODetailList = historyVO.getDetailList();
                Map<Long, BudgetProjectDetailHistoryProVO> map = new HashMap<>();
                if (CollectionUtils.isNotEmpty(historyVODetailList)) {
                    map = historyVODetailList.stream().collect(Collectors.toMap(BudgetProjectDetailHistoryProVO::getBudgetDetailId, Function.identity(), (oldValue, newValue) -> newValue));
                }
                for (BudgetProjectDetailProVO detailVO : detailList) {
                    Long detailVOId = detailVO.getId();
                    BudgetProjectDetailHistoryProVO detailHistoryVO = map.get(detailVOId);
                    if (detailHistoryVO == null) {
                       // detailVO.setChangeFlag(Boolean.TRUE);
                    } else {
                        String code = detailVO.getCode();
                        String historyVOCode = detailHistoryVO.getCode();
                        detailVO.setBeforeCode(historyVOCode);
                        detailVO.setBeforeName(detailHistoryVO.getName());

                        detailVO.setBeforeCostType(detailHistoryVO.getCostType());
                        detailVO.setBeforeSpec(detailHistoryVO.getSpec());
                        detailVO.setBeforeUnit(detailHistoryVO.getUnit());
                        detailVO.setBeforeNum(detailHistoryVO.getNum());
                        detailVO.setBeforeTaxPrice(detailHistoryVO.getTaxPrice());
                        detailVO.setBeforeMaterialTaxMnyCost(detailHistoryVO.getMaterialTaxMnyCost());

                        detailVO.setBeforeLaborTaxMnyCost(detailHistoryVO.getLaborTaxMnyCost());

                        detailVO.setBeforeIndirectionTaxMnyCost(detailHistoryVO.getIndirectionTaxMnyCost());
                        detailVO.setBeforeTaxMny(detailHistoryVO.getTaxMny());


                   *//*     if (isNotEqual(code, detailVO.getBeforeCode())) {
                            detailVO.setChangeFlag(Boolean.TRUE);
                            continue;
                        }
                        if (isNotEqual(detailVO.getName(), detailVO.getBeforeName())) {
                            detailVO.setChangeFlag(Boolean.TRUE);
                            continue;
                        }
                        if (!Optional.ofNullable(detailVO.getCostType()).orElse(0).equals(Optional.ofNullable(detailVO.getBeforeCostType()).orElse(0))) {
                            detailVO.setChangeFlag(Boolean.TRUE);
                            continue;
                        }

                        if (isNotEqual(detailVO.getSpec(), detailVO.getBeforeSpec())) {
                            detailVO.setChangeFlag(Boolean.TRUE);
                            continue;
                        }

                        if (isNotEqual(detailVO.getUnit(), detailVO.getBeforeUnit())) {
                            detailVO.setChangeFlag(Boolean.TRUE);
                            continue;
                        }

                        if (!ComputeUtil.equals(detailVO.getNum(), detailVO.getBeforeNum())) {
                            detailVO.setChangeFlag(Boolean.TRUE);
                            continue;
                        }

                        if (!ComputeUtil.equals(detailVO.getTaxPrice(), detailVO.getBeforeTaxPrice())) {
                            detailVO.setChangeFlag(Boolean.TRUE);
                            continue;
                        }

                        if (!ComputeUtil.equals(detailVO.getMaterialTaxMnyCost(), detailVO.getBeforeMaterialTaxMnyCost())) {
                            detailVO.setChangeFlag(Boolean.TRUE);
                            continue;
                        }

                        if (!ComputeUtil.equals(detailVO.getLaborTaxMnyCost(), detailVO.getBeforeLaborTaxMnyCost())) {
                            detailVO.setChangeFlag(Boolean.TRUE);
                            continue;
                        }

                        if (!ComputeUtil.equals(detailVO.getIndirectionTaxMnyCost(), detailVO.getBeforeIndirectionTaxMnyCost())) {
                            detailVO.setChangeFlag(Boolean.TRUE);
                            continue;
                        }

                        if (!ComputeUtil.equals(detailVO.getTaxMny(), detailVO.getBeforeTaxMny())) {
                            detailVO.setChangeFlag(Boolean.TRUE);
                        }*//*

                    }


                }
            }*/

        }

        if (CollectionUtils.isNotEmpty(detailList)) {
            Collections.sort(detailList, new BudgetDetailProComparatoeVo());
            vo.setDetailList(TreeNodeBUtil.buildTree(detailList));
        }
        return vo;
    }

    private boolean isNotEqual(String str1, String str2) {
        if (str1 != null) {
            return !str1.equals(str2);
        }
        if (str2 != null) {
            return !str2.equals(str1);
        }
        return false;
    }


    private Long makeTarget(List<BudgetProjectDetailProEntity> detailList, BudgetProjectVO budgetVO, BudgetProjectProEntity proEntity) {
        if (null == proEntity) {
            proEntity = new BudgetProjectProEntity();
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), budgetVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                proEntity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            proEntity.setProjectId(budgetVO.getProjectId());
            proEntity.setProjectName(budgetVO.getProjectName());
            proEntity.setOrgId(budgetVO.getOrgId());
            proEntity.setOrgName(budgetVO.getOrgName());
            UserContext userContext = sessionManager.getUserContext();
            proEntity.setEmployeeId(userContext.getEmployeeId());
            proEntity.setEmployeeName(userContext.getEmployeeName());
            proEntity.setChangeStatus(1);
            proEntity.setDetailList(detailList);
            fullMny(proEntity);
            saveOrUpdate(proEntity, false);
        } else {
            LambdaQueryWrapper<BudgetProjectDetailProEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(BudgetProjectDetailProEntity::getSourceId, budgetVO.getId());
            queryWrapper.eq(BudgetProjectDetailProEntity::getBudgetType, budgetVO.getBudgetType());
            budgetProjectDetailProService.remove(queryWrapper);
            if (CollectionUtils.isNotEmpty(detailList)) {
                budgetProjectDetailProService.saveBatch(detailList);
            }
            proEntity = selectById(proEntity.getId());
            fullMny(proEntity);
            saveOrUpdate(proEntity);
        }
        return proEntity.getId();
    }

    private void fullMny(BudgetProjectProEntity proEntity) {
        BigDecimal budgetTaxMny = BigDecimal.ZERO;
        BigDecimal laborTaxMny = BigDecimal.ZERO;
        BigDecimal materialTaxMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(proEntity.getDetailList())) {
            for (BudgetProjectDetailProEntity detailProEntity : proEntity.getDetailList()) {
                if (null == detailProEntity.getParentId()) {
                    budgetTaxMny = ComputeUtil.safeAdd(budgetTaxMny, detailProEntity.getTaxMny());
                    laborTaxMny = ComputeUtil.safeAdd(laborTaxMny, detailProEntity.getLaborTaxMnyCost());
                    materialTaxMny = ComputeUtil.safeAdd(materialTaxMny, detailProEntity.getMaterialTaxMnyCost());
                }
            }
        }
        proEntity.setBudgetTaxMny(budgetTaxMny);
        proEntity.setLaborTaxMny(laborTaxMny);
        proEntity.setMaterialTaxMny(materialTaxMny);
    }

    /**
     * @param budgetProjectVO
     * @param successVO       匹配成功的清单
     * @param num
     * @param map             清单对应的定额库Map<定额库主键，工程量>
     * @param proEntity
     * @return
     */
    /*  private List<BudgetProjectDetailProEntity> convert(BudgetProjectVO budgetProjectVO, BudgetInfoSetVO successVO, BigDecimal num, Map<Long, BigDecimal> map, QuotaDetailEntity detailEntity, Integer index, BudgetProjectProEntity proEntity) {
        Long targetId = null == proEntity ? null : proEntity.getId();
        List<BudgetProjectDetailProEntity> result = new ArrayList<>();
        //系数：关系表中定额工程量/清单工程量
        BigDecimal xs = ComputeUtil.safeDiv(map.get(detailEntity.getId()), successVO.getNum());
      if (null != detailEntity.getMaterialId()) {
            BudgetProjectDetailProEntity parent = new BudgetProjectDetailProEntity();
            parent.setDetailIndex(String.valueOf(index));
            parent.setBudgetId(targetId);
            parent.setSourceId(budgetProjectVO.getId());
            parent.setBudgetType(budgetProjectVO.getBudgetType());
            parent.setId(IdWorker.getId());
            parent.setCode(detailEntity.getQuotaDetailCode());
            parent.setName(detailEntity.getQuotaDetailProjectname());
            parent.setLeafFlag(0);
            parent.setSubjectId(parent.getId());
            parent.setSubjectCode(parent.getCode());
            parent.setSubjectName(parent.getName());

            BudgetProjectDetailProEntity material = new BudgetProjectDetailProEntity();
            material.setId(IdWorker.getId());
            material.setDetailIndex(index + ".1");
            material.setBudgetId(targetId);
            material.setSourceId(budgetProjectVO.getId());
            material.setBudgetType(budgetProjectVO.getBudgetType());
            material.setParentId(parent.getId());
            material.setCategoryId(detailEntity.getCategoryId());
            material.setCategoryName(detailEntity.getCategoryName());
            material.setMaterialId(detailEntity.getMaterialId());
            material.setMaterialName(detailEntity.getMaterialName());
            material.setCode(detailEntity.getMaterialCode());
            material.setName(detailEntity.getMaterialName());
            material.setCostType(2);
            material.setCostTypeName("材料费");
            material.setSpec(detailEntity.getSpec());
            material.setUnit(successVO.getUnit());
            material.setNum(ComputeUtil.safeMultiply(num, xs));
            material.setTaxPrice(detailEntity.getMaterialPrice());
            material.setMaterialTaxMnyCost(ComputeUtil.safeMultiply(material.getNum(), material.getTaxPrice()));
            material.setTaxMny(material.getMaterialTaxMnyCost());
            material.setLeafFlag(1);
            material.setSubjectId(material.getId());
            material.setSubjectCode(material.getCode());
            material.setSubjectName(material.getName());

            parent.setMaterialTaxMnyCost(ComputeUtil.safeAdd(parent.getMaterialTaxMnyCost(), material.getMaterialTaxMnyCost()));
            parent.setTaxMny(ComputeUtil.safeAdd(parent.getTaxMny(), material.getTaxMny()));

            BudgetProjectDetailProEntity labor = new BudgetProjectDetailProEntity();
            labor.setId(IdWorker.getId());
            labor.setDetailIndex(index + ".2");
            labor.setBudgetId(targetId);
            labor.setSourceId(budgetProjectVO.getId());
            labor.setBudgetType(budgetProjectVO.getBudgetType());
            labor.setParentId(parent.getId());
            labor.setCode(detailEntity.getQuotaDetailCode());
            labor.setName(detailEntity.getQuotaDetailProjectname());
            labor.setCostType(1);
            labor.setCostTypeName("人工费");
            labor.setSpec(detailEntity.getMemo());
            labor.setUnit(detailEntity.getUnit());
            labor.setNum(ComputeUtil.safeMultiply(num, xs));
            labor.setTaxPrice(detailEntity.getLaborPrice());
            labor.setLaborTaxMnyCost(ComputeUtil.safeMultiply(labor.getNum(), labor.getTaxPrice()));
            labor.setTaxMny(labor.getLaborTaxMnyCost());
            labor.setLeafFlag(1);
            labor.setSubjectId(labor.getId());
            labor.setSubjectCode(labor.getCode());
            labor.setSubjectName(labor.getName());

            parent.setLaborTaxMnyCost(ComputeUtil.safeAdd(parent.getLaborTaxMnyCost(), labor.getLaborTaxMnyCost()));
            parent.setTaxMny(ComputeUtil.safeAdd(parent.getTaxMny(), labor.getTaxMny()));

            result.add(parent);
            result.add(material);
            result.add(labor);
        } else {
            BudgetProjectDetailProEntity labor = new BudgetProjectDetailProEntity();
            labor.setId(IdWorker.getId());
            labor.setDetailIndex(String.valueOf(index));
            labor.setBudgetId(targetId);
            labor.setSourceId(budgetProjectVO.getId());
            labor.setBudgetType(budgetProjectVO.getBudgetType());
            labor.setCode(detailEntity.getQuotaDetailCode());
            labor.setName(detailEntity.getQuotaDetailProjectname());
            labor.setCostType(1);
            labor.setCostTypeName("人工费");
            labor.setSpec(detailEntity.getMemo());
            labor.setUnit(detailEntity.getUnit());
            labor.setNum(ComputeUtil.safeMultiply(num, xs));
            labor.setTaxPrice(detailEntity.getLaborPrice());
            labor.setLaborTaxMnyCost(ComputeUtil.safeMultiply(labor.getNum(), labor.getTaxPrice()));
            labor.setTaxMny(labor.getLaborTaxMnyCost());
            labor.setLeafFlag(0);
            labor.setSubjectId(labor.getId());
            labor.setSubjectCode(labor.getCode());
            labor.setSubjectName(labor.getName());
            result.add(labor);
        }
        return result;
    }*/

}
