package com.ejianc.business.budget.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.budget.bean.BudgetSetDetailEntity;
import com.ejianc.business.budget.bean.BudgetSetEntity;
import com.ejianc.business.budget.bean.BudgetSetFeaturesEntity;
import com.ejianc.business.budget.bean.BudgetSetQuotaEntity;
import com.ejianc.business.budget.mapper.BudgetSetMapper;
import com.ejianc.business.budget.service.IBudgetSetDetailService;
import com.ejianc.business.budget.service.IBudgetSetFeaturesService;
import com.ejianc.business.budget.service.IBudgetSetQuotaService;
import com.ejianc.business.budget.service.IBudgetSetService;
import com.ejianc.business.budget.vo.BudgetSetTypeVO;
import com.ejianc.business.budget.vo.BudgetSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 清单定额关系设置
 *
 * @author generator
 *
 */
@Service("budgetSetService")
public class BudgetSetServiceImpl extends BaseServiceImpl<BudgetSetMapper, BudgetSetEntity> implements IBudgetSetService{

    private static final String BILL_CODE = "BUDGET_SET";

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IBudgetSetDetailService budgetSetDetailService;
    @Autowired
    private IBudgetSetQuotaService budgetSetQuotaService;
    @Autowired
    private IBudgetSetFeaturesService budgetSetFeaturesService;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public BudgetSetVO saveOrUpdate(BudgetSetVO saveOrUpdateVO) {
        if (null == saveOrUpdateVO.getEnableState()) {
            saveOrUpdateVO.setEnableState(0);
        }
        LambdaQueryWrapper<BudgetSetEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(BudgetSetEntity::getTenantId, InvocationInfoProxy.getTenantid());
        queryWrapper.ne(null != saveOrUpdateVO.getId(), BudgetSetEntity::getId, saveOrUpdateVO.getId());
        queryWrapper.eq(BudgetSetEntity::getName, StringUtils.trim(saveOrUpdateVO.getName()));
        if (count(queryWrapper) > 0) {
            throw new BusinessException("名称重复,不允许保存!");
        }
        BudgetSetEntity entity = BeanMapper.map(saveOrUpdateVO, BudgetSetEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常,编码生成失败,请稍后再试");
            }
            UserContext userContext = sessionManager.getUserContext();
            entity.setOrgId(userContext.getOrgId());
            entity.setOrgName(userContext.getOrgName());
            entity.setOrgCode(userContext.getOrgCode());
        }
        saveOrUpdate(entity, false);
        BudgetSetVO vo = BeanMapper.map(entity, BudgetSetVO.class);
        return vo;
    }

    @Override
    public BudgetSetVO copySave(BudgetSetVO budgetSetVO) {
        Long mainId = IdWorker.getId();
        Map<Long, Long> typeIdMap = new HashMap<>();
        Map<Long, Long> detailIdMap = new HashMap<>();
        BudgetSetEntity setEntity = selectById(budgetSetVO.getCopyId());
        budgetSetVO = BeanMapper.map(setEntity, BudgetSetVO.class);
        budgetSetVO.setId(mainId);
        budgetSetVO.setName(budgetSetVO.getName() + "(副本)");
        budgetSetVO.setBillState(0);
        budgetSetVO.setEnableState(0);
        clearData(budgetSetVO);
        for (BudgetSetTypeVO typeVO : budgetSetVO.getTypeList()) {
            Long id = IdWorker.getId();
            typeIdMap.put(typeVO.getId(), id);
            typeVO.setId(id);
            typeVO.setSetId(mainId);
            clearData(typeVO);
        }
        saveOrUpdate(budgetSetVO);

        LambdaQueryWrapper<BudgetSetDetailEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(BudgetSetDetailEntity::getSetId, budgetSetVO.getCopyId());
        List<BudgetSetDetailEntity> detailEntities = budgetSetDetailService.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(detailEntities)) {
            for (BudgetSetDetailEntity detailEntity : detailEntities) {
                Long id = IdWorker.getId();
                detailIdMap.put(detailEntity.getId(), id);
                detailEntity.setId(id);
                detailEntity.setSetTypeId(typeIdMap.get(detailEntity.getSetTypeId()));
                detailEntity.setSetId(mainId);
                clearData(detailEntity);
            }
            budgetSetDetailService.saveBatch(detailEntities);
        }

        LambdaQueryWrapper<BudgetSetQuotaEntity> query = new LambdaQueryWrapper<>();
        query.eq(BudgetSetQuotaEntity::getSetId, budgetSetVO.getCopyId());
        List<BudgetSetQuotaEntity> matEntities = budgetSetQuotaService.list(query);
        if (CollectionUtils.isNotEmpty(matEntities)) {
            for (BudgetSetQuotaEntity matEntity : matEntities) {
                Long id = IdWorker.getId();
                matEntity.setId(id);
                matEntity.setSetTypeId(typeIdMap.get(matEntity.getSetTypeId()));
                matEntity.setSetDetailId(detailIdMap.get(matEntity.getSetDetailId()));
                matEntity.setQuotaId(mainId);
                clearData(matEntity);
            }
            budgetSetQuotaService.saveBatch(matEntities);
        }

        LambdaQueryWrapper<BudgetSetFeaturesEntity> qry = new LambdaQueryWrapper<>();
        qry.eq(BudgetSetFeaturesEntity::getSetId, budgetSetVO.getCopyId());
        List<BudgetSetFeaturesEntity> featEntities = budgetSetFeaturesService.list(qry);
        if (CollectionUtils.isNotEmpty(featEntities)) {
            for (BudgetSetFeaturesEntity featuresEntity : featEntities) {
                Long id = IdWorker.getId();
                featuresEntity.setId(id);
                featuresEntity.setSetTypeId(typeIdMap.get(featuresEntity.getSetTypeId()));
                featuresEntity.setSetDetailId(detailIdMap.get(featuresEntity.getSetDetailId()));
                featuresEntity.setSetId(mainId);
                clearData(featuresEntity);
            }
            budgetSetFeaturesService.saveBatch(featEntities);
        }
        return BeanMapper.map(selectById(mainId), BudgetSetVO.class);
    }

    private void clearData(BaseVO baseVO){
        baseVO.setCreateTime(null);
        baseVO.setCreateUserCode(null);
        baseVO.setUpdateTime(null);
        baseVO.setUpdateUserCode(null);
    }
    private void clearData(BaseEntity baseEntity){
        baseEntity.setCreateTime(null);
        baseEntity.setCreateUserCode(null);
        baseEntity.setUpdateTime(null);
        baseEntity.setUpdateUserCode(null);
    }
}
