package com.ejianc.business.budget.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.budget.bean.QuotaDetailEntity;
import com.ejianc.business.budget.bean.QuotaEntity;
import com.ejianc.business.budget.bean.QuotaMatEntity;
import com.ejianc.business.budget.mapper.QuotaMapper;
import com.ejianc.business.budget.service.IQuotaDetailService;
import com.ejianc.business.budget.service.IQuotaMatService;
import com.ejianc.business.budget.service.IQuotaService;
import com.ejianc.business.budget.vo.QuotaTypeVO;
import com.ejianc.business.budget.vo.QuotaVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 定额库
 *
 * @author generator
 */
@Service("quotaService")
public class QuotaServiceImpl extends BaseServiceImpl<QuotaMapper, QuotaEntity> implements IQuotaService {

    private static final String BILL_CODE = "BUDGET_QUOTA";

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IQuotaDetailService quotaDetailService;
    @Autowired
    private IQuotaMatService quotaMatService;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public QuotaVO saveOrUpdate(QuotaVO saveOrUpdateVO) {
        if (null == saveOrUpdateVO.getEnableState()) {
            saveOrUpdateVO.setEnableState(0);
        }
        LambdaQueryWrapper<QuotaEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(QuotaEntity::getTenantId, InvocationInfoProxy.getTenantid());
        queryWrapper.ne(null != saveOrUpdateVO.getId(), QuotaEntity::getId, saveOrUpdateVO.getId());
        queryWrapper.eq(QuotaEntity::getName, StringUtils.trim(saveOrUpdateVO.getName()));
        if (count(queryWrapper) > 0) {
            throw new BusinessException("名称重复,不允许保存!");
        }
        QuotaEntity entity = BeanMapper.map(saveOrUpdateVO, QuotaEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常,编码生成失败,请稍后再试");
            }
            UserContext userContext = sessionManager.getUserContext();
            entity.setOrgId(userContext.getOrgId());
            entity.setOrgName(userContext.getOrgName());
            entity.setOrgCode(userContext.getOrgCode());
        }
        saveOrUpdate(entity, false);
        QuotaVO vo = BeanMapper.map(entity, QuotaVO.class);
        return vo;
    }

    @Override
    public QuotaVO copySave(QuotaVO quotaVO) {
        Long mainId = IdWorker.getId();
        Map<Long, Long> typeIdMap = new HashMap<>();
        Map<Long, Long> detailIdMap = new HashMap<>();
        QuotaEntity quotaEntity = selectById(quotaVO.getCopyId());
        quotaVO = BeanMapper.map(quotaEntity, QuotaVO.class);
        quotaVO.setId(mainId);
        quotaVO.setName(quotaVO.getName() + "(副本)");
        quotaVO.setBillState(0);
        quotaVO.setEnableState(0);
        clearData(quotaVO);
        for (QuotaTypeVO typeVO : quotaVO.getTypeList()) {
            Long id = IdWorker.getId();
            typeIdMap.put(typeVO.getId(), id);
            typeVO.setId(id);
            typeVO.setQuotaId(mainId);
            clearData(typeVO);
        }
        saveOrUpdate(quotaVO);

        LambdaQueryWrapper<QuotaDetailEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(QuotaDetailEntity::getQuotaId, quotaVO.getCopyId());
        List<QuotaDetailEntity> detailEntities = quotaDetailService.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(detailEntities)) {
            for (QuotaDetailEntity detailEntity : detailEntities) {
                Long id = IdWorker.getId();
                detailIdMap.put(detailEntity.getId(), id);
                detailEntity.setId(id);
                detailEntity.setQuotaTypeId(typeIdMap.get(detailEntity.getQuotaTypeId()));
                detailEntity.setQuotaId(mainId);
                clearData(detailEntity);
            }
            quotaDetailService.saveBatch(detailEntities);
        }

        LambdaQueryWrapper<QuotaMatEntity> query = new LambdaQueryWrapper<>();
        query.eq(QuotaMatEntity::getQuotaId, quotaVO.getCopyId());
        List<QuotaMatEntity> matEntities = quotaMatService.list(query);
        if (CollectionUtils.isNotEmpty(matEntities)) {
            for (QuotaMatEntity matEntity : matEntities) {
                Long id = IdWorker.getId();
                matEntity.setId(id);
                matEntity.setQuotaTypeId(typeIdMap.get(matEntity.getQuotaTypeId()));
                matEntity.setQuotaDetailId(detailIdMap.get(matEntity.getQuotaDetailId()));
                matEntity.setQuotaId(mainId);
                clearData(matEntity);
            }
            quotaMatService.saveBatch(matEntities);
        }
        return BeanMapper.map(selectById(mainId), QuotaVO.class);
    }

    private void clearData(BaseVO baseVO){
        baseVO.setCreateTime(null);
        baseVO.setCreateUserCode(null);
        baseVO.setUpdateTime(null);
        baseVO.setUpdateUserCode(null);
    }
    private void clearData(BaseEntity baseEntity){
        baseEntity.setCreateTime(null);
        baseEntity.setCreateUserCode(null);
        baseEntity.setUpdateTime(null);
        baseEntity.setUpdateUserCode(null);
    }
}
