package com.ejianc.business.cost.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.cost.bean.CostProjectFinishDebtEntity;
import com.ejianc.business.cost.bean.CostProjectFinishSupplierEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 项目完工总结
 * 
 * @author generator
 * 
 */
 @TableName("ejc_cost_project_finish")
public class CostProjectFinishEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织主键
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bid_mny")
    private BigDecimal bidMny; // 中标金额
    @TableField(value="settle_mny")
    private BigDecimal settleMny; // 结算金额
    @TableField(value="already_receive_mny")
    private BigDecimal alreadyReceiveMny; // 已回款金额
    @TableField(value="will_receive_mny")
    private BigDecimal willReceiveMny; // 预计回款金额
    @TableField(value="will_profit_mny")
    private BigDecimal willProfitMny; // 预计利润金额
    @TableField(value="real_profit_mny")
    private BigDecimal realProfitMny; // 实际利润金额
    @TableField(value="deviation")
    private BigDecimal deviation; // 偏差
    @TableField(value="responsible_name")
    private String responsibleName; // 负责人
    @TableField(value="delay_day")
    private String delayDay; // 延期天数
    @TableField(value="inspect_day")
    private String inspectDay; // 巡视天数
    @TableField(value="expatriate_name")
    private String expatriateName; // 外派人员
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    @TableField(value="bill_date")
    private Date billDate; // 填报日期
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="department_id")
    private Long departmentId; // 经办人部门
    @TableField(value="department_name")
    private String departmentName; // 经办人部门
    @TableField(value="memo")
    private String memo; // 总结及建议(项目部)
    @TableField(value="remark")
    private String remark; // 总结及建议(成控部)
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="costProjectFinishDebtService",pidName = "projectFinishId")
    private List<CostProjectFinishDebtEntity> costProjectFinishDebtList = new ArrayList<>(); // 项目完工总结-项目外债
    @TableField(exist=false)
    @SubEntity(serviceName="costProjectFinishSupplierService",pidName = "projectFinishId")
    private List<CostProjectFinishSupplierEntity> costProjectFinishSupplierList = new ArrayList<>(); // 项目完工总结-推荐入库供应商
    

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public BigDecimal getBidMny() {
        return bidMny;
    }

    public void setBidMny(BigDecimal bidMny) {
        this.bidMny = bidMny;
    }
    public BigDecimal getSettleMny() {
        return settleMny;
    }

    public void setSettleMny(BigDecimal settleMny) {
        this.settleMny = settleMny;
    }
    public BigDecimal getAlreadyReceiveMny() {
        return alreadyReceiveMny;
    }

    public void setAlreadyReceiveMny(BigDecimal alreadyReceiveMny) {
        this.alreadyReceiveMny = alreadyReceiveMny;
    }
    public BigDecimal getWillReceiveMny() {
        return willReceiveMny;
    }

    public void setWillReceiveMny(BigDecimal willReceiveMny) {
        this.willReceiveMny = willReceiveMny;
    }
    public BigDecimal getWillProfitMny() {
        return willProfitMny;
    }

    public void setWillProfitMny(BigDecimal willProfitMny) {
        this.willProfitMny = willProfitMny;
    }
    public BigDecimal getRealProfitMny() {
        return realProfitMny;
    }

    public void setRealProfitMny(BigDecimal realProfitMny) {
        this.realProfitMny = realProfitMny;
    }
    public BigDecimal getDeviation() {
        return deviation;
    }

    public void setDeviation(BigDecimal deviation) {
        this.deviation = deviation;
    }
    public String getResponsibleName() {
        return responsibleName;
    }

    public void setResponsibleName(String responsibleName) {
        this.responsibleName = responsibleName;
    }
    public String getDelayDay() {
        return delayDay;
    }

    public void setDelayDay(String delayDay) {
        this.delayDay = delayDay;
    }
    public String getInspectDay() {
        return inspectDay;
    }

    public void setInspectDay(String inspectDay) {
        this.inspectDay = inspectDay;
    }
    public String getExpatriateName() {
        return expatriateName;
    }

    public void setExpatriateName(String expatriateName) {
        this.expatriateName = expatriateName;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    

    public List<CostProjectFinishDebtEntity> getCostProjectFinishDebtList() {
        return costProjectFinishDebtList;
    }

    public void setCostProjectFinishDebtList(List<CostProjectFinishDebtEntity> costProjectFinishDebtList) {
        this.costProjectFinishDebtList = costProjectFinishDebtList;
    }

    public List<CostProjectFinishSupplierEntity> getCostProjectFinishSupplierList() {
        return costProjectFinishSupplierList;
    }

    public void setCostProjectFinishSupplierList(List<CostProjectFinishSupplierEntity> costProjectFinishSupplierList) {
        this.costProjectFinishSupplierList = costProjectFinishSupplierList;
    }
}
