package com.ejianc.business.cost.bean;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 指导价
 * 
 * @author generator
 * 
 */
 @TableName("ejc_cost_guide_price")
public class GuidePriceEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="title")
    private String title; // 主题
    @TableField(value="org_id")
    private Long orgId; // 发布单位
    @TableField(value="org_name")
    private String orgName; // 发布单位名称
    @TableField(value="org_code")
    private String orgCode; // 编码



    @TableField(value="release_date")
    private Date releaseDate; // 发布日期
    @TableField(value="release_user_id")
    private Long releaseUserId; // 发布人
    @TableField(value="release_user_name")
    private String releaseUserName; // 发布人名称
    @TableField(value="status")
    private Integer status; // 状态：0、关闭； 1、启动
    @TableField(value="memo")
    private String memo; // 描述
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="guidePriceDetailService",pidName = "reviewId")
    private List<GuidePriceDetailEntity> detailList = new ArrayList<>(); // 指导价-价格明细

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
    public Date getReleaseDate() {
        return releaseDate;
    }

    public void setReleaseDate(Date releaseDate) {
        this.releaseDate = releaseDate;
    }
    public Long getReleaseUserId() {
        return releaseUserId;
    }

    public void setReleaseUserId(Long releaseUserId) {
        this.releaseUserId = releaseUserId;
    }
    public String getReleaseUserName() {
        return releaseUserName;
    }

    public void setReleaseUserName(String releaseUserName) {
        this.releaseUserName = releaseUserName;
    }
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    

    public List<GuidePriceDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<GuidePriceDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
