package com.ejianc.business.cost.controller;

import java.io.Serializable;

import com.ejianc.business.cost.bean.GuidePriceDetailEntity;
import com.ejianc.business.cost.service.IGuidePriceDetailService;
import com.ejianc.business.cost.vo.GuidePriceDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IBrandApi;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.BrandVO;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.*;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.cost.bean.GuidePriceEntity;
import com.ejianc.business.cost.service.IGuidePriceService;
import com.ejianc.business.cost.vo.GuidePriceVO;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 指导价
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("guidePrice")
public class GuidePriceController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IMaterialApi materialApi;
    @Autowired
    private IBrandApi brandApi;

    private static final String BILL_CODE = "ZDJ-CODE";//此处需要根据实际修改

    @Autowired
    private IGuidePriceService service;
    @Autowired
    private IGuidePriceDetailService detailService;
    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<GuidePriceVO> saveOrUpdate(@RequestBody GuidePriceVO saveOrUpdateVO) {
        return service.saveOrUpdate(saveOrUpdateVO);
    }
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<GuidePriceVO> queryDetail(Long id) {
    	GuidePriceEntity entity = service.selectById(id);
    	GuidePriceVO vo = BeanMapper.map(entity, GuidePriceVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<GuidePriceVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (GuidePriceVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(GuidePriceVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<GuidePriceVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例
         * 单据编号、主题、发布单位、发布人、描述
         * */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("title");
        fuzzyFields.add("unitName");
        fuzzyFields.add("releaseUserName");
        fuzzyFields.add("memo");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<GuidePriceEntity> page = service.queryPage(param,false);
        IPage<GuidePriceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<GuidePriceVO> guidePriceVOS = BeanMapper.mapList(page.getRecords(), GuidePriceVO.class);
        guidePriceVOS.stream().forEach(e->{
            e.setStatusStr(e.getStatus()==1?"启用":"关闭");
        });
        pageData.setRecords(guidePriceVOS);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<GuidePriceEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("GuidePrice-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refGuidePriceData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<GuidePriceVO>> refGuidePriceData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }
        IPage<GuidePriceEntity> page = service.queryPage(param,false);
        IPage<GuidePriceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), GuidePriceVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @RequestMapping(value = "/refGuidePriceDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<GuidePriceDetailVO>> refGuidePriceDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                             String condition,
                                                                             String searchObject,
                                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.containsKey("reviewId")){
                param.getParams().put("reviewId", new Parameter(QueryParam.EQ, _con.get("reviewId")));

            }
        }
        IPage<GuidePriceDetailEntity> page = detailService.queryPage(param,false);
        IPage<GuidePriceDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), GuidePriceDetailVO.class));
        return CommonResponse.success("查询参照数据成功！",pageData);
    }


    @RequestMapping(value = "/queryGuidePriceDetailData", method = RequestMethod.POST)
    @ResponseBody
    public  CommonResponse<List<GuidePriceDetailVO>> queryGuidePriceDetailData(@RequestBody List<GuidePriceDetailVO> detailVOList){
        return detailService.queryGuidePriceDetailData(detailVOList);
    }


    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "GuidePriceImport.xlsx", "价格明细导入模板");
    }

    @PostMapping(value = "/excelImport")
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request ) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }
        List<GuidePriceDetailVO> successList = new ArrayList<>();
        List<GuidePriceDetailVO> errorList = new ArrayList<>();
        List<List<String>> result = ExcelReader.readExcel(mf);
        if(result != null && result.size() > 0) {
            if(result.size() > 10000) {
                return CommonResponse.error("分类数据超过10000条，请分批上传！");
            }
            GuidePriceDetailVO vo = null;
//            Map<String,String> brandMap = new HashMap<>();

            for(int i = 0;i < result.size(); i++) {
                List<String> datas = result.get(i);
                vo = new GuidePriceDetailVO();
                vo.setId(IdWorker.getId());

                if(StringUtils.isBlank(datas.get(0))){
                    vo.setErrorMsg("物料分类编码不能为空！");
                    errorList.add(vo);
                    continue;
                }

                String materialCategoryCode = datas.get(0);
                //根据物料分类编码查询物料分类
                CommonResponse<MaterialCategoryVO> categoryResponse = materialApi.queryCategoryByCode(materialCategoryCode);
                if (!categoryResponse.isSuccess()){
                    vo.setErrorMsg("物料分类编码查询物料分类失败！");
                    errorList.add(vo);
                    continue;
                }
                if (null==categoryResponse.getData()){
                    vo.setErrorMsg("物料分类编码查询物料分类为空！");
                    errorList.add(vo);
                    continue;
                }
                MaterialCategoryVO materialCategoryVO = categoryResponse.getData();
                vo.setMaterialCategoryId(materialCategoryVO.getId());
                vo.setMaterialCategoryCode(materialCategoryCode);
                vo.setMaterialCategoryName(materialCategoryVO.getName());

                //材料编码
                if(StringUtils.isBlank(datas.get(1))){
                    vo.setErrorMsg("材料编码不能为空！");
                    errorList.add(vo);
                    continue;
                }
                String materialCode = datas.get(1);
                vo.setMaterialCode(materialCode);
                //材料名称
                if(StringUtils.isBlank(datas.get(2))){
                    vo.setErrorMsg("材料名称不能为空！");
                    errorList.add(vo);
                    continue;
                }
                String materialName = datas.get(2);
                vo.setMaterialName(materialName);
                //规格型号
                if(StringUtils.isBlank(datas.get(3))){
                    vo.setErrorMsg("材料名称不能为空！");
                    errorList.add(vo);
                    continue;
                }
                String spec = datas.get(3);
                vo.setSpec(spec);
                //计量单位
                if(StringUtils.isBlank(datas.get(4))){
                    vo.setErrorMsg("材料名称不能为空！");
                    errorList.add(vo);
                    continue;
                }
                String unit = datas.get(4);
                vo.setUnit(unit);
                //匹配物料
                MaterialVO materialVO = new MaterialVO();
                materialVO.setName(materialName);
                materialVO.setCode(materialCode);
                materialVO.setSpec(spec);
                materialVO.setUnitName(unit);
                materialVO.setCategoryId(materialCategoryVO.getId());

                CommonResponse<MaterialVO> materialResponse = materialApi.queryExitFlag(materialVO);
                if (!materialResponse.isSuccess()){
                    //匹配物料失败
                    vo.setErrorMsg("匹配查询物料失败！");
                    errorList.add(vo);
                    continue;
                }

                if (null==materialResponse.getData()){
                    vo.setErrorMsg("匹配查询物料为空！");
                    errorList.add(vo);
                    continue;
                }
                MaterialVO material = materialResponse.getData();
                vo.setMaterialId(material.getId());
                //品牌
                if(StringUtils.isBlank(datas.get(5))){
                    vo.setErrorMsg("品牌名称不能为空！");
                    errorList.add(vo);
                    continue;
                }
                String brandName = datas.get(5);
//                if (brandMap.containsKey(material.getId()+brandName)){
//                    vo.setErrorMsg("当前物料下已存在当前品牌的指导价！");
//                    errorList.add(vo);
//                    continue;
//
//                }else {
//                    brandMap.put(material.getId()+brandName,null);
//                }
                CommonResponse<BrandVO> brandVOCommonResponse = brandApi.queryBrandByName(brandName);
                if (!brandVOCommonResponse.isSuccess()){
                    //匹配物料失败
                    vo.setErrorMsg("匹配查询品牌失败！");
                    errorList.add(vo);
                    continue;
                }
                if (null==brandVOCommonResponse.getData()){
                    vo.setErrorMsg("匹配查询品牌为空！");
                    errorList.add(vo);
                    continue;
                }
                vo.setBrandName(brandName);
                vo.setBrandId(brandVOCommonResponse.getData().getId().toString());
                if(StringUtils.isBlank(datas.get(6))){
                    vo.setErrorMsg("单价不能为空！");
                    errorList.add(vo);
                    continue;
                }
                String price = datas.get(6);
                try {
                    vo.setPrice(new BigDecimal(price));
                } catch (Exception e) {
                    vo.setPrice(null);
                    vo.setErrorMsg("单价只能为数字或小数！");
                    errorList.add(vo);
                    continue;
                }
                vo.setSourceType(1);
                successList.add(vo);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("successNum", successList.size());
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }
}
