package com.ejianc.business.cost.service.impl;

import com.ejianc.business.cost.bean.GuidePriceDetailEntity;
import com.ejianc.business.cost.mapper.GuidePriceDetailMapper;
import com.ejianc.business.cost.service.IGuidePriceDetailService;
import com.ejianc.business.cost.vo.GuidePriceDetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 指导价-价格明细
 *
 * @author generator
 */
@Service("guidePriceDetailService")
public class GuidePriceDetailServiceImpl extends BaseServiceImpl<GuidePriceDetailMapper, GuidePriceDetailEntity> implements IGuidePriceDetailService {


    @Autowired
    private GuidePriceDetailMapper mapper;

    @Override
    public CommonResponse<List<GuidePriceDetailVO>> queryGuidePriceDetailData(List<GuidePriceDetailVO> detailVOList) {
        Map<Long, List<GuidePriceDetailVO>> byCollect = detailVOList.stream().collect(Collectors.groupingBy(e -> e.getMaterialId()));
        List<String> materialIds = Arrays.asList(byCollect.keySet().toArray(new String[0]));
        List<GuidePriceDetailEntity> queryList = mapper.queryDetailByMaterialIds(materialIds);
        Map<Long, List<GuidePriceDetailEntity>> queryCollect = queryList.stream().collect(Collectors.groupingBy(e -> e.getMaterialId()));
        for (GuidePriceDetailVO byDetail :detailVOList ){
            if (queryCollect.containsKey(byDetail.getMaterialId())){
                List<GuidePriceDetailEntity> guidePriceDetailEntities = queryCollect.get(byDetail.getMaterialId());
                Map<String, List<GuidePriceDetailEntity>> brandNameMap = guidePriceDetailEntities.stream().collect(Collectors.groupingBy(e -> e.getBrandName()));
                if (brandNameMap.containsKey(byDetail.getBrandName())){
                    List<GuidePriceDetailEntity> guidePriceDetailEntities1 = brandNameMap.get(byDetail.getBrandName());
                    if (CollectionUtils.isNotEmpty(guidePriceDetailEntities1)){
                        GuidePriceDetailEntity guidePriceDetailEntity = guidePriceDetailEntities1.get(0);
                        byDetail.setPrice(guidePriceDetailEntity.getPrice());
                    }
                }
            }
        }
        return CommonResponse.success(detailVOList);
    }
}
