/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.BudgetSetDetailEntity;
import com.ejianc.business.budget.bean.BudgetSetFeaturesEntity;
import com.ejianc.business.budget.bean.BudgetSetQuotaEntity;
import com.ejianc.business.budget.service.IBudgetSetDetailService;
import com.ejianc.business.budget.vo.BudgetSetDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"budgetSetDetail"})
public class BudgetSetDetailController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IBudgetSetDetailService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BudgetSetDetailVO> saveOrUpdate(@RequestBody BudgetSetDetailVO saveOrUpdateVO) {
        List nameList;
        BudgetSetDetailEntity entity = (BudgetSetDetailEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, BudgetSetDetailEntity.class));
        if (CollectionUtils.isNotEmpty(entity.getQuotaList())) {
            nameList = entity.getQuotaList().stream().map(BudgetSetQuotaEntity::getQuotaName).collect(Collectors.toList());
            entity.setQuotaName(StringUtils.join(nameList, (String)","));
        }
        if (CollectionUtils.isNotEmpty(entity.getFeaturesList())) {
            nameList = entity.getFeaturesList().stream().map(BudgetSetFeaturesEntity::getFeaturesName).collect(Collectors.toList());
            entity.setFeatures(StringUtils.join(nameList, (String)","));
        }
        this.service.saveOrUpdate((Object)entity, false);
        BudgetSetDetailVO vo = (BudgetSetDetailVO)BeanMapper.map((Object)((Object)entity), BudgetSetDetailVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BudgetSetDetailVO> queryDetail(Long id) {
        BudgetSetDetailEntity entity = (BudgetSetDetailEntity)((Object)this.service.selectById(id));
        BudgetSetDetailVO vo = (BudgetSetDetailVO)BeanMapper.map((Object)((Object)entity), BudgetSetDetailVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetSetDetailVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (BudgetSetDetailVO budgetSetDetailVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BudgetSetDetailVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BudgetSetDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BudgetSetDetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refBudgetSetDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BudgetSetDetailVO>> refBudgetSetDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BudgetSetDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"BudgetSetDetail-import.xlsx", (String)"\u660e\u7ec6\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return this.service.excelImport(request);
    }
}

