/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.ejianc.business.budget.bean.BudgetProjectDetailEntity;
import com.ejianc.business.budget.bean.BudgetProjectEntity;
import com.ejianc.business.budget.mapper.BudgetProjectDetailMapper;
import com.ejianc.business.budget.service.IBudgetProjectDetailService;
import com.ejianc.business.budget.service.IBudgetProjectService;
import com.ejianc.business.budget.utils.ExcelImportUtil;
import com.ejianc.business.budget.vo.BudgetProjectDetailVO;
import com.ejianc.business.budget.vo.comparator.BudgetDetailComparatoeVo;
import com.ejianc.business.cost.utils.TreeNodeBUtil;
import com.ejianc.business.utils.HuaKangExcelReader;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="budgetProjectDetailService")
public class BudgetProjectDetailServiceImpl
extends BaseServiceImpl<BudgetProjectDetailMapper, BudgetProjectDetailEntity>
implements IBudgetProjectDetailService {
    @Autowired
    private IBudgetProjectService budgetProjectService;

    @Override
    public void deleteByBudgetId(Long id) {
        QueryWrapper deleteWrapper = new QueryWrapper();
        deleteWrapper.eq((Object)"budget_id", (Object)id);
        ((BudgetProjectDetailMapper)this.baseMapper).delete((Wrapper)deleteWrapper);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            ArrayList<BudgetProjectDetailVO> detailVoList = new ArrayList<BudgetProjectDetailVO>();
            HashMap<String, String> tidMap = new HashMap<String, String>();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                BudgetProjectDetailVO vo = new BudgetProjectDetailVO();
                boolean flag = false;
                boolean parentWarn = false;
                String warnType = "";
                String detailIndex = (String)datas.get(0);
                vo.setDetailIndex(detailIndex);
                String id = UUID.randomUUID().toString().replaceAll("-", "");
                if (StringUtils.isNotEmpty((CharSequence)detailIndex)) {
                    String[] split = detailIndex.split("[-/.]");
                    vo.setTid(id);
                    tidMap.put(detailIndex, id);
                    if (split.length > 1) {
                        vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                    }
                } else {
                    vo.setTid(id);
                    vo.setTpid("");
                }
                if (indexMap.containsKey(detailIndex)) {
                    return CommonResponse.error((String)("\u7b2c" + (i + 2) + "\u884c\u5e8f\u53f7\u548c\u7b2c" + ((Integer)indexMap.get(detailIndex) + 2) + "\u884c\u91cd\u590d"));
                }
                indexMap.put(detailIndex, i);
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(1)))) {
                    vo.setCode(null);
                    warnType = warnType + "\u7f16\u7801\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                } else {
                    vo.setCode((String)datas.get(1));
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(2)))) {
                    vo.setName(null);
                    warnType = warnType + "\u9879\u76ee\u540d\u79f0\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                } else {
                    vo.setName((String)datas.get(2));
                }
                vo.setProjectFeature((String)datas.get(3));
                vo.setUnit((String)datas.get(4));
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(5)))) {
                    vo.setNum(null);
                    warnType = warnType + "\u5de5\u7a0b\u91cf\u4e3a\u7a7a,";
                    flag = true;
                } else {
                    try {
                        vo.setNum(new BigDecimal((String)datas.get(5)));
                    }
                    catch (Exception e) {
                        vo.setNum(null);
                        warnType = warnType + "\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(7)))) {
                    vo.setLaborCost(null);
                } else {
                    try {
                        vo.setLaborCost(new BigDecimal((String)datas.get(7)));
                    }
                    catch (Exception e) {
                        vo.setLaborCost(null);
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(8)))) {
                    vo.setMaterialCost(null);
                } else {
                    try {
                        vo.setMaterialCost(new BigDecimal((String)datas.get(8)));
                    }
                    catch (Exception e) {
                        vo.setMaterialCost(null);
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(9)))) {
                    vo.setMechanicalCost(null);
                } else {
                    try {
                        vo.setMechanicalCost(new BigDecimal((String)datas.get(9)));
                    }
                    catch (Exception e) {
                        vo.setMechanicalCost(null);
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(10)))) {
                    vo.setOtherCost(null);
                } else {
                    try {
                        vo.setOtherCost(new BigDecimal((String)datas.get(10)));
                    }
                    catch (Exception e) {
                        vo.setOtherCost(null);
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(11)))) {
                    vo.setMny(null);
                    warnType = warnType + "\u5408\u4ef7\u4e3a\u7a7a,";
                    flag = true;
                } else {
                    try {
                        vo.setMny(new BigDecimal((String)datas.get(11)));
                    }
                    catch (Exception e) {
                        vo.setMny(null);
                        warnType = warnType + "\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                        flag = true;
                    }
                }
                if (null == vo.getNum() || null == vo.getMny()) {
                    vo.setPrice(null);
                } else if (vo.getNum().compareTo(BigDecimal.ZERO) == 0) {
                    vo.setPrice(null);
                } else {
                    vo.setPrice(vo.getMny().divide(vo.getNum(), 20, 6));
                }
                vo.setImportFlag(Boolean.valueOf(!flag));
                vo.setParentWarn(Boolean.valueOf(parentWarn));
                if (flag) {
                    warnType = warnType.substring(0, warnType.length() - 1);
                }
                vo.setWarnType(warnType);
                vo.setRowState("add");
                vo.setShadowId(vo.getTid());
                vo.setChangeType(Integer.valueOf(3));
                detailVoList.add(vo);
            }
            for (BudgetProjectDetailVO tVo : detailVoList) {
                tVo.setTpid((String)tidMap.get(tVo.getTpid()));
            }
            List deailTreeData = ExcelImportUtil.treeData((List)BeanMapper.mapList(detailVoList, Map.class));
            List mapList = ExcelImportUtil.importFlag((List)deailTreeData);
            ArrayList falseList = new ArrayList();
            List allList = ExcelImportUtil.separate((List)mapList, falseList);
            List errorList = ExcelImportUtil.treeToList((List)((List)allList.get(1)));
            resp.put("successList", allList.get(0));
            resp.put("errorList", (Object)errorList);
            resp.put("successNum", (Object)(result.size() - errorList.size()));
            resp.put("errorNum", (Object)errorList.size());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }

    @Override
    public List<BudgetProjectDetailVO> detailRef(Long projectId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BudgetProjectEntity::getProjectId, (Object)projectId);
        queryWrapper.and(wrapper -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BudgetProjectEntity::getBillState, (Object)1)).or()).eq(BudgetProjectEntity::getBillState, (Object)3));
        BudgetProjectEntity entity = (BudgetProjectEntity)((Object)this.budgetProjectService.getOne((Wrapper)queryWrapper));
        List detailList = new ArrayList();
        if (entity != null && entity.getId() != null) {
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            wrapper2.eq(BudgetProjectDetailEntity::getBudgetId, (Object)entity.getId());
            wrapper2.ne(BudgetProjectDetailEntity::getChangeType, (Object)5);
            wrapper2.orderBy(true, true, (Object[])new SFunction[]{BudgetProjectDetailEntity::getDetailIndex});
            List entityList = super.list((Wrapper)wrapper2);
            if (CollectionUtils.isNotEmpty((Collection)entityList)) {
                for (BudgetProjectDetailEntity i : entityList) {
                    i.setTid(i.getId().toString());
                    i.setTpid(i.getParentId() != null && i.getParentId() > 0L ? i.getParentId().toString() : "");
                }
            }
            detailList = BeanMapper.mapList((Iterable)entityList, BudgetProjectDetailVO.class);
            Collections.sort(detailList, new BudgetDetailComparatoeVo());
        }
        return TreeNodeBUtil.buildTree(detailList);
    }

    @Override
    public CommonResponse<JSONObject> excelImportHk(HttpServletRequest request, HttpServletResponse response) {
        Integer projNameLine = Integer.valueOf(request.getParameter("projNameLine"));
        Integer beginLine = Integer.valueOf(request.getParameter("beginLine"));
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List result = HuaKangExcelReader.readExcel((MultipartFile)mf, (Integer)projNameLine, (Integer)beginLine);
        if (result != null && result.size() > 0) {
            int engineeringNameIndex = 0;
            int nameIndex = 0;
            int itemIndex = 0;
            String engineeringtpid = "";
            String tpid = "";
            LinkedList<BudgetProjectDetailVO> detailVoList = new LinkedList<BudgetProjectDetailVO>();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                BudgetProjectDetailVO vo = new BudgetProjectDetailVO();
                boolean flag = false;
                boolean parentWarn = false;
                vo.setSheetName((String)datas.get(0));
                String detailIndex = (String)datas.get(1);
                String code = (String)datas.get(2);
                String name = (String)datas.get(3);
                if (StringUtils.isEmpty((CharSequence)code) || StringUtils.isEmpty((CharSequence)detailIndex)) {
                    String key;
                    if (StringUtils.isNotEmpty((CharSequence)detailIndex)) {
                        if (detailIndex.contains("\u5de5\u7a0b\u540d\u79f0")) {
                            String engineeringName = detailIndex.replaceAll("\u5de5\u7a0b\u540d\u79f0\uff1a", "").trim();
                            vo.setDetailIndex(String.valueOf(++engineeringNameIndex));
                            vo.setName(engineeringName);
                            engineeringtpid = vo.getDetailIndex();
                            vo.setTid(vo.getDetailIndex());
                            nameIndex = 0;
                            vo.setImportFlag(Boolean.valueOf(true));
                            vo.setParentWarn(Boolean.valueOf(false));
                            vo.setRowState("add");
                            vo.setShadowId(vo.getTid());
                            key = vo.getCode() + vo.getName() + vo.getUnit();
                            vo.setKey(key);
                            detailVoList.add(vo);
                            continue;
                        }
                        if (!StringUtils.isEmpty((CharSequence)name)) continue;
                        continue;
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)name) || "\u5206\u90e8\u5c0f\u8ba1".equals(name)) continue;
                    BudgetProjectDetailVO lastVO = (BudgetProjectDetailVO)detailVoList.get(detailVoList.size() - 1);
                    if (lastVO.getDetailIndex().contains(".") && lastVO.getDetailIndex().split("[-/.]").length == 2) {
                        vo.setDetailIndex(engineeringNameIndex + "." + nameIndex + ".1");
                        vo.setName(name);
                        vo.setTpid(tpid);
                        vo.setTid(vo.getDetailIndex());
                        tpid = vo.getDetailIndex();
                        itemIndex = 0;
                        vo.setImportFlag(Boolean.valueOf(true));
                        vo.setParentWarn(Boolean.valueOf(false));
                        vo.setRowState("add");
                        vo.setShadowId(vo.getTid());
                        key = vo.getCode() + vo.getName() + vo.getUnit();
                        vo.setKey(key);
                        detailVoList.add(vo);
                        continue;
                    }
                    vo.setDetailIndex(engineeringNameIndex + "." + ++nameIndex);
                    vo.setName(name);
                    vo.setTpid(engineeringtpid);
                    vo.setTid(vo.getDetailIndex());
                    tpid = vo.getDetailIndex();
                    itemIndex = 0;
                    vo.setImportFlag(Boolean.valueOf(true));
                    vo.setParentWarn(Boolean.valueOf(false));
                    vo.setRowState("add");
                    vo.setShadowId(vo.getTid());
                    key = vo.getCode() + vo.getName() + vo.getUnit();
                    vo.setKey(key);
                    detailVoList.add(vo);
                    continue;
                }
                String warnType = "";
                vo.setDetailIndex(tpid + "." + ++itemIndex);
                vo.setTid(vo.getDetailIndex());
                vo.setTpid(tpid);
                if (StringUtils.isEmpty((CharSequence)code)) {
                    vo.setCode(null);
                    warnType = warnType + "\u9879\u76ee\u7f16\u7801\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                } else {
                    vo.setCode(code);
                }
                if (StringUtils.isEmpty((CharSequence)name)) {
                    vo.setName(null);
                    warnType = warnType + "\u9879\u76ee\u540d\u79f0\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                } else {
                    vo.setName(name.replace(" ", ""));
                }
                vo.setProjectFeature((String)datas.get(4));
                vo.setUnit((String)datas.get(5));
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(6)))) {
                    vo.setNum(null);
                    warnType = warnType + "\u5de5\u7a0b\u91cf\u4e3a\u7a7a,";
                    flag = true;
                } else {
                    try {
                        vo.setNum(new BigDecimal((String)datas.get(6)));
                    }
                    catch (Exception e) {
                        vo.setNum(null);
                        warnType = warnType + "\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(7)))) {
                    vo.setPrice(null);
                    warnType = warnType + "\u7efc\u5408\u5355\u4ef7\u4e3a\u7a7a,";
                    flag = true;
                } else {
                    try {
                        vo.setPrice(new BigDecimal((String)datas.get(7)));
                    }
                    catch (Exception e) {
                        vo.setPrice(null);
                        warnType = warnType + "\u7efc\u5408\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(8)))) {
                    vo.setMny(null);
                    warnType = warnType + "\u5408\u4ef7\u4e3a\u7a7a,";
                    flag = true;
                } else {
                    try {
                        vo.setMny(new BigDecimal((String)datas.get(8)));
                    }
                    catch (Exception e) {
                        vo.setMny(null);
                        warnType = warnType + "\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                        flag = true;
                    }
                }
                if (null == vo.getNum() || null == vo.getMny()) {
                    vo.setPrice(null);
                } else if (vo.getNum().compareTo(BigDecimal.ZERO) == 0) {
                    vo.setPrice(null);
                } else {
                    vo.setPrice(vo.getMny().divide(vo.getNum(), 20, 6));
                    vo.setPrice(ComputeUtil.scale((BigDecimal)ComputeUtil.safeDiv((BigDecimal)vo.getMny(), (BigDecimal)vo.getNum()), (int)4));
                }
                vo.setImportFlag(Boolean.valueOf(!flag));
                vo.setParentWarn(Boolean.valueOf(parentWarn));
                if (flag) {
                    warnType = warnType.substring(0, warnType.length() - 1);
                }
                vo.setWarnType(warnType);
                vo.setRowState("add");
                vo.setShadowId(vo.getTid());
                vo.setChangeType(Integer.valueOf(3));
                detailVoList.add(vo);
            }
            List deailTreeData = ExcelImportUtil.treeData((List)BeanMapper.mapList(detailVoList, Map.class));
            List mapList = ExcelImportUtil.importFlag((List)deailTreeData);
            ArrayList falseList = new ArrayList();
            List allList = ExcelImportUtil.separate((List)mapList, falseList);
            List errorList = ExcelImportUtil.treeToList((List)((List)allList.get(1)));
            resp.put("successList", allList.get(0));
            resp.put("errorList", (Object)errorList);
            resp.put("successNum", (Object)(result.size() - errorList.size()));
            resp.put("errorNum", (Object)errorList.size());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }
}

