/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.budget.bean.BudgetSetDetailEntity;
import com.ejianc.business.budget.bean.BudgetSetEntity;
import com.ejianc.business.budget.bean.BudgetSetFeaturesEntity;
import com.ejianc.business.budget.bean.BudgetSetQuotaEntity;
import com.ejianc.business.budget.mapper.BudgetSetMapper;
import com.ejianc.business.budget.service.IBudgetSetDetailService;
import com.ejianc.business.budget.service.IBudgetSetFeaturesService;
import com.ejianc.business.budget.service.IBudgetSetQuotaService;
import com.ejianc.business.budget.service.IBudgetSetService;
import com.ejianc.business.budget.vo.BudgetSetTypeVO;
import com.ejianc.business.budget.vo.BudgetSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="budgetSetService")
public class BudgetSetServiceImpl
extends BaseServiceImpl<BudgetSetMapper, BudgetSetEntity>
implements IBudgetSetService {
    private static final String BILL_CODE = "BUDGET_SET";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IBudgetSetDetailService budgetSetDetailService;
    @Autowired
    private IBudgetSetQuotaService budgetSetQuotaService;
    @Autowired
    private IBudgetSetFeaturesService budgetSetFeaturesService;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public BudgetSetVO saveOrUpdate(BudgetSetVO saveOrUpdateVO) {
        if (null == saveOrUpdateVO.getEnableState()) {
            saveOrUpdateVO.setEnableState(Integer.valueOf(0));
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.ne(null != saveOrUpdateVO.getId(), BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        queryWrapper.eq(BudgetSetEntity::getName, (Object)StringUtils.trim((String)saveOrUpdateVO.getName()));
        if (this.count((Wrapper)queryWrapper) > 0) {
            throw new BusinessException("\u540d\u79f0\u91cd\u590d,\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        BudgetSetEntity entity = (BudgetSetEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, BudgetSetEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38,\u7f16\u7801\u751f\u6210\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            UserContext userContext = this.sessionManager.getUserContext();
            entity.setOrgId(userContext.getOrgId());
            entity.setOrgName(userContext.getOrgName());
            entity.setOrgCode(userContext.getOrgCode());
        }
        this.saveOrUpdate((Object)entity, false);
        BudgetSetVO vo = (BudgetSetVO)BeanMapper.map((Object)((Object)entity), BudgetSetVO.class);
        return vo;
    }

    @Override
    public BudgetSetVO copySave(BudgetSetVO budgetSetVO) {
        Long mainId = IdWorker.getId();
        HashMap<Long, Long> typeIdMap = new HashMap<Long, Long>();
        HashMap<Long, Long> detailIdMap = new HashMap<Long, Long>();
        BudgetSetEntity setEntity = (BudgetSetEntity)((Object)this.selectById(budgetSetVO.getCopyId()));
        budgetSetVO = (BudgetSetVO)BeanMapper.map((Object)((Object)setEntity), BudgetSetVO.class);
        budgetSetVO.setId(mainId);
        budgetSetVO.setName(budgetSetVO.getName() + "(\u526f\u672c)");
        budgetSetVO.setBillState(Integer.valueOf(0));
        budgetSetVO.setEnableState(Integer.valueOf(0));
        this.clearData((BaseVO)budgetSetVO);
        for (BudgetSetTypeVO typeVO : budgetSetVO.getTypeList()) {
            Long id = IdWorker.getId();
            typeIdMap.put(typeVO.getId(), id);
            typeVO.setId(id);
            typeVO.setSetId(mainId);
            this.clearData((BaseVO)typeVO);
        }
        this.saveOrUpdate(budgetSetVO);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BudgetSetDetailEntity::getSetId, (Object)budgetSetVO.getCopyId());
        List detailEntities = this.budgetSetDetailService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)detailEntities)) {
            for (BudgetSetDetailEntity detailEntity : detailEntities) {
                Long id = IdWorker.getId();
                detailIdMap.put(detailEntity.getId(), id);
                detailEntity.setId(id);
                detailEntity.setSetTypeId((Long)typeIdMap.get(detailEntity.getSetTypeId()));
                detailEntity.setSetId(mainId);
                this.clearData(detailEntity);
            }
            this.budgetSetDetailService.saveBatch(detailEntities);
        }
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BudgetSetQuotaEntity::getSetId, (Object)budgetSetVO.getCopyId());
        List matEntities = this.budgetSetQuotaService.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)matEntities)) {
            for (BudgetSetQuotaEntity matEntity : matEntities) {
                Long id = IdWorker.getId();
                matEntity.setId(id);
                matEntity.setSetTypeId((Long)typeIdMap.get(matEntity.getSetTypeId()));
                matEntity.setSetDetailId((Long)detailIdMap.get(matEntity.getSetDetailId()));
                matEntity.setQuotaId(mainId);
                this.clearData(matEntity);
            }
            this.budgetSetQuotaService.saveBatch(matEntities);
        }
        LambdaQueryWrapper qry = new LambdaQueryWrapper();
        qry.eq(BudgetSetFeaturesEntity::getSetId, (Object)budgetSetVO.getCopyId());
        List featEntities = this.budgetSetFeaturesService.list((Wrapper)qry);
        if (CollectionUtils.isNotEmpty((Collection)featEntities)) {
            for (BudgetSetFeaturesEntity featuresEntity : featEntities) {
                Long id = IdWorker.getId();
                featuresEntity.setId(id);
                featuresEntity.setSetTypeId((Long)typeIdMap.get(featuresEntity.getSetTypeId()));
                featuresEntity.setSetDetailId((Long)detailIdMap.get(featuresEntity.getSetDetailId()));
                featuresEntity.setSetId(mainId);
                this.clearData(featuresEntity);
            }
            this.budgetSetFeaturesService.saveBatch(featEntities);
        }
        return (BudgetSetVO)BeanMapper.map((Object)this.selectById(mainId), BudgetSetVO.class);
    }

    private void clearData(BaseVO baseVO) {
        baseVO.setCreateTime(null);
        baseVO.setCreateUserCode(null);
        baseVO.setUpdateTime(null);
        baseVO.setUpdateUserCode(null);
    }

    private void clearData(BaseEntity baseEntity) {
        baseEntity.setCreateTime(null);
        baseEntity.setCreateUserCode(null);
        baseEntity.setUpdateTime(null);
        baseEntity.setUpdateUserCode(null);
    }
}

